/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.editor.colors.OCFileHighlighter;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExportDeclaration;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCModuleDeclaration;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.impl.OCDefineDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class OCBasicHighlighter
extends OCAnnotator {
    @Override
    public void visitDefineDirective(@NotNull OCDefineDirectiveImpl directive) {
        if (directive == null) {
            OCBasicHighlighter.$$$reportNull$$$0(0);
        }
        this.highlight(directive.getNameIdentifier(), OCHighlightingKeys.MACRONAME);
        this.visitDirective(directive);
    }

    @Override
    public void visitDirective(@NotNull OCDirective directive) {
        if (directive == null) {
            OCBasicHighlighter.$$$reportNull$$$0(1);
        }
        this.highlightRawStrings(directive);
    }

    @Override
    public void visitMacroReferenceElement(OCMacroReferenceElementImpl element) {
        this.highlight(element, OCHighlightingKeys.MACRONAME);
    }

    @Override
    public void visitMacroCall(OCMacroCall macroCall) {
        OCReferenceElement element = macroCall.getMacroReferenceElement();
        if (!(element instanceof OCMacroReferenceElementImpl)) {
            this.highlight(element, OCHighlightingKeys.MACRONAME);
        }
        super.visitMacroCall(macroCall);
    }

    public void visitComment(@NotNull PsiComment comment) {
        IElementType tt;
        ASTNode node;
        if (comment == null) {
            OCBasicHighlighter.$$$reportNull$$$0(2);
        }
        if ((node = comment.getNode()) != null && (tt = node.getElementType()) == OCLexerTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT && this.getHolder() != null) {
            this.getHolder().newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(OCHighlightingKeys.CONDITIONALLY_NOT_COMPILED).create();
        }
    }

    @Override
    public void visitLiteralExpression(@NotNull OCLiteralExpression expression) {
        List injectedFiles;
        if (expression == null) {
            OCBasicHighlighter.$$$reportNull$$$0(3);
        }
        if ((injectedFiles = InjectedLanguageManager.getInstance((Project)expression.getProject()).getInjectedPsiFiles((PsiElement)expression)) != null && !injectedFiles.isEmpty()) {
            return;
        }
        this.highlightRawStrings(expression);
    }

    private void highlightRawStrings(@NotNull OCElement expression) {
        if (expression == null) {
            OCBasicHighlighter.$$$reportNull$$$0(4);
        }
        OCFileHighlighter fhl = null;
        Lexer lexer = null;
        String text = null;
        for (ASTNode child = expression.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!OCLexerTokenTypes.RAW_STRING_LITERALS.contains(OCElementUtil.getElementType(child))) continue;
            if (fhl == null) {
                fhl = new OCFileHighlighter(OCLexerSettings.forLanguage((OCLanguageKind)CLanguageKind.CPP).forHighlighting().build());
                lexer = fhl.getHighlightingLexer();
                text = expression.getContainingFile().getText();
            }
            TextRange range = child.getTextRange();
            lexer.start(text, range.getStartOffset(), range.getEndOffset());
            while (lexer.getTokenType() != null) {
                TextRange tr = new TextRange(lexer.getTokenStart(), lexer.getTokenEnd());
                TextAttributesKey[] ta = fhl.getTokenHighlights(lexer.getTokenType());
                if (ta.length > 0) {
                    this.highlight(tr, ta[0]);
                }
                lexer.advance();
            }
        }
    }

    private void highlightVirtSpecifier(@NotNull OCElement element) {
        if (element == null) {
            OCBasicHighlighter.$$$reportNull$$$0(5);
        }
        if (!element.getContainingOCFile().isCpp()) {
            return;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!OCLexerTokenTypes.CPP_VIRTUAL_SPECIFIERS.contains(OCElementUtil.getElementType(child))) continue;
            this.highlight(child, OCHighlightingKeys.OC_KEYWORD);
        }
    }

    @Override
    public void visitDeclarator(@NotNull OCDeclarator declarator) {
        if (declarator == null) {
            OCBasicHighlighter.$$$reportNull$$$0(6);
        }
        this.highlightVirtSpecifier(declarator);
    }

    @Override
    public void visitStructLike(@NotNull OCStructLike struct) {
        if (struct == null) {
            OCBasicHighlighter.$$$reportNull$$$0(7);
        }
        this.highlightVirtSpecifier(struct);
    }

    @Override
    public void visitExportDeclaration(OCExportDeclaration exportDecl) {
        this.highlight(exportDecl.getModuleKeyword(), OCHighlightingKeys.OC_KEYWORD);
    }

    @Override
    public void visitModuleDeclaration(OCModuleDeclaration moduleDecl) {
        this.highlight(moduleDecl.getModuleKeyword(), OCHighlightingKeys.OC_KEYWORD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directive";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "struct";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCBasicHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDefineDirective";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDirective";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLiteralExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightRawStrings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightVirtSpecifier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDeclarator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitStructLike";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

