/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.switchHeaderSource;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSHandlerImpl;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "headerExtensions", "", "", "sourceExtensions", "isSourceFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isHeaderFile", "intellij.c.core"})
public final class OCSwitchHSUtilKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Set<String> headerExtensions;
    @NotNull
    private static final Set<String> sourceExtensions;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSourceFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isDirectory()) return false;
        String string = file.getExtension();
        if (string == null) {
            string = "";
        }
        if (!sourceExtensions.contains(string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isHeaderFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isDirectory()) return false;
        String string = file.getExtension();
        if (string == null) {
            string = "";
        }
        if (!headerExtensions.contains(string)) return false;
        return true;
    }

    static {
        Logger logger = Logger.getInstance(OCSwitchHSHandlerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Set set = OCFileTypeHelpers.headerExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"headerExtensions(...)");
        Object[] objectArray = new String[]{"", "pch"};
        headerExtensions = SetsKt.minus((Set)set, (Iterable)SetsKt.setOf((Object[])objectArray));
        Set set2 = OCFileTypeHelpers.sourceExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"sourceExtensions(...)");
        sourceExtensions = set2;
    }
}

