/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.switchHeaderSource;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSHandler;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSHandlerImpl;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSListener;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSRecentCache;
import com.jetbrains.cidr.lang.actions.switchHeaderSource.OCSwitchHSUtilKt;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u001f\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010!H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$H\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030$H\u0002J\n\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u001a\u0010(\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010)\u001a\n +*\u0004\u0018\u00010*0*H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSHandlerImpl;", "Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSHandler;", "source", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)V", "getSource", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "items", "", "indicator", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "future", "Ljava/util/concurrent/CompletableFuture;", "", "invoke", "listener", "Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSListener;", "cancel", "notifyTargetChosen", "target", "process", "handleCached", "handleFileBased", "canBeTarget", "", "handleSameDefinitions", "shouldConsiderThisSymbol", "symbol", "Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "sourceSymbol", "includedInSource", "", "includersForSource", "psiSource", "Lcom/jetbrains/cidr/lang/psi/OCFile;", "addIfNeeded", "getRecentCache", "Lcom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSRecentCache;", "kotlin.jvm.PlatformType", "intellij.c.core"})
@SourceDebugExtension(value={"SMAP\nOCSwitchHSHandlerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OCSwitchHSHandlerImpl.kt\ncom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSHandlerImpl\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n3829#2:187\n4344#2,2:188\n1869#3,2:190\n1617#3,9:192\n1869#3:201\n1870#3:203\n1626#3:204\n1#4:202\n*S KotlinDebug\n*F\n+ 1 OCSwitchHSHandlerImpl.kt\ncom/jetbrains/cidr/lang/actions/switchHeaderSource/OCSwitchHSHandlerImpl\n*L\n66#1:187\n66#1:188,2\n69#1:190,2\n165#1:192,9\n165#1:201\n165#1:203\n165#1:204\n165#1:202\n*E\n"})
public final class OCSwitchHSHandlerImpl
implements OCSwitchHSHandler {
    @NotNull
    private final VirtualFile source;
    @NotNull
    private final Project project;
    @NotNull
    private final Set<VirtualFile> items;
    @NotNull
    private final EmptyProgressIndicator indicator;
    @NotNull
    private final CompletableFuture<Unit> future;

    public OCSwitchHSHandlerImpl(@NotNull VirtualFile source, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.source = source;
        this.project = project;
        this.items = new LinkedHashSet();
        this.indicator = new EmptyProgressIndicator();
        this.future = new CompletableFuture();
    }

    @NotNull
    public final VirtualFile getSource() {
        return this.source;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void invoke(@NotNull OCSwitchHSListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ReadAction.nonBlocking(() -> OCSwitchHSHandlerImpl.invoke$lambda$0(this, listener)).inSmartMode(this.project).wrapProgress((ProgressIndicator)this.indicator).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> OCSwitchHSHandlerImpl.invoke$lambda$2(arg_0 -> OCSwitchHSHandlerImpl.invoke$lambda$1(this, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> future() {
        return this.future;
    }

    @Override
    public void cancel() {
        this.indicator.cancel();
    }

    @Override
    public void notifyTargetChosen(@NotNull VirtualFile target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.getRecentCache().putTarget(this.source, target);
    }

    private final void process(OCSwitchHSListener listener) {
        listener.onComputationStarted();
        this.handleCached(listener);
        ProgressManager.checkCanceled();
        this.handleFileBased(listener);
        ProgressManager.checkCanceled();
        this.handleSameDefinitions(listener);
        ProgressManager.checkCanceled();
        this.future.complete(Unit.INSTANCE);
        listener.onComputationFinished();
    }

    private final void handleCached(OCSwitchHSListener listener) {
        this.addIfNeeded(listener, this.getRecentCache().getLastUsedTargetIfExists(this.source));
    }

    /*
     * Unable to fully structure code
     */
    private final void handleFileBased(OCSwitchHSListener listener) {
        block4: {
            var2_2 = this.source.getParent();
            if (var2_2 == null || (var3_3 = var2_2.getChildren()) == null) break block4;
            var4_4 = var3_3;
            $i$f$filter = false;
            var6_6 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            var10_11 = ((void)$this$filterTo$iv$iv).length;
            for (var9_10 = 0; var9_10 < var10_11; ++var9_10) {
                it = element$iv$iv = $this$filterTo$iv$iv[var9_10];
                $i$a$-filter-OCSwitchHSHandlerImpl$handleFileBased$1 = false;
                if (!StringUtil.equalsIgnoreCase((CharSequence)this.source.getNameWithoutExtension(), (CharSequence)it.getNameWithoutExtension())) ** GOTO lbl-1000
                Intrinsics.checkNotNull((Object)it);
                if (this.canBeTarget(this.source, (VirtualFile)it)) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!v0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (VirtualFile)element$iv;
                $i$a$-forEach-OCSwitchHSHandlerImpl$handleFileBased$2 = false;
                this.addIfNeeded(listener, it);
            }
        }
    }

    private final boolean canBeTarget(VirtualFile source, VirtualFile target) {
        return Intrinsics.areEqual((Object)source, (Object)target) ? false : (OCSwitchHSUtilKt.isSourceFile(target) ? OCSwitchHSUtilKt.isHeaderFile(source) : OCSwitchHSUtilKt.isHeaderFile(target));
    }

    private final void handleSameDefinitions(OCSwitchHSListener listener) {
        block0: {
            Set possibleFiles = SetsKt.plus(this.includedInSource(), (Iterable)this.includersForSource());
            OCFile oCFile = this.psiSource();
            if (oCFile == null) break block0;
            oCFile.accept(new OCRecursiveVisitor(this, possibleFiles, listener){
                final /* synthetic */ OCSwitchHSHandlerImpl this$0;
                final /* synthetic */ Set<VirtualFile> $possibleFiles;
                final /* synthetic */ OCSwitchHSListener $listener;
                {
                    this.this$0 = $receiver;
                    this.$possibleFiles = $possibleFiles;
                    this.$listener = $listener;
                }

                public void visitFunctionDeclaration(OCFunctionDeclaration declaration) {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    this.processSymbol(declaration.getSymbol());
                    super.visitFunctionDeclaration(declaration);
                }

                public void visitFunctionDefinition(OCFunctionDefinition definition) {
                    Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
                    this.processSymbol(definition.getSymbol());
                    super.visitFunctionDefinition(definition);
                }

                public void visitClassDeclaration(OCClassDeclaration<?> dcl) {
                    Intrinsics.checkNotNullParameter(dcl, (String)"dcl");
                    this.processSymbol(dcl.getSymbol());
                    super.visitClassDeclaration(dcl);
                }

                private final void processSymbol(OCSymbol symbol) {
                    block1: {
                        if (!OCSwitchHSHandlerImpl.shouldConsiderThisSymbol$default(this.this$0, symbol, null, 2, null)) break block1;
                        OCSymbol oCSymbol = symbol;
                        if (oCSymbol != null) {
                            oCSymbol.processSameSymbols((Processor<OCSymbol>)((Processor)arg_0 -> handleSameDefinitions.1.processSymbol$lambda$0(this, symbol, arg_0)), this.this$0.getProject());
                        }
                    }
                }

                private final boolean sameSymbolsProcessor(OCSymbol symbol, OCSymbol sourceSymbol) {
                    VirtualFile file;
                    if (OCSwitchHSHandlerImpl.access$shouldConsiderThisSymbol(this.this$0, symbol, sourceSymbol) && (file = symbol.getContainingFile()) != null && this.$possibleFiles.contains(file) && OCSwitchHSHandlerImpl.access$canBeTarget(this.this$0, this.this$0.getSource(), file)) {
                        OCSwitchHSHandlerImpl.access$addIfNeeded(this.this$0, this.$listener, file);
                    }
                    return true;
                }

                private static final boolean processSymbol$lambda$0(handleSameDefinitions.1 this$0, OCSymbol $symbol, OCSymbol it) {
                    Intrinsics.checkNotNull((Object)it);
                    return this$0.sameSymbolsProcessor(it, $symbol);
                }
            });
        }
    }

    private final boolean shouldConsiderThisSymbol(OCSymbol symbol, OCSymbol sourceSymbol) {
        if (Intrinsics.areEqual((Object)symbol, (Object)sourceSymbol)) {
            return false;
        }
        if (symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isPredeclaration()) {
            return false;
        }
        if (symbol != null && sourceSymbol != null && symbol.isPredeclaration() == sourceSymbol.isPredeclaration()) {
            return false;
        }
        if (symbol instanceof OCTemplateSymbol && ((OCTemplateSymbol)symbol).isSpecialization() || sourceSymbol instanceof OCTemplateSymbol && ((OCTemplateSymbol)sourceSymbol).isSpecialization()) {
            return false;
        }
        if (symbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)symbol).isStatic() || sourceSymbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)sourceSymbol).isStatic()) {
            return false;
        }
        if (symbol instanceof OCSymbolWithQualifiedName && sourceSymbol instanceof OCSymbolWithQualifiedName) {
            OCTemplateSymbol sourceParent;
            OCSymbolWithQualifiedName oCSymbolWithQualifiedName = ((OCSymbolWithQualifiedName)symbol).getParent();
            OCTemplateSymbol parent = oCSymbolWithQualifiedName instanceof OCTemplateSymbol ? (OCTemplateSymbol)((Object)oCSymbolWithQualifiedName) : null;
            OCSymbolWithQualifiedName oCSymbolWithQualifiedName2 = ((OCSymbolWithQualifiedName)sourceSymbol).getParent();
            OCTemplateSymbol oCTemplateSymbol = sourceParent = oCSymbolWithQualifiedName2 instanceof OCTemplateSymbol ? (OCTemplateSymbol)((Object)oCSymbolWithQualifiedName2) : null;
            if (parent != null && sourceParent != null && (parent.isSpecialization() || sourceParent.isSpecialization())) {
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ boolean shouldConsiderThisSymbol$default(OCSwitchHSHandlerImpl oCSwitchHSHandlerImpl, OCSymbol oCSymbol, OCSymbol oCSymbol2, int n, Object object) {
        if ((n & 2) != 0) {
            oCSymbol2 = null;
        }
        return oCSwitchHSHandlerImpl.shouldConsiderThisSymbol(oCSymbol, oCSymbol2);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<VirtualFile> includedInSource() {
        void $this$mapNotNullTo$iv$iv;
        JBIterable jBIterable = SyntaxTraverser.psiTraverser().children((Object)this.psiSource()).filter(OCIncludeDirective.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        Iterable $this$mapNotNull$iv = (Iterable)jBIterable;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            OCIncludeDirective it = (OCIncludeDirective)element$iv$iv;
            boolean bl2 = false;
            PsiFile psiFile = it.getIncludedFile();
            if ((psiFile != null ? psiFile.getVirtualFile() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    private final Set<VirtualFile> includersForSource() {
        Collection<VirtualFile> collection = OCImportGraph.getInstance(this.project).findImmediateIncludingFiles(this.source, true);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"findImmediateIncludingFiles(...)");
        return CollectionsKt.toHashSet((Iterable)collection);
    }

    private final OCFile psiSource() {
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(this.source);
        return psiFile instanceof OCFile ? (OCFile)psiFile : null;
    }

    private final void addIfNeeded(OCSwitchHSListener listener, VirtualFile target) {
        ProgressManager.checkCanceled();
        if (target != null && !this.items.contains(target)) {
            this.items.add(target);
            listener.onItemAdded(target);
        }
    }

    private final OCSwitchHSRecentCache getRecentCache() {
        return (OCSwitchHSRecentCache)this.project.getService(OCSwitchHSRecentCache.class);
    }

    private static final void invoke$lambda$0(OCSwitchHSHandlerImpl this$0, OCSwitchHSListener $listener) {
        this$0.process($listener);
    }

    private static final Unit invoke$lambda$1(OCSwitchHSHandlerImpl this$0, Void it) {
        this$0.future.complete(Unit.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final void invoke$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$shouldConsiderThisSymbol(OCSwitchHSHandlerImpl $this, OCSymbol symbol, OCSymbol sourceSymbol) {
        return $this.shouldConsiderThisSymbol(symbol, sourceSymbol);
    }

    public static final /* synthetic */ boolean access$canBeTarget(OCSwitchHSHandlerImpl $this, VirtualFile source, VirtualFile target) {
        return $this.canBeTarget(source, target);
    }

    public static final /* synthetic */ void access$addIfNeeded(OCSwitchHSHandlerImpl $this, OCSwitchHSListener listener, VirtualFile target) {
        $this.addIfNeeded(listener, target);
    }
}

