/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.ui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class GradientJPanel
extends JPanel {
    private boolean useGradient = false;
    private Color bottomColor = null;
    private Color topColor = null;

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.useGradient = false;
    }

    public void setBackground(Color bottomColor, Color topColor) {
        this.bottomColor = bottomColor;
        this.topColor = topColor;
        this.useGradient = true;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.useGradient) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            int w = this.getWidth();
            int h = this.getHeight();
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.topColor, 0.0f, h, this.bottomColor);
            g2d.setPaint(gp);
            g2d.fillRect(0, 0, w, h);
        }
    }
}

