/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.CloudMatrixProgressAnimator;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestTreeRenderer;
import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.SMPoolOfTestIcons;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestsPresentationUtil {
    @NonNls
    private static final String NO_NAME_TEST = "<no name>";

    private GoogleCloudTestsPresentationUtil() {
    }

    public static void formatRootNodeWithChildren(GoogleCloudTestProxy.GoogleCloudRootTestProxy testProxy, GoogleCloudTestTreeRenderer renderer) {
        renderer.setIcon(GoogleCloudTestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties()));
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        String text = magnitude == TestStateInfo.Magnitude.RUNNING_INDEX ? SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.running.tests", (Object[])new Object[0]) : (magnitude == TestStateInfo.Magnitude.TERMINATED_INDEX ? SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.was.terminated", (Object[])new Object[0]) : (magnitude == TestStateInfo.Magnitude.TIMEOUT_INDEX ? "Timed out" : (magnitude == TestStateInfo.Magnitude.INFRASTRUCTURE_FAILURE_INDEX ? "Infrastructure failure" : (magnitude == TestStateInfo.Magnitude.TRIGGERING_ERROR_INDEX ? "Triggering error" : SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.test.results", (Object[])new Object[0])))));
        renderer.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public static void formatRootNodeWithoutChildren(GoogleCloudTestProxy.GoogleCloudRootTestProxy testProxy, GoogleCloudTestTreeRenderer renderer) {
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        if (magnitude == TestStateInfo.Magnitude.RUNNING_INDEX) {
            renderer.setIcon(GoogleCloudTestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties()));
            renderer.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.instantiating.tests", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.NOT_RUN_INDEX) {
            renderer.setIcon(PoolOfTestIcons.NOT_RAN);
            renderer.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.not.test.results", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.TERMINATED_INDEX) {
            renderer.setIcon(PoolOfTestIcons.TERMINATED_ICON);
            renderer.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.was.terminated", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.PASSED_INDEX) {
            renderer.setIcon(PoolOfTestIcons.PASSED_ICON);
            renderer.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.all.tests.passed", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (!testProxy.getChildren().isEmpty()) {
            GoogleCloudTestsPresentationUtil.formatRootNodeWithChildren(testProxy, renderer);
        } else {
            renderer.setIcon(PoolOfTestIcons.NOT_RAN);
            renderer.append(testProxy.isTestsReporterAttached() ? SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", (Object[])new Object[0]) : SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.test.reporter.not.attached", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    public static void formatTestProxy(GoogleCloudTestProxy testProxy, GoogleCloudTestTreeRenderer renderer) {
        renderer.setIcon(GoogleCloudTestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties()));
        renderer.append(testProxy.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @NotNull
    public static String getPresentableName(GoogleCloudTestProxy testProxy) {
        String parentName;
        String name;
        GoogleCloudTestProxy parent = testProxy.getParent();
        String presentationCandidate = name = testProxy.getName();
        if (parent != null && name.startsWith(parentName = parent.getName()) && (presentationCandidate = name.substring(parentName.length())).startsWith(".")) {
            presentationCandidate = presentationCandidate.substring(1);
        }
        presentationCandidate = presentationCandidate.trim();
        if (StringUtil.isEmpty((String)(presentationCandidate = presentationCandidate.replaceAll("\\s+", " ")))) {
            return NO_NAME_TEST;
        }
        return presentationCandidate;
    }

    @NotNull
    public static String getPresentableNameTrimmedOnly(@NotNull GoogleCloudTestProxy testProxy) {
        String name = testProxy.getName();
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.isEmpty()) {
            name = NO_NAME_TEST;
        }
        return name;
    }

    @Nullable
    private static Icon getIcon(GoogleCloudTestProxy testProxy, TestConsoleProperties consoleProperties) {
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        boolean hasErrors = testProxy.hasErrors();
        switch (magnitude) {
            case ERROR_INDEX: {
                return PoolOfTestIcons.ERROR_ICON;
            }
            case FAILED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.FAILED_E_ICON : PoolOfTestIcons.FAILED_ICON;
            }
            case IGNORED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.IGNORED_E_ICON : PoolOfTestIcons.IGNORED_ICON;
            }
            case NOT_RUN_INDEX: {
                return PoolOfTestIcons.NOT_RAN;
            }
            case COMPLETE_INDEX: 
            case PASSED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.PASSED_E_ICON : PoolOfTestIcons.PASSED_ICON;
            }
            case SCHEDULED_INDEX: {
                return testProxy.isActiveScheduled() ? CloudMatrixProgressAnimator.getCurrentFrame() : AllIcons.Process.Step_passive;
            }
            case TIMEOUT_INDEX: {
                return AllIcons.Debugger.KillProcess;
            }
            case INFRASTRUCTURE_FAILURE_INDEX: {
                return AllIcons.Debugger.Db_exception_breakpoint;
            }
            case TRIGGERING_ERROR_INDEX: {
                return AllIcons.Debugger.Db_invalid_breakpoint;
            }
            case RUNNING_INDEX: {
                if (consoleProperties.isPaused()) {
                    return hasErrors ? SMPoolOfTestIcons.PAUSED_E_ICON : AllIcons.RunConfigurations.TestPaused;
                }
                return hasErrors ? SMPoolOfTestIcons.RUNNING_E_ICON : SMPoolOfTestIcons.RUNNING_ICON;
            }
            case SKIPPED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.SKIPPED_E_ICON : PoolOfTestIcons.SKIPPED_ICON;
            }
            case TERMINATED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.TERMINATED_E_ICON : PoolOfTestIcons.TERMINATED_ICON;
            }
        }
        return null;
    }
}

