/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestEventsListener;
import com.google.gct.testing.results.events.GoogleCloudTestFailedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestFinishedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestIgnoredEvent;
import com.google.gct.testing.results.events.GoogleCloudTestOutputEvent;
import com.google.gct.testing.results.events.GoogleCloudTestStartedEvent;
import com.google.gct.testing.results.events.SetActiveCloudMatrixEvent;
import com.google.gct.testing.results.events.SetTestRunIdEvent;
import com.google.gct.testing.results.events.TestConfigurationFinishedEvent;
import com.google.gct.testing.results.events.TestConfigurationProgressEvent;
import com.google.gct.testing.results.events.TestConfigurationScheduledEvent;
import com.google.gct.testing.results.events.TestConfigurationStartedEvent;
import com.google.gct.testing.results.events.TestConfigurationStoppedEvent;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.util.Processor;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.UIUtil;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoogleCloudTestEventsProcessor
implements Disposable {
    private TransferToEDTQueue<Runnable> myTransferToEDTQueue = new TransferToEDTQueue("SM queue", (Processor)new Processor<Runnable>(this){

        public boolean process(Runnable runnable) {
            runnable.run();
            return true;
        }
    }, this.getDisposedCondition(), 300);

    public abstract void onStartTesting();

    public abstract void onTestsCountInSuite(int var1);

    public abstract void onTestStarted(@NotNull GoogleCloudTestStartedEvent var1);

    public abstract void onTestFinished(@NotNull GoogleCloudTestFinishedEvent var1);

    public abstract void onTestFailure(@NotNull GoogleCloudTestFailedEvent var1);

    public abstract void onTestIgnored(@NotNull GoogleCloudTestIgnoredEvent var1);

    public abstract void onTestOutput(@NotNull GoogleCloudTestOutputEvent var1);

    public abstract void onSuiteStarted(@NotNull TestSuiteStartedEvent var1);

    public abstract void onSuiteFinished(@NotNull TestSuiteFinishedEvent var1);

    public abstract void onSetTestRunId(@NotNull SetTestRunIdEvent var1);

    public abstract void onSetActiveCloudMatrix(@NotNull SetActiveCloudMatrixEvent var1);

    public abstract void onConfigurationStopped(@NotNull TestConfigurationStoppedEvent var1);

    public abstract void onConfigurationStarted(@NotNull TestConfigurationStartedEvent var1);

    public abstract void onConfigurationProgress(@NotNull TestConfigurationProgressEvent var1);

    public abstract void onConfigurationScheduled(@NotNull TestConfigurationScheduledEvent var1);

    public abstract void onConfigurationFinished(@NotNull TestConfigurationFinishedEvent var1);

    public abstract void onUncapturedOutput(@NotNull String var1, Key var2);

    public abstract void onError(@NotNull String var1, @Nullable String var2, boolean var3);

    public abstract void onCustomProgressTestsCategory(@Nullable String var1, int var2);

    public abstract void onCustomProgressTestStarted();

    public abstract void onCustomProgressTestFailed();

    public abstract void onTestsReporterAttached();

    public abstract void setLocator(@NotNull SMTestLocator var1);

    public abstract void addEventsListener(@NotNull GoogleCloudTestEventsListener var1);

    public abstract void onFinishTesting();

    public abstract void setPrinterProvider(@NotNull TestProxyPrinterProvider var1);

    public void dispose() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    GoogleCloudTestEventsProcessor.this.myTransferToEDTQueue.drain();
                }
            });
        }
    }

    public Condition getDisposedCondition() {
        return Conditions.alwaysFalse();
    }

    public void addToInvokeLater(Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        boolean unitTestMode = application.isUnitTestMode();
        if (unitTestMode) {
            UIUtil.invokeLaterIfNeeded((Runnable)runnable);
        } else if (application.isHeadlessEnvironment() || SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            this.myTransferToEDTQueue.offer((Object)runnable);
        }
    }
}

