/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.launcher;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.InputStreamContent;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.api.services.testing.model.AndroidInstrumentationTest;
import com.google.api.services.testing.model.AndroidMatrix;
import com.google.api.services.testing.model.ClientInfo;
import com.google.api.services.testing.model.EnvironmentMatrix;
import com.google.api.services.testing.model.FileReference;
import com.google.api.services.testing.model.GoogleCloudStorage;
import com.google.api.services.testing.model.ResultStorage;
import com.google.api.services.testing.model.TestMatrix;
import com.google.api.services.testing.model.TestSpecification;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gct.testing.CloudConfigurationImpl;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.dimension.CloudTestingType;
import com.google.gct.testing.dimension.DeviceDimension;
import com.google.gct.testing.launcher.CloudAuthenticator;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class CloudTestsLauncher {
    private static final Function<CloudTestingType, String> TO_CLOUD_TESTING_TYPE_IDS = CloudTestingType::getId;

    public static StorageObject uploadFile(String bucketName, String uniquePrefix, File file) {
        InputStreamContent mediaContent;
        try {
            mediaContent = new InputStreamContent("application/octet-stream", (InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        mediaContent.setLength(file.length());
        try {
            Storage.Objects.Insert insertObject = CloudAuthenticator.getInstance().getStorage().objects().insert(bucketName, null, (AbstractInputStreamContent)mediaContent);
            insertObject.setName(uniquePrefix + "/" + file.getName());
            return (StorageObject)insertObject.execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static TestMatrix triggerTestApi(String cloudProjectId, String bucketGcsPath, String appApkGcsPath, String testApkGcsPath, String testSpecification, String instrumentationTestRunner, CloudConfigurationImpl cloudTestConfiguration) {
        TestMatrix testMatrix = new TestMatrix();
        testMatrix.setClientInfo(new ClientInfo().setName("Android Studio " + ApplicationInfo.getInstance().getFullVersion()));
        String testTimeout = CloudTestsLauncher.usesPhysicalDevice(cloudTestConfiguration) ? "2700s" : "3600s";
        testMatrix.setTestSpecification(new TestSpecification().setTestTimeout(testTimeout).setAndroidInstrumentationTest(new AndroidInstrumentationTest().setAppApk(new FileReference().setGcsPath(appApkGcsPath)).setTestApk(new FileReference().setGcsPath(testApkGcsPath)).setTestRunnerClass(instrumentationTestRunner).setTestTargets((List)Lists.newArrayList((Object[])new String[]{testSpecification}))));
        testMatrix.setResultStorage(new ResultStorage().setGoogleCloudStorage(new GoogleCloudStorage().setGcsPath(bucketGcsPath)));
        AndroidMatrix androidMatrix = new AndroidMatrix();
        androidMatrix.setAndroidModelIds(Lists.transform(cloudTestConfiguration.getDeviceDimension().getEnabledTypes(), TO_CLOUD_TESTING_TYPE_IDS));
        androidMatrix.setAndroidVersionIds(Lists.transform(cloudTestConfiguration.getApiDimension().getEnabledTypes(), TO_CLOUD_TESTING_TYPE_IDS));
        androidMatrix.setLocales(Lists.transform(cloudTestConfiguration.getLanguageDimension().getEnabledTypes(), TO_CLOUD_TESTING_TYPE_IDS));
        androidMatrix.setOrientations(Lists.transform(cloudTestConfiguration.getOrientationDimension().getEnabledTypes(), TO_CLOUD_TESTING_TYPE_IDS));
        testMatrix.setEnvironmentMatrix(new EnvironmentMatrix().setAndroidMatrix(androidMatrix));
        TestMatrix triggeredTestMatrix = null;
        try {
            triggeredTestMatrix = (TestMatrix)CloudAuthenticator.getInstance().getTest().projects().testMatrices().create(cloudProjectId, testMatrix).execute();
        }
        catch (Exception e) {
            String urlPrefix;
            int urlPrefixIndex;
            int startOfBackendMessageText;
            String message;
            String exceptionMessage = e.getMessage();
            String backendMessageHeader = "\"message\" : \"";
            int indexOfBackendMessage = exceptionMessage.indexOf(backendMessageHeader);
            if (indexOfBackendMessage != -1 && (message = exceptionMessage.substring(startOfBackendMessageText = indexOfBackendMessage + backendMessageHeader.length(), exceptionMessage.indexOf("\",", startOfBackendMessageText))).contains("is not registered for Firebase Test Lab") && (urlPrefixIndex = message.indexOf(urlPrefix = "Please visit: ")) != -1) {
                int urlIndex = urlPrefixIndex + urlPrefix.length();
                String url = message.substring(urlIndex);
                String userMessage = "<html>" + message.substring(0, urlPrefixIndex) + "<br>" + message.substring(urlPrefixIndex, urlIndex) + "<a href='" + url + "?source=android-studio'>" + url + "</a></html>";
                SwingUtilities.invokeLater(() -> Messages.showDialog((String)userMessage, (String)"Project not registered", (String[])new String[]{"OK"}, (int)0, null));
                return null;
            }
            CloudTestingUtils.showErrorMessage(null, "Error triggering a matrix test", "Failed to trigger a firebase matrix execution!\nException while triggering a matrix execution\n\n" + exceptionMessage);
        }
        return triggeredTestMatrix;
    }

    private static boolean usesPhysicalDevice(CloudConfigurationImpl cloudTestConfiguration) {
        for (CloudTestingType enabledDevice : cloudTestConfiguration.getDeviceDimension().getEnabledTypes()) {
            if (!((DeviceDimension.Device)enabledDevice).isPhysical()) continue;
            return true;
        }
        return false;
    }
}

