/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.google.common.base.Optional;

class BucketFileMetadata {
    private String path;
    private Optional<String> encodedConfigurationInstance;
    private String name;
    private Type type;

    public BucketFileMetadata(String filePath) {
        this.path = filePath;
        if (this.path.endsWith("/")) {
            this.type = Type.FOLDER;
            this.name = this.path.substring(0, this.path.length() - 1);
        } else {
            String[] fileNameParts = this.path.split("/");
            this.encodedConfigurationInstance = fileNameParts.length < 3 ? Optional.absent() : Optional.of((Object)fileNameParts[1]);
            this.name = fileNameParts[fileNameParts.length - 1];
        }
        this.type = this.path.endsWith("/DONE") ? Type.DONE : (this.path.endsWith("/PROGRESS") ? Type.PROGRESS : (this.path.endsWith(".results") ? Type.RESULT : (this.path.endsWith(".png") || this.path.endsWith(".bmp") || this.path.endsWith(".jpg") ? Type.SCREENSHOT : (this.path.endsWith(".apk") ? Type.APK : Type.UNKNOWN))));
    }

    public String getPath() {
        return this.path;
    }

    public boolean hasEncodedConfigurationInstance() {
        return this.encodedConfigurationInstance.isPresent();
    }

    public String getEncodedConfigurationInstance() {
        return (String)this.encodedConfigurationInstance.get();
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "BucketFileMetadata{path='" + this.path + "', configuration=" + String.valueOf(this.encodedConfigurationInstance) + ", name='" + this.name + "', type=" + String.valueOf((Object)this.type) + "}";
    }

    public static enum Type {
        UNKNOWN,
        DONE,
        PROGRESS,
        RESULT,
        SCREENSHOT,
        APK,
        FOLDER;

    }
}

