/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.inspectors.common.api.actions;

import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.CodeNavigator;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class NavigateToCodeAction
extends AnAction {
    @NotNull
    private final Supplier<CodeLocation> myLocationSupplier;
    @NotNull
    private final CodeNavigator myCodeNavigator;

    public NavigateToCodeAction(@NotNull Supplier<CodeLocation> locationSupplier, @NotNull CodeNavigator codeNavigator) {
        this.myLocationSupplier = locationSupplier;
        this.myCodeNavigator = codeNavigator;
        String title = ActionsBundle.actionText((String)"EditSource");
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(title);
        presentation.setDescription(ActionsBundle.actionDescription((String)"EditSource"));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        CodeLocation codeLocation = this.myLocationSupplier.get();
        e.getPresentation().setEnabled(codeLocation != null && this.myCodeNavigator.isNavigatable(codeLocation));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        CodeLocation location = this.myLocationSupplier.get();
        if (location != null) {
            this.myCodeNavigator.navigate(location);
        }
    }
}

