/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.io.grpc.okhttp.internal.proxy;

import java.io.EOFException;
import java.net.IDN;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Locale;
import okio.Buffer;

public final class HttpUrl {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final String scheme;
    private final String host;
    private final int port;
    private final String url;

    private HttpUrl(Builder builder) {
        this.scheme = builder.scheme;
        this.host = builder.host;
        this.port = builder.effectivePort();
        this.url = builder.toString();
    }

    public String scheme() {
        return this.scheme;
    }

    public boolean isHttps() {
        return this.scheme.equals("https");
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public static int defaultPort(String scheme) {
        if (scheme.equals("http")) {
            return 80;
        }
        if (scheme.equals("https")) {
            return 443;
        }
        return -1;
    }

    public Builder newBuilder() {
        Builder result = new Builder();
        result.scheme = this.scheme;
        result.host = this.host;
        result.port = this.port != HttpUrl.defaultPort(this.scheme) ? this.port : -1;
        return result;
    }

    public boolean equals(Object o) {
        return o instanceof HttpUrl && ((HttpUrl)o).url.equals(this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url;
    }

    static String percentDecode(String encoded, int pos, int limit, boolean plusIsSpace) {
        for (int i = pos; i < limit; ++i) {
            char c = encoded.charAt(i);
            if (c != '%' && (c != '+' || !plusIsSpace)) continue;
            Buffer out = new Buffer();
            out.writeUtf8(encoded, pos, i);
            HttpUrl.percentDecode(out, encoded, i, limit, plusIsSpace);
            return out.readUtf8();
        }
        return encoded.substring(pos, limit);
    }

    static void percentDecode(Buffer out, String encoded, int pos, int limit, boolean plusIsSpace) {
        int codePoint;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = encoded.codePointAt(i);
            if (codePoint == 37 && i + 2 < limit) {
                int d1 = HttpUrl.decodeHexDigit(encoded.charAt(i + 1));
                int d2 = HttpUrl.decodeHexDigit(encoded.charAt(i + 2));
                if (d1 != -1 && d2 != -1) {
                    out.writeByte((d1 << 4) + d2);
                    i += 2;
                    continue;
                }
            } else if (codePoint == 43 && plusIsSpace) {
                out.writeByte(32);
                continue;
            }
            out.writeUtf8CodePoint(codePoint);
        }
    }

    static int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    static void canonicalize(Buffer out, String input, int pos, int limit, String encodeSet, boolean alreadyEncoded, boolean plusIsSpace, boolean asciiOnly) {
        int codePoint;
        Buffer utf8Buffer = null;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (alreadyEncoded && (codePoint == 9 || codePoint == 10 || codePoint == 12 || codePoint == 13)) continue;
            if (codePoint == 43 && plusIsSpace) {
                out.writeUtf8(alreadyEncoded ? "+" : "%2B");
                continue;
            }
            if (codePoint < 32 || codePoint == 127 || codePoint >= 128 && asciiOnly || encodeSet.indexOf(codePoint) != -1 || codePoint == 37 && !alreadyEncoded) {
                if (utf8Buffer == null) {
                    utf8Buffer = new Buffer();
                }
                utf8Buffer.writeUtf8CodePoint(codePoint);
                while (!utf8Buffer.exhausted()) {
                    try {
                        HttpUrl.fakeEofExceptionMethod();
                        int b = utf8Buffer.readByte() & 0xFF;
                        out.writeByte(37);
                        out.writeByte((int)HEX_DIGITS[b >> 4 & 0xF]);
                        out.writeByte((int)HEX_DIGITS[b & 0xF]);
                    }
                    catch (EOFException e) {
                        throw new IndexOutOfBoundsException(e.getMessage());
                    }
                }
                continue;
            }
            out.writeUtf8CodePoint(codePoint);
        }
    }

    private static void fakeEofExceptionMethod() throws EOFException {
    }

    public static final class Builder {
        String scheme;
        String host;
        int port = -1;

        public Builder scheme(String scheme) {
            if (scheme == null) {
                throw new IllegalArgumentException("scheme == null");
            }
            if (scheme.equalsIgnoreCase("http")) {
                this.scheme = "http";
            } else if (scheme.equalsIgnoreCase("https")) {
                this.scheme = "https";
            } else {
                throw new IllegalArgumentException("unexpected scheme: " + scheme);
            }
            return this;
        }

        public Builder host(String host) {
            if (host == null) {
                throw new IllegalArgumentException("host == null");
            }
            String encoded = Builder.canonicalizeHost(host, 0, host.length());
            if (encoded == null) {
                throw new IllegalArgumentException("unexpected host: " + host);
            }
            this.host = encoded;
            return this;
        }

        public Builder port(int port) {
            if (port <= 0 || port > 65535) {
                throw new IllegalArgumentException("unexpected port: " + port);
            }
            this.port = port;
            return this;
        }

        int effectivePort() {
            return this.port != -1 ? this.port : HttpUrl.defaultPort(this.scheme);
        }

        public HttpUrl build() {
            if (this.scheme == null) {
                throw new IllegalStateException("scheme == null");
            }
            if (this.host == null) {
                throw new IllegalStateException("host == null");
            }
            return new HttpUrl(this);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.scheme);
            result.append("://");
            if (this.host.indexOf(58) != -1) {
                result.append('[');
                result.append(this.host);
                result.append(']');
            } else {
                result.append(this.host);
            }
            int effectivePort = this.effectivePort();
            if (effectivePort != HttpUrl.defaultPort(this.scheme)) {
                result.append(':');
                result.append(effectivePort);
            }
            return result.toString();
        }

        private static String canonicalizeHost(String input, int pos, int limit) {
            String percentDecoded = HttpUrl.percentDecode(input, pos, limit, false);
            if (percentDecoded.startsWith("[") && percentDecoded.endsWith("]")) {
                InetAddress inetAddress = Builder.decodeIpv6(percentDecoded, 1, percentDecoded.length() - 1);
                if (inetAddress == null) {
                    return null;
                }
                byte[] address = inetAddress.getAddress();
                if (address.length == 16) {
                    return Builder.inet6AddressToAscii(address);
                }
                throw new AssertionError();
            }
            return Builder.domainToAscii(percentDecoded);
        }

        private static InetAddress decodeIpv6(String input, int pos, int limit) {
            byte[] address = new byte[16];
            int b = 0;
            int compress = -1;
            int groupOffset = -1;
            int i = pos;
            while (i < limit) {
                char c;
                int hexDigit;
                if (b == address.length) {
                    return null;
                }
                if (i + 2 <= limit && input.regionMatches(i, "::", 0, 2)) {
                    if (compress != -1) {
                        return null;
                    }
                    compress = b += 2;
                    if ((i += 2) == limit) {
                        break;
                    }
                } else if (b != 0 && !input.regionMatches(i, ":", 0, 1)) {
                    if (input.regionMatches(i, ".", 0, 1)) {
                        if (!Builder.decodeIpv4Suffix(input, groupOffset, limit, address, b - 2)) {
                            return null;
                        }
                        b += 2;
                        break;
                    }
                    return null;
                }
                int value = 0;
                groupOffset = ++i;
                while (i < limit && (hexDigit = HttpUrl.decodeHexDigit(c = input.charAt(i))) != -1) {
                    value = (value << 4) + hexDigit;
                    ++i;
                }
                int groupLength = i - groupOffset;
                if (groupLength == 0 || groupLength > 4) {
                    return null;
                }
                address[b++] = (byte)(value >>> 8 & 0xFF);
                address[b++] = (byte)(value & 0xFF);
            }
            if (b != address.length) {
                if (compress == -1) {
                    return null;
                }
                System.arraycopy(address, compress, address, address.length - (b - compress), b - compress);
                Arrays.fill(address, compress, compress + (address.length - b), (byte)0);
            }
            try {
                return InetAddress.getByAddress(address);
            }
            catch (UnknownHostException e) {
                throw new AssertionError();
            }
        }

        private static boolean decodeIpv4Suffix(String input, int pos, int limit, byte[] address, int addressOffset) {
            int b = addressOffset;
            int i = pos;
            while (i < limit) {
                char c;
                if (b == address.length) {
                    return false;
                }
                if (b != addressOffset && input.charAt(i) != '.') {
                    return false;
                }
                int value = 0;
                int groupOffset = ++i;
                while (i < limit && (c = input.charAt(i)) >= '0' && c <= '9') {
                    if (value == 0 && groupOffset != i) {
                        return false;
                    }
                    if ((value = value * 10 + c - 48) > 255) {
                        return false;
                    }
                    ++i;
                }
                int groupLength = i - groupOffset;
                if (groupLength == 0) {
                    return false;
                }
                address[b++] = (byte)value;
            }
            return b == addressOffset + 4;
        }

        private static String domainToAscii(String input) {
            try {
                String result = IDN.toASCII(input).toLowerCase(Locale.US);
                if (result.isEmpty()) {
                    return null;
                }
                if (Builder.containsInvalidHostnameAsciiCodes(result)) {
                    return null;
                }
                return result;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        private static boolean containsInvalidHostnameAsciiCodes(String hostnameAscii) {
            for (int i = 0; i < hostnameAscii.length(); ++i) {
                char c = hostnameAscii.charAt(i);
                if (c <= '\u001f' || c >= '\u007f') {
                    return true;
                }
                if (" #%/:?@[\\]".indexOf(c) == -1) continue;
                return true;
            }
            return false;
        }

        private static String inet6AddressToAscii(byte[] address) {
            int longestRunOffset = -1;
            int longestRunLength = 0;
            for (int i = 0; i < address.length; i += 2) {
                int currentRunOffset = i;
                while (i < 16 && address[i] == 0 && address[i + 1] == 0) {
                    i += 2;
                }
                int currentRunLength = i - currentRunOffset;
                if (currentRunLength <= longestRunLength) continue;
                longestRunOffset = currentRunOffset;
                longestRunLength = currentRunLength;
            }
            Buffer result = new Buffer();
            int i = 0;
            while (i < address.length) {
                if (i == longestRunOffset) {
                    result.writeByte(58);
                    if ((i += longestRunLength) != 16) continue;
                    result.writeByte(58);
                    continue;
                }
                if (i > 0) {
                    result.writeByte(58);
                }
                int group = (address[i] & 0xFF) << 8 | address[i + 1] & 0xFF;
                result.writeHexadecimalUnsignedLong((long)group);
                i += 2;
            }
            return result.readUtf8();
        }
    }
}

