/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.RefValueHashMapUtil;
import com.intellij.util.containers.ReferenceQueueable;
import com.intellij.util.containers.SimpleEntry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class IntKeyWeakValueHashMap<V>
implements IntObjectMap<V>,
ReferenceQueueable {
    private final Int2ObjectMap<MyReference<V>> myMap = new Int2ObjectOpenHashMap<MyReference<V>>();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    IntKeyWeakValueHashMap() {
    }

    @Override
    public boolean processQueue() {
        MyReference ref;
        boolean processed = false;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            int key = ref.key;
            processed |= this.myMap.remove(key, (Object)ref);
        }
        return processed;
    }

    @Override
    public V get(int key) {
        return (V)SoftReference.dereference((Reference)this.myMap.get(key));
    }

    @Override
    public V put(int key, @NotNull V value) {
        if (value == null) {
            IntKeyWeakValueHashMap.$$$reportNull$$$0(0);
        }
        this.processQueue();
        MyReference ref = new MyReference(key, value, this.myQueue);
        MyReference oldRef = this.myMap.put(key, ref);
        return (V)SoftReference.dereference(oldRef);
    }

    @Override
    public V remove(int key) {
        this.processQueue();
        MyReference ref = (MyReference)this.myMap.remove(key);
        return (V)SoftReference.dereference(ref);
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(int key) {
        throw RefValueHashMapUtil.pointlessContainsKey();
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull V> values() {
        Collection refs = this.myMap.values();
        ArrayList result = new ArrayList(refs.size());
        for (MyReference o : refs) {
            Object value = o.get();
            if (value == null) continue;
            result.add(value);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            IntKeyWeakValueHashMap.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public int @NotNull [] keys() {
        throw new IncorrectOperationException("keys() makes no sense for weak/soft map because GC can clear the value any moment now");
    }

    @Override
    public boolean containsValue(@NotNull V value) {
        if (value == null) {
            IntKeyWeakValueHashMap.$$$reportNull$$$0(2);
        }
        return this.values().contains(value);
    }

    @Override
    @NotNull
    public Set<IntObjectMap.Entry<V>> entrySet() {
        return new MyEntrySetView();
    }

    @NotNull
    private Iterator<IntObjectMap.Entry<V>> entriesIterator() {
        Iterator entryIterator = this.myMap.int2ObjectEntrySet().iterator();
        return new Iterator<IntObjectMap.Entry<V>>(){
            private IntObjectMap.Entry<V> nextVEntry;
            private int lastReturned;
            final /* synthetic */ ObjectIterator val$entryIterator;
            {
                this.val$entryIterator = objectIterator;
                this.nextAliveEntry();
            }

            @Override
            public boolean hasNext() {
                return this.nextVEntry != null;
            }

            @Override
            public IntObjectMap.Entry<V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IntObjectMap.Entry result = this.nextVEntry;
                this.lastReturned = result.getKey();
                this.nextAliveEntry();
                return result;
            }

            private void nextAliveEntry() {
                while (this.val$entryIterator.hasNext()) {
                    Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)this.val$entryIterator.next();
                    MyReference ref = (MyReference)entry.getValue();
                    Object v = ref.get();
                    if (v == null) continue;
                    int key = entry.getIntKey();
                    this.nextVEntry = new SimpleEntry(key, v);
                    return;
                }
                this.nextVEntry = null;
            }

            @Override
            public void remove() {
                IntKeyWeakValueHashMap.this.myMap.remove(this.lastReturned);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/IntKeyWeakValueHashMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/IntKeyWeakValueHashMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyReference<T>
    extends WeakReference<T> {
        private final int key;

        private MyReference(int key, @NotNull T referent, ReferenceQueue<? super T> q) {
            if (referent == null) {
                MyReference.$$$reportNull$$$0(0);
            }
            super(referent, q);
            this.key = key;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/util/containers/IntKeyWeakValueHashMap$MyReference", "<init>"));
        }
    }

    private final class MyEntrySetView
    extends AbstractSet<IntObjectMap.Entry<V>> {
        private MyEntrySetView() {
        }

        @Override
        @NotNull
        public Iterator<IntObjectMap.Entry<V>> iterator() {
            Iterator iterator2 = IntKeyWeakValueHashMap.this.entriesIterator();
            if (iterator2 == null) {
                MyEntrySetView.$$$reportNull$$$0(0);
            }
            return iterator2;
        }

        @Override
        public int size() {
            return IntKeyWeakValueHashMap.this.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/IntKeyWeakValueHashMap$MyEntrySetView", "iterator"));
        }
    }
}

