/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.directaccess.client.cli.action;

import com.google.cloud.devicestreaming.v1.DeviceSession;
import com.google.protobuf.Timestamp;
import com.google.services.firebase.directaccess.client.DirectAccessReservationManager;
import com.google.services.firebase.directaccess.client.cli.DirectAccessCliSettings;
import com.google.services.firebase.directaccess.client.cli.ShowUsageException;
import com.google.services.firebase.directaccess.client.cli.UtilsKt;
import com.google.services.firebase.directaccess.client.cli.action.DirectAccessAction;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f*\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/google/services/firebase/directaccess/client/cli/action/ExtendReservationAction;", "Lcom/google/services/firebase/directaccess/client/cli/action/DirectAccessAction;", "settings", "Lcom/google/services/firebase/directaccess/client/cli/DirectAccessCliSettings;", "<init>", "(Lcom/google/services/firebase/directaccess/client/cli/DirectAccessCliSettings;)V", "duration", "", "consumeArgs", "", "run", "expireTime", "Lcom/google/protobuf/Timestamp;", "kotlin.jvm.PlatformType", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/google/cloud/devicestreaming/v1/DeviceSession;", "getExpireTime", "(Lkotlinx/coroutines/flow/StateFlow;)Lcom/google/protobuf/Timestamp;", "Companion", "directaccess-client"})
public final class ExtendReservationAction
extends DirectAccessAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String duration;

    public ExtendReservationAction(@NotNull DirectAccessCliSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.duration = "";
    }

    @Override
    public void consumeArgs() {
        UtilsKt.retainAll(this.getArgs(), (Function1<? super Map.Entry<String, String>, Boolean>)((Function1)arg_0 -> ExtendReservationAction.consumeArgs$lambda$0(this, arg_0)));
    }

    @Override
    public void run() {
        if (((CharSequence)this.getReservationName()).length() == 0 || ((CharSequence)this.duration).length() == 0) {
            throw new ShowUsageException("--reservation-name=<reservation name> and --duration=<minutes> required to extend a reservation");
        }
        Long l = StringsKt.toLongOrNull((String)this.duration);
        if (l == null) {
            throw new IllegalArgumentException("--duration has to be an integer value");
        }
        long longDuration = l;
        if (longDuration < 0L) {
            throw new IllegalArgumentException("--duration cannot be negative");
        }
        StateFlow<DeviceSession> reservationFlow = this.getReservationManager().fetchReservationFlow(this.getReservationName());
        Timestamp originalExpiryTime = this.getExpireTime(reservationFlow);
        DirectAccessReservationManager directAccessReservationManager = this.getReservationManager();
        String string = this.getReservationName();
        Duration duration = Duration.ofMinutes(longDuration);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        directAccessReservationManager.extendReservation(string, duration, DirectAccessReservationManager.ReservationExtendType.EXTEND);
        Job job2 = BuildersKt.launch$default((CoroutineScope)this.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, reservationFlow, originalExpiryTime, null){
            int label;
            final /* synthetic */ ExtendReservationAction this$0;
            final /* synthetic */ StateFlow<DeviceSession> $reservationFlow;
            final /* synthetic */ Timestamp $originalExpiryTime;
            {
                this.this$0 = $receiver;
                this.$reservationFlow = $reservationFlow;
                this.$originalExpiryTime = $originalExpiryTime;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = TimeoutKt.withTimeout((long)5000L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$reservationFlow, this.$originalExpiryTime, null){
                            int label;
                            final /* synthetic */ StateFlow<DeviceSession> $reservationFlow;
                            final /* synthetic */ Timestamp $originalExpiryTime;
                            {
                                this.$reservationFlow = $reservationFlow;
                                this.$originalExpiryTime = $originalExpiryTime;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = FlowKt.collect((Flow)FlowKt.takeWhile((Flow)((Flow)this.$reservationFlow), (Function2)((Function2)new Function2<DeviceSession, Continuation<? super Boolean>, Object>(this.$originalExpiryTime, null){
                                            int label;
                                            /* synthetic */ Object L$0;
                                            final /* synthetic */ Timestamp $originalExpiryTime;
                                            {
                                                this.$originalExpiryTime = $originalExpiryTime;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        DeviceSession it = (DeviceSession)this.L$0;
                                                        return Boxing.boxBoolean((it.getExpireTime().getSeconds() == this.$originalExpiryTime.getSeconds() && it.getExpireTime().getNanos() == this.$originalExpiryTime.getNanos() ? 1 : 0) != 0);
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                var3_3.L$0 = value;
                                                return (Continuation)var3_3;
                                            }

                                            public final Object invoke(DeviceSession p1, Continuation<? super Boolean> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        })), (Continuation)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            v1 = this.this$0.getOutputStream();
                            v2 = ExtendReservationAction.access$getExpireTime(this.this$0, this.$reservationFlow);
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"access$getExpireTime(...)");
                            v1.println("Reservation extended. New expire time: " + UtilsKt.getFormattedTime(v2));
                        }
                        catch (TimeoutCancellationException var2_3) {
                            this.this$0.getOutputStream().println("Could not extend reservation");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(job2, null){
            int label;
            final /* synthetic */ Job $job;
            {
                this.$job = $job;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$job.join((Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final Timestamp getExpireTime(StateFlow<DeviceSession> $this$expireTime) {
        return ((DeviceSession)$this$expireTime.getValue()).getExpireTime();
    }

    private static final boolean consumeArgs$lambda$0(ExtendReservationAction this$0, Map.Entry entry) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (Intrinsics.areEqual((Object)((String)entry.getKey()), (Object)"--duration")) {
            this$0.duration = (String)entry.getValue();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ Timestamp access$getExpireTime(ExtendReservationAction $this, StateFlow $receiver) {
        return $this.getExpireTime((StateFlow<DeviceSession>)$receiver);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052&\u0010\u0006\u001a\"\u0012\u0004\u0012\u00020\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f0\u0007j\u0002`\r\u00a8\u0006\u000e"}, d2={"Lcom/google/services/firebase/directaccess/client/cli/action/ExtendReservationAction$Companion;", "", "<init>", "()V", "register", "", "map", "", "", "Lkotlin/Function1;", "Lcom/google/services/firebase/directaccess/client/cli/DirectAccessCliSettings;", "Lcom/google/services/firebase/directaccess/client/cli/action/DirectAccessAction;", "Lcom/google/services/firebase/directaccess/client/cli/ActionMapValue;", "Lcom/google/services/firebase/directaccess/client/cli/ActionMap;", "directaccess-client"})
    public static final class Companion {
        private Companion() {
        }

        public final void register(@NotNull Map<String, Function1<DirectAccessCliSettings, DirectAccessAction>> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            map2.put("extend", (Function1<DirectAccessCliSettings, DirectAccessAction>)((Function1)Companion::register$lambda$0));
        }

        private static final DirectAccessAction register$lambda$0(DirectAccessCliSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            return new ExtendReservationAction(settings);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

