/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.directaccess.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.gct.directaccess.provisioner.DirectAccessBannersManagerKt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.ide.BrowserUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\u00020\b*\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0018\u0010\u0010\u001a\u00020\b*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/google/gct/directaccess/ui/DirectAccessIncidentBanner;", "Lcom/intellij/ui/EditorNotificationPanel;", "incidents", "", "Lcom/google/gson/JsonElement;", "<init>", "(Ljava/util/List;)V", "getCorrectedPreferredHeight", "", "getPreferredFullHeight", "Ljavax/swing/JComponent;", "moveActionLabels", "", "paintBorder", "g", "Ljava/awt/Graphics;", "scaled", "getScaled", "(I)I", "directaccess"})
@StabilityInferred(parameters=0)
public final class DirectAccessIncidentBanner
extends EditorNotificationPanel {
    public static final int $stable = 8;

    public DirectAccessIncidentBanner(@NotNull List<? extends JsonElement> incidents) {
        Intrinsics.checkNotNullParameter(incidents, (String)"incidents");
        super(EditorNotificationPanel.Status.Warning);
        boolean multiIncidents = incidents.size() > 1;
        Object object = CollectionsKt.first(incidents);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
        JsonObject incident = (JsonObject)object;
        String description = multiIncidents ? "There are " + incidents.size() + " incidents affecting Device Streaming." : incident.getAsJsonObject().get("external_desc").getAsString();
        this.setText("<html>" + description + "</html>");
        this.setOpaque(true);
        this.createActionLabel("More info", () -> DirectAccessIncidentBanner._init_$lambda$0(multiIncidents, incident));
        this.moveActionLabels();
        this.setCloseAction(() -> DirectAccessIncidentBanner._init_$lambda$1(this));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setPreferredSize((Dimension)new JBDimension(UiSizeUtilKt.getPreferredWidth((JComponent)((JComponent)((Object)this))), this.getCorrectedPreferredHeight()));
            }
        });
    }

    public final int getCorrectedPreferredHeight() {
        JLabel jLabel = this.myLabel;
        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"myLabel");
        int n = this.getPreferredFullHeight(jLabel);
        JPanel jPanel = this.myLinksPanel;
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"myLinksPanel");
        return n + this.getPreferredFullHeight(jPanel) + this.getScaled(20);
    }

    private final int getPreferredFullHeight(JComponent $this$getPreferredFullHeight) {
        return UiSizeUtilKt.getPreferredHeight((JComponent)$this$getPreferredFullHeight) + $this$getPreferredFullHeight.getInsets().top + $this$getPreferredFullHeight.getInsets().bottom;
    }

    private final void moveActionLabels() {
        Container parent = this.myLinksPanel.getParent();
        if (parent.getLayout() instanceof BorderLayout) {
            this.myLabel.setVerticalTextPosition(1);
            parent.add((Component)this.myLinksPanel, "South");
            this.myLinksPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)(this.myLabel.getIcon().getIconWidth() + this.myLabel.getIconTextGap() - 2), (int)0, (int)0));
        }
    }

    protected void paintBorder(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintBorder(g);
        Graphics2D $this$paintBorder_u24lambda_u240 = (Graphics2D)g;
        boolean bl = false;
        Color color = JBUI.CurrentTheme.Banner.WARNING_BORDER_COLOR;
        $this$paintBorder_u24lambda_u240.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        $this$paintBorder_u24lambda_u240.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ((Graphics2D)g).setColor(color);
        $this$paintBorder_u24lambda_u240.drawRect(this.getScaled(-5), 0, this.getWidth() + this.getScaled(10), this.getHeight() - this.getScaled(1));
    }

    private final int getScaled(int $this$scaled) {
        return JBUI.scale((int)$this$scaled);
    }

    private static final void _init_$lambda$0(boolean $multiIncidents, JsonObject $incident) {
        String url = DirectAccessBannersManagerKt.getOutageUrl() + "/products/" + DirectAccessBannersManagerKt.getServiceKey() + "/history";
        if (!$multiIncidents && $incident.has("uri")) {
            url = DirectAccessBannersManagerKt.getOutageUrl() + "/" + $incident.get("uri").getAsString();
        }
        BrowserUtil.browse((String)url);
    }

    private static final void _init_$lambda$1(DirectAccessIncidentBanner this$0) {
        this$0.setVisible(false);
    }
}

