/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.directaccess;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.google.gct.directaccess.CloudProjectEntry;
import com.google.gct.directaccess.DirectAccessCloudProjectManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\tJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/google/gct/directaccess/DirectAccessApplicationService;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "cloudProjectMap", "", "Lcom/intellij/openapi/project/Project;", "Lcom/google/gct/directaccess/CloudProjectEntry;", "cloudProjectManagerMap", "Lcom/google/gct/directaccess/DirectAccessCloudProjectManager;", "registerCloudProject", "project", "cloudProject", "removeUnusedCloudProjectManager", "", "getCloudProjectManager", "directaccess"})
@StabilityInferred(parameters=0)
public final class DirectAccessApplicationService {
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Map<Project, CloudProjectEntry> cloudProjectMap;
    @NotNull
    private final Map<CloudProjectEntry, DirectAccessCloudProjectManager> cloudProjectManagerMap;
    public static final int $stable = 8;

    public DirectAccessApplicationService(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.cloudProjectMap = new LinkedHashMap();
        this.cloudProjectManagerMap = new LinkedHashMap();
    }

    @Nullable
    public final synchronized DirectAccessCloudProjectManager registerCloudProject(@NotNull Project project, @Nullable CloudProjectEntry cloudProject) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CloudProjectEntry existingCloudProject = this.cloudProjectMap.get(project);
        if (Intrinsics.areEqual((Object)existingCloudProject, (Object)cloudProject)) {
            return this.getCloudProjectManager(cloudProject);
        }
        if (cloudProject != null) {
            this.cloudProjectMap.put(project, cloudProject);
        } else {
            this.cloudProjectMap.remove(project);
        }
        this.removeUnusedCloudProjectManager(existingCloudProject);
        return this.getCloudProjectManager(cloudProject);
    }

    public final void removeUnusedCloudProjectManager(@Nullable CloudProjectEntry cloudProject) {
        block1: {
            if (cloudProject == null || this.cloudProjectMap.values().contains(cloudProject)) break block1;
            DirectAccessCloudProjectManager directAccessCloudProjectManager = this.cloudProjectManagerMap.remove(cloudProject);
            if (directAccessCloudProjectManager != null) {
                directAccessCloudProjectManager.close();
            }
        }
    }

    @Nullable
    public final synchronized DirectAccessCloudProjectManager getCloudProjectManager(@Nullable CloudProjectEntry cloudProject) {
        if (cloudProject == null) {
            return null;
        }
        return this.cloudProjectManagerMap.computeIfAbsent(cloudProject, arg_0 -> DirectAccessApplicationService.getCloudProjectManager$lambda$1(arg_0 -> DirectAccessApplicationService.getCloudProjectManager$lambda$0(this, arg_0), arg_0));
    }

    private static final DirectAccessCloudProjectManager getCloudProjectManager$lambda$0(DirectAccessApplicationService this$0, CloudProjectEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DirectAccessCloudProjectManager(it, CoroutineUtilsKt.createChildScope$default((CoroutineScope)this$0.scope, (boolean)true, null, null, (int)6, null));
    }

    private static final DirectAccessCloudProjectManager getCloudProjectManager$lambda$1(Function1 $tmp0, Object p0) {
        return (DirectAccessCloudProjectManager)$tmp0.invoke(p0);
    }
}

