/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.ipcUtils;

import com.google.protobuf.Message;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class ProtobufUtils {
    private static final String[] SENSITIVE_KEYWORDS = new String[]{"token", "password", "secret", "key", "jwt"};
    private static final Pattern SENSITIVE_DATA_PATTERN = Pattern.compile("(\\b|_)(" + String.join((CharSequence)"|", SENSITIVE_KEYWORDS) + ")(\\b|_)", 2);
    private static final Pattern JWT_PATTERN = Pattern.compile("^[A-Za-z0-9-_]+\\.[A-Za-z0-9-_]+\\.[A-Za-z0-9-_]+$", 2);

    @NotNull
    public static Message unpackComposite(@NotNull Message compositeResponse, @NotNull Function<Message, Boolean> decomposeFilter) {
        if (compositeResponse == null) {
            ProtobufUtils.$$$reportNull$$$0(0);
        }
        if (decomposeFilter == null) {
            ProtobufUtils.$$$reportNull$$$0(1);
        }
        if (!decomposeFilter.apply(compositeResponse).booleanValue()) {
            Message message = compositeResponse;
            if (message == null) {
                ProtobufUtils.$$$reportNull$$$0(2);
            }
            return message;
        }
        Map allFields = compositeResponse.getAllFields();
        Collection values = allFields.values();
        assert (values.size() == 1) : "More than 1 message packed in one composite message";
        Message next = (Message)values.iterator().next();
        return ProtobufUtils.unpackComposite(next, decomposeFilter);
    }

    @NotNull
    public static String maskMessage(@NotNull Message message) {
        if (message == null) {
            ProtobufUtils.$$$reportNull$$$0(3);
        }
        if (message instanceof Protocol.Launch_Req) {
            Protocol.Launch_Req launchMsg = (Protocol.Launch_Req)message;
            String string = ProtobufUtils.maskMessage(launchMsg);
            if (string == null) {
                ProtobufUtils.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (message instanceof Protocol.RemoteLaunch_Req) {
            Protocol.RemoteLaunch_Req remoteLaunchMsg = (Protocol.RemoteLaunch_Req)message;
            String string = ProtobufUtils.maskMessage(remoteLaunchMsg);
            if (string == null) {
                ProtobufUtils.$$$reportNull$$$0(5);
            }
            return string;
        }
        Message decomposed = ProtobufUtils.unpackComposite(message, msg -> msg instanceof Protocol.CompositeRequest);
        if (decomposed instanceof Protocol.Launch_Req) {
            Protocol.Launch_Req launchMsg = (Protocol.Launch_Req)decomposed;
            String string = ProtobufUtils.maskMessage(launchMsg);
            if (string == null) {
                ProtobufUtils.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (decomposed instanceof Protocol.RemoteLaunch_Req) {
            Protocol.RemoteLaunch_Req remoteLaunchMsg = (Protocol.RemoteLaunch_Req)decomposed;
            String string = ProtobufUtils.maskMessage(remoteLaunchMsg);
            if (string == null) {
                ProtobufUtils.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = message.toString();
        if (string == null) {
            ProtobufUtils.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static String maskMessage(Protocol.Launch_Req launchMsg) {
        Protocol.Launch_Req.Builder clonedMsg = launchMsg.toBuilder();
        Model.CommandLine clonedCmdLine = clonedMsg.getCommandLine();
        Model.CommandLine.Builder maskedCmdLine = ProtobufUtils.maskCommandLine(clonedCmdLine);
        clonedMsg.setCommandLine(maskedCmdLine);
        return clonedMsg.toString();
    }

    private static String maskMessage(Protocol.RemoteLaunch_Req remoteLaunchMsg) {
        Protocol.RemoteLaunch_Req.Builder clonedMsg = remoteLaunchMsg.toBuilder();
        Model.CommandLine clonedCmdLine = clonedMsg.getCommandLine();
        Model.CommandLine.Builder maskedCmdLine = ProtobufUtils.maskCommandLine(clonedCmdLine);
        clonedMsg.setCommandLine(maskedCmdLine);
        return clonedMsg.toString();
    }

    private static  @NotNull Model.CommandLine.Builder maskCommandLine(Model.CommandLine clonedCmdLine) {
        List<Model.EnvParam> envList = clonedCmdLine.getEnvList();
        Model.CommandLine.Builder maskedCmdLine = clonedCmdLine.toBuilder().clearEnv();
        for (Model.EnvParam envParam : envList) {
            if (ProtobufUtils.hasSensitiveData(envParam.toBuilder())) {
                maskedCmdLine.addEnv(envParam.toBuilder().setValue("[REDACTED]"));
                continue;
            }
            maskedCmdLine.addEnv(envParam.toBuilder());
        }
        Model.CommandLine.Builder builder = maskedCmdLine;
        if (builder == null) {
            ProtobufUtils.$$$reportNull$$$0(9);
        }
        return builder;
    }

    private static boolean hasSensitiveData(Model.EnvParam.Builder env) {
        if (env.getValue().isEmpty()) {
            return false;
        }
        if (SENSITIVE_DATA_PATTERN.matcher(env.getName()).find()) {
            return true;
        }
        if (SENSITIVE_DATA_PATTERN.matcher(env.getValue()).find()) {
            return true;
        }
        return JWT_PATTERN.matcher(env.getValue()).find();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeResponse";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decomposeFilter";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/ipcUtils/ProtobufUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/ipcUtils/ProtobufUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "unpackComposite";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "maskMessage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "maskCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "unpackComposite";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "maskMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

