/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.stepFilters;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.util.Key;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.stepFilters.StepFiltersDiagnosticsLevel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0014\u0010\r\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/stepFilters/StepFiltersLogger;", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "diagnosticsLevel", "Lcom/jetbrains/cidr/execution/debugger/stepFilters/StepFiltersDiagnosticsLevel;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/jetbrains/cidr/execution/debugger/stepFilters/StepFiltersDiagnosticsLevel;)V", "verbose", "", "lazyMessage", "Lkotlin/Function0;", "", "error", "intellij.cidr.debugger.core"})
public final class StepFiltersLogger {
    @NotNull
    private final CidrDebugProcess process;
    @NotNull
    private final StepFiltersDiagnosticsLevel diagnosticsLevel;

    public StepFiltersLogger(@NotNull CidrDebugProcess process, @NotNull StepFiltersDiagnosticsLevel diagnosticsLevel) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)((Object)diagnosticsLevel), (String)"diagnosticsLevel");
        this.process = process;
        this.diagnosticsLevel = diagnosticsLevel;
    }

    public final void verbose(@NotNull Function0<String> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        if (this.diagnosticsLevel != StepFiltersDiagnosticsLevel.VERBOSE) {
            return;
        }
        this.process.handleDebuggerOutput(lazyMessage.invoke() + "\n", (Key)ProcessOutputType.STDOUT);
    }

    public final void error(@NotNull Function0<String> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        if (this.diagnosticsLevel == StepFiltersDiagnosticsLevel.DISABLED) {
            return;
        }
        this.process.handleDebuggerOutput(lazyMessage.invoke() + "\n", (Key)ProcessOutputType.STDERR);
    }
}

