/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpaceKt;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.InternalMutableIntervalMap;
import com.jetbrains.cidr.execution.debugger.memory.Interval;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0002H\u0096\u0002J\u0011\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0096\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JP\u0010\u0019\u001aB\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00030\u0003 \u001a* \u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\b0\b2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/IntervalTreeMap;", "Ljava/util/TreeMap;", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "Lcom/jetbrains/cidr/execution/debugger/memory/Interval;", "Lcom/jetbrains/cidr/execution/debugger/memory/InternalMutableIntervalMap;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "map", "Ljava/util/NavigableMap;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Ljava/util/NavigableMap;)V", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "intervals", "", "getIntervals", "()Ljava/util/Collection;", "myModificationCount", "Ljava/util/concurrent/atomic/AtomicLong;", "get", "address", "contains", "", "interval", "span", "subMapView", "kotlin.jvm.PlatformType", "rangeSpan", "removeAll", "", "remove", "put", "modificationCount", "", "getModificationCount", "()J", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nAddressSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddressSpace.kt\ncom/jetbrains/cidr/execution/debugger/memory/IntervalTreeMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,409:1\n1#2:410\n*E\n"})
final class IntervalTreeMap
extends TreeMap<Address, Interval>
implements InternalMutableIntervalMap {
    @NotNull
    private final AddressRange range;
    @NotNull
    private final AtomicLong myModificationCount;

    public IntervalTreeMap(@NotNull AddressRange range, @NotNull NavigableMap<Address, Interval> map) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        super((SortedMap)map);
        this.range = range;
        this.myModificationCount = new AtomicLong(0L);
    }

    public /* synthetic */ IntervalTreeMap(AddressRange addressRange, NavigableMap navigableMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            navigableMap = AddressSpaceKt.access$getEMPTY_NAVIGABLE_MAP$p();
        }
        this(addressRange, navigableMap);
    }

    @Override
    @NotNull
    public AddressRange getRange() {
        return this.range;
    }

    @Override
    @NotNull
    public Collection<Interval> getIntervals() {
        Collection<Interval> collection = this.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    @Override
    @NotNull
    public Interval get(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Object v = this.floorEntry(AddressSpaceKt.access$requireAddressInArena(this, address)).getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
        return (Interval)v;
    }

    @Override
    @NotNull
    public InternalMutableIntervalMap get(@NotNull AddressRange range) {
        boolean bl;
        IntervalTreeMap intervalTreeMap;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        AddressRange rangeSpan = this.span(range);
        NavigableMap<Address, Interval> navigableMap = this.subMapView(rangeSpan);
        Intrinsics.checkNotNullExpressionValue(navigableMap, (String)"subMapView(...)");
        IntervalTreeMap it = intervalTreeMap = new IntervalTreeMap(rangeSpan, navigableMap);
        boolean bl2 = false;
        boolean bl3 = bl = !it.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return intervalTreeMap;
    }

    @Override
    public boolean contains(@NotNull Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return Intrinsics.areEqual((Object)this.get((Object)interval.getRange().getStart()), (Object)interval);
    }

    @Override
    @NotNull
    public AddressRange span(@NotNull AddressRange range) {
        Address address;
        Address start;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        AddressSpaceKt.access$requireAddressRangeIntersectsArena(this, range);
        Address address2 = this.floorKey(range.getStart());
        if (address2 == null) {
            address2 = start = this.getRange().getStart();
        }
        if ((address = this.higherKey(range.getEndInclusive())) == null || (address = address.minus(1)) == null) {
            address = this.getRange().getEndInclusive();
        }
        Address endInclusive = address;
        return (AddressRange)AddressUtil.checkNotEmpty((ClosedRange)AddressUtil.addressRangeInclusive(start, endInclusive));
    }

    private final NavigableMap<Address, Interval> subMapView(AddressRange rangeSpan) {
        return this.subMap(rangeSpan.getStart(), true, rangeSpan.getEndInclusive(), true);
    }

    @Override
    public void removeAll(@NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.subMapView(this.span(range)).clear();
        this.myModificationCount.incrementAndGet();
    }

    @Override
    public void remove(@NotNull Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Interval oldInterval = (Interval)this.remove((Object)interval.getRange().getStart());
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)oldInterval, (Object)interval)) {
            boolean bl2 = false;
            String string = "Removed unexpected interval " + oldInterval;
            throw new IllegalStateException(string.toString());
        }
        this.myModificationCount.incrementAndGet();
    }

    @Override
    @Nullable
    public Interval put(@NotNull Interval interval) {
        Interval interval2;
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        AddressRange range = interval.getRange();
        Address start = range.getStart();
        if (!this.getRange().contains(range)) {
            boolean $i$a$-require-IntervalTreeMap$put$22 = false;
            String $i$a$-require-IntervalTreeMap$put$22 = "Interval must be allocated within arena range";
            throw new IllegalArgumentException($i$a$-require-IntervalTreeMap$put$22.toString());
        }
        Interval oldInterval = interval2 = this.put(start, interval);
        boolean bl = false;
        this.myModificationCount.incrementAndGet();
        if (!(oldInterval == null || oldInterval.getRange().contains(range))) {
            boolean $i$a$-check-IntervalTreeMap$put$2$42 = false;
            String $i$a$-check-IntervalTreeMap$put$2$42 = "Attempting unsafe region replacement";
            throw new IllegalStateException($i$a$-check-IntervalTreeMap$put$2$42.toString());
        }
        if (start.compareTo(this.getRange().getStart()) > 0 && !Intrinsics.areEqual((Object)((Interval)this.get((Object)start.minus(1))).getRange().getEndInclusive(), (Object)start.minus(1))) {
            boolean $i$a$-check-IntervalTreeMap$put$2$52 = false;
            String $i$a$-check-IntervalTreeMap$put$2$52 = "New region put next to a hole (must be adjacent)";
            throw new IllegalStateException($i$a$-check-IntervalTreeMap$put$2$52.toString());
        }
        if (!(this.get((Object)range.getEndInclusive()) == interval)) {
            boolean bl2 = false;
            String string = "New region overlaps a subsequent";
            throw new IllegalStateException(string.toString());
        }
        return interval2;
    }

    @Override
    public long getModificationCount() {
        return this.myModificationCount.get();
    }
}

