/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.memory.AbstractDocRegion;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import com.jetbrains.cidr.execution.debugger.memory.Interval;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 6*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u00016B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u0012J\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u00102\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00002\u0006\u0010\u001b\u001a\u00020\u0018H\u0014J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\"\u0010\"\u001a\u00020\u00102\n\u0010#\u001a\u00060$j\u0002`%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'H$J\u0014\u0010(\u001a\u00020\u00102\n\u0010#\u001a\u00060$j\u0002`%H\u0014J\u0014\u0010)\u001a\u00020\u00102\n\u0010#\u001a\u00060$j\u0002`%H\u0014J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020 H$J\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020+H$J\u0018\u0010/\u001a\u00020 2\u0006\u0010.\u001a\u00020+2\u0006\u0010,\u001a\u00020 H\u0014J\u0012\u00100\u001a\u0004\u0018\u00010+2\u0006\u00101\u001a\u00020 H\u0016J\u0010\u00102\u001a\u00020 2\u0006\u0010.\u001a\u00020+H\u0016J\u0010\u00103\u001a\u00020 2\u0006\u0010.\u001a\u00020+H\u0016J\b\u00104\u001a\u000205H\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00067"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/BaseDocRegion;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/AbstractDocRegion;", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed$Loaded;", "<init>", "(Lcom/intellij/openapi/editor/ex/DocumentEx;Lcom/intellij/openapi/util/TextRange;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed$Loaded;)V", "data", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "getData", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "render", "", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "canBeSeamlesslyUpdatedBy", "", "newRegion", "renderToText", "", "replaceSeamlessly", "oldRegion", "newText", "deleteFromDocument", "getProtectedRanges", "", "startOffset", "", "endOffset", "renderEntry", "buffer", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "dataEntry", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "renderHeader", "renderFooter", "getAddressForLineNumberInsideRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "lineNumber", "getLineNumberInsideRegion", "address", "getOffsetInsideLine", "getAddressForLineNumberInDocument", "line", "getLineNumberInDocument", "getOffsetInDocument", "toString", "", "Companion", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nDocRegion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocRegion.kt\ncom/jetbrains/cidr/execution/debugger/memory/BaseDocRegion\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 DocRegion.kt\ncom/jetbrains/cidr/execution/debugger/memory/AbstractDocRegion$Companion\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,308:1\n19#2:309\n80#3,10:310\n1#4:320\n808#5,11:321\n1869#5,2:332\n1869#5,2:334\n1869#5,2:336\n3575#5,10:338\n1869#5,2:348\n*S KotlinDebug\n*F\n+ 1 DocRegion.kt\ncom/jetbrains/cidr/execution/debugger/memory/BaseDocRegion\n*L\n150#1:309\n154#1:310,10\n166#1:321,11\n166#1:332,2\n183#1:334,2\n240#1:336,2\n254#1:338,10\n245#1:348,2\n*E\n"})
public abstract class BaseDocRegion<T>
extends AbstractDocRegion<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CidrMemoryData.Data<T> data;

    public BaseDocRegion(@NotNull DocumentEx document, @NotNull TextRange textRange2, @NotNull CidrMemoryData.DataRegion.Completed.Loaded<T> dataRegion) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)textRange2, (String)"textRange");
        Intrinsics.checkNotNullParameter(dataRegion, (String)"dataRegion");
        super(document, textRange2, dataRegion);
        this.data = dataRegion.getData();
    }

    @NotNull
    protected final CidrMemoryData.Data<T> getData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void render(@NotNull AddressSpace<DocRegion<T>> reallocatedSpace) {
        Intrinsics.checkNotNullParameter(reallocatedSpace, (String)"reallocatedSpace");
        if (!reallocatedSpace.getRange().contains(this.getRange())) {
            var3_2 = "Failed requirement.";
            throw new IllegalArgumentException(var3_2.toString());
        }
        v0 = (Interval)CollectionsKt.singleOrNull((Iterable)reallocatedSpace.getIntervals());
        if (v0 == null) ** GOTO lbl-1000
        $this$asSafely$iv = v0;
        $i$f$asSafely = false;
        v1 = $this$asSafely$iv;
        if (!(v1 instanceof BaseDocRegion)) {
            v1 = null;
        }
        if ((v0 = (BaseDocRegion)v1) != null) {
            it = $this$asSafely$iv = v0;
            $i$a$-takeIf-BaseDocRegion$render$seamlessRegionUpdate$1 = false;
            v2 = it.canBeSeamlesslyUpdatedBy(this) ? $this$asSafely$iv : null;
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        seamlessRegionUpdate = v2;
        var3_3 = AbstractDocRegion.Companion;
        var4_14 = this.getRangeMarker();
        value$iv = true;
        $i$f$withMarkerGreedy$intellij_cidr_debugger_core = false;
        savedToLeft$iv = $this$withMarkerGreedy$iv.isGreedyToLeft();
        savedToRight$iv = $this$withMarkerGreedy$iv.isGreedyToRight();
        $this$withMarkerGreedy$iv.setGreedyToLeft(value$iv);
        $this$withMarkerGreedy$iv.setGreedyToRight(value$iv);
        try {
            $i$a$-withMarkerGreedy$intellij_cidr_debugger_core-BaseDocRegion$render$1 = false;
            newText = this.renderToText();
            if (seamlessRegionUpdate != null && this.getTextRange().getLength() == newText.length()) {
                this.replaceSeamlessly((BaseDocRegion<?>)seamlessRegionUpdate, newText);
            } else {
                this.getDocument().replaceString(this.getRangeMarker().getStartOffset(), this.getRangeMarker().getEndOffset(), newText);
            }
            $i$a$-withMarkerGreedy$intellij_cidr_debugger_core-BaseDocRegion$render$1 = Unit.INSTANCE;
        }
        finally {
            $this$withMarkerGreedy$iv.setGreedyToLeft(savedToLeft$iv);
            $this$withMarkerGreedy$iv.setGreedyToRight(savedToRight$iv);
        }
        if (!(this.getRangeMarker().getStartOffset() != this.getRangeMarker().getEndOffset())) {
            $i$a$-check-BaseDocRegion$render$2 = false;
            $i$a$-check-BaseDocRegion$render$2 = "DocRegion text range is empty after rendering";
            throw new IllegalStateException($i$a$-check-BaseDocRegion$render$2.toString());
        }
        $this$filterIsInstance$iv = reallocatedSpace.getIntervals();
        $i$f$filterIsInstance = false;
        value$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AbstractDocRegion)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (AbstractDocRegion)element$iv;
            $i$a$-forEach-BaseDocRegion$render$3 = false;
            it.getRangeMarker().dispose();
        }
    }

    public boolean canBeSeamlesslyUpdatedBy(@NotNull BaseDocRegion<?> newRegion) {
        Intrinsics.checkNotNullParameter(newRegion, (String)"newRegion");
        return Intrinsics.areEqual(this.getClass(), newRegion.getClass()) && Intrinsics.areEqual((Object)this.getRange(), (Object)newRegion.getRange()) && newRegion.getRangeMarker().isValid() && Intrinsics.areEqual((Object)newRegion.getTextRange(), (Object)this.getTextRange());
    }

    private final CharSequence renderToText() {
        StringBuilder sb = new StringBuilder();
        this.renderHeader(sb);
        Iterable<CidrMemoryData.DataEntry<T>> $this$forEach$iv = this.data.getEntries();
        boolean $i$f$forEach = false;
        Iterator<CidrMemoryData.DataEntry<T>> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            CidrMemoryData.DataEntry<T> element$iv;
            CidrMemoryData.DataEntry<T> entry = element$iv = iterator.next();
            boolean bl = false;
            this.renderEntry(sb, entry);
        }
        this.renderFooter(sb);
        return sb;
    }

    protected void replaceSeamlessly(@NotNull BaseDocRegion<?> oldRegion, @NotNull CharSequence newText) {
        Intrinsics.checkNotNullParameter(oldRegion, (String)"oldRegion");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        if (this.getRangeMarker().isValid()) {
            int offset = this.getRangeMarker().getStartOffset();
            List<TextRange> protectedRanges = this.getProtectedRanges(offset, this.getRangeMarker().getEndOffset());
            for (TextRange textRange2 : protectedRanges) {
                int startOffset2 = BaseDocRegion.Companion.component1(textRange2);
                int endOffset2 = BaseDocRegion.Companion.component2(textRange2);
                this.getDocument().replaceString(startOffset2, endOffset2, (CharSequence)((Object)newText.subSequence(startOffset2 - offset, endOffset2 - offset)).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFromDocument() {
        try {
            if (this.getRangeMarker().isValid()) {
                List<TextRange> protectedRanges = this.getProtectedRanges(this.getRangeMarker().getStartOffset(), this.getRangeMarker().getEndOffset());
                for (TextRange textRange2 : CollectionsKt.reversed((Iterable)protectedRanges)) {
                    int startOffset2 = BaseDocRegion.Companion.component1(textRange2);
                    int endOffset2 = BaseDocRegion.Companion.component2(textRange2);
                    this.getDocument().deleteString(startOffset2, endOffset2);
                }
                if (!this.getTextRange().isEmpty()) {
                    boolean bl = false;
                    String string = "DocRegion text range is not empty after deleting it";
                    throw new IllegalStateException(string.toString());
                }
            }
        }
        finally {
            this.disposeOnDeletion();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextRange> getProtectedRanges(int startOffset2, int endOffset2) {
        List list;
        Set protectedOffsets = new LinkedHashSet();
        int length = endOffset2 - startOffset2;
        if (length == 0) {
            return CollectionsKt.emptyList();
        }
        IntRange range = new IntRange(startOffset2, endOffset2);
        Processor processor = arg_0 -> BaseDocRegion.getProtectedRanges$lambda$6(range, protectedOffsets, startOffset2, arg_0);
        this.getDocument().processRangeMarkersOverlappingWith(startOffset2, endOffset2, processor);
        List list2 = DocumentMarkupModel.getExistingMarkupModels((Document)((Document)this.getDocument()));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExistingMarkupModels(...)");
        Iterable $this$forEach$iv22 = list2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv22) {
            MarkupModel markupModel = (MarkupModel)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)markupModel);
            BaseDocRegion.getProtectedRanges$processMarkupModel(startOffset2, endOffset2, (Processor<RangeMarker>)processor, markupModel);
        }
        EditorFactory.getInstance().editors((Document)this.getDocument()).forEach(arg_0 -> BaseDocRegion.getProtectedRanges$lambda$10(arg_0 -> BaseDocRegion.getProtectedRanges$lambda$9(startOffset2, endOffset2, processor, range, protectedOffsets, arg_0), arg_0));
        boolean $this$forEach$iv22 = protectedOffsets.contains(0);
        if (_Assertions.ENABLED && !$this$forEach$iv22) {
            String $i$f$forEach2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$forEach2);
        }
        $this$forEach$iv22 = protectedOffsets.contains(length);
        if (_Assertions.ENABLED && !$this$forEach$iv22) {
            String $i$f$forEach2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$forEach2);
        }
        Iterable $this$zipWithNext$iv = CollectionsKt.sorted((Iterable)protectedOffsets);
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list = CollectionsKt.emptyList();
        } else {
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void eachEndOffset;
                void eachStartOffset;
                Object next$iv = iterator$iv.next();
                int n = ((Number)next$iv).intValue();
                int n2 = ((Number)current$iv).intValue();
                List list3 = result$iv;
                boolean bl = false;
                list3.add(new TextRange(startOffset2 + eachStartOffset, startOffset2 + eachEndOffset));
                current$iv = next$iv;
            }
            list = result$iv;
        }
        return list;
    }

    protected abstract void renderEntry(@NotNull Appendable var1, @NotNull CidrMemoryData.DataEntry<? extends T> var2);

    protected void renderHeader(@NotNull Appendable buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
    }

    protected void renderFooter(@NotNull Appendable buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
    }

    @Nullable
    protected abstract Address getAddressForLineNumberInsideRegion(int var1);

    protected abstract int getLineNumberInsideRegion(@NotNull Address var1);

    protected int getOffsetInsideLine(@NotNull Address address, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return 0;
    }

    @Override
    @Nullable
    public Address getAddressForLineNumberInDocument(int line) {
        int n;
        IntRange regionLineRange = this.getLineRangeInDocument();
        int it = n = RangesKt.coerceIn((int)line, (ClosedRange)((ClosedRange)regionLineRange));
        boolean bl = false;
        if (it != line) {
            CidrDebuggerLog.LOG.warn("Line number " + line + " is outside the region line range " + regionLineRange);
        }
        int lineNumberInsideRegion = n - regionLineRange.getStart();
        return this.getAddressForLineNumberInsideRegion(lineNumberInsideRegion);
    }

    @Override
    public int getLineNumberInDocument(@NotNull Address address) {
        int n;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        if (!this.getRangeMarker().isValid()) {
            boolean $i$a$-check-BaseDocRegion$getLineNumberInDocument$22 = false;
            String $i$a$-check-BaseDocRegion$getLineNumberInDocument$22 = "Region is disposed or otherwise removed from the Document";
            throw new IllegalStateException($i$a$-check-BaseDocRegion$getLineNumberInDocument$22.toString());
        }
        int regionLineNumber = this.getDocument().getLineNumber(this.getRangeMarker().getStartOffset());
        int lineNumber = !this.getRange().contains((Comparable)address) ? 0 : this.getLineNumberInsideRegion(address);
        int it = n = RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)(regionLineNumber + lineNumber), (int)(this.getDocument().getLineCount() - 1)), (int)0);
        boolean bl = false;
        if (regionLineNumber + lineNumber != it) {
            CidrDebuggerLog.LOG.warn("Computed line number " + regionLineNumber + "+" + lineNumber + " is outside the document boundary " + it);
        }
        return n;
    }

    @Override
    public int getOffsetInDocument(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        int lineNumber = this.getLineNumberInDocument(address);
        int offsetInLine = this.getOffsetInsideLine(address, lineNumber);
        return RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)(this.getDocument().getLineStartOffset(lineNumber) + offsetInLine), (int)(this.getDocument().getTextLength() - 1)), (int)0);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(range=" + this.getRange() + ", myRangeMarker=" + this.getRangeMarker() + ")";
    }

    private static final void getProtectedRanges$addOffset(IntRange range, Set<Integer> protectedOffsets, int $startOffset, int offset) {
        int n = range.getFirst();
        boolean bl = offset <= range.getLast() ? n <= offset : false;
        if (bl) {
            ((Collection)protectedOffsets).add(offset - $startOffset);
        }
    }

    private static final boolean getProtectedRanges$lambda$6(IntRange $range, Set $protectedOffsets, int $startOffset, RangeMarker eachMarker) {
        BaseDocRegion.getProtectedRanges$addOffset($range, $protectedOffsets, $startOffset, eachMarker.getStartOffset());
        BaseDocRegion.getProtectedRanges$addOffset($range, $protectedOffsets, $startOffset, eachMarker.getEndOffset());
        return true;
    }

    private static final void getProtectedRanges$processMarkupModel(int $startOffset, int $endOffset, Processor<RangeMarker> processor, MarkupModel markupModel) {
        block0: {
            MarkupModelEx markupModelEx = markupModel instanceof MarkupModelEx ? (MarkupModelEx)markupModel : null;
            if (markupModelEx == null) break block0;
            markupModelEx.processRangeHighlightersOverlappingWith($startOffset, $endOffset, processor);
        }
    }

    private static final Unit getProtectedRanges$lambda$9(int $startOffset, int $endOffset, Processor $processor, IntRange $range, Set $protectedOffsets, Editor editor) {
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"getMarkupModel(...)");
        BaseDocRegion.getProtectedRanges$processMarkupModel($startOffset, $endOffset, (Processor<RangeMarker>)$processor, markupModel);
        List list = editor.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Caret caret = (Caret)element$iv;
            boolean bl = false;
            BaseDocRegion.getProtectedRanges$addOffset($range, $protectedOffsets, $startOffset, caret.getOffset());
            BaseDocRegion.getProtectedRanges$addOffset($range, $protectedOffsets, $startOffset, caret.getSelectionStart());
            BaseDocRegion.getProtectedRanges$addOffset($range, $protectedOffsets, $startOffset, caret.getSelectionEnd());
        }
        return Unit.INSTANCE;
    }

    private static final void getProtectedRanges$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0082\u0002J\r\u0010\u0007\u001a\u00020\u0005*\u00020\u0006H\u0082\u0002\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/BaseDocRegion$Companion;", "", "<init>", "()V", "component1", "", "Lcom/intellij/openapi/util/TextRange;", "component2", "intellij.cidr.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        private final int component1(TextRange $this$component1) {
            Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
            return $this$component1.getStartOffset();
        }

        private final int component2(TextRange $this$component2) {
            Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
            return $this$component2.getEndOffset();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

