/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLFrame {
    private final int myIndex;
    @Nullable
    private final String myFunction;
    @Nullable
    private final String myModule;
    @Nullable
    private final String myFile;
    @Nullable
    private final DebuggerSourceFileHash myHash;
    private final int myLine;
    @NotNull
    private final Address myProgramCounter;
    @Nullable
    private final DebuggerDriver.DebuggerLanguage myLanguage;
    private final boolean myOptimized;
    private final boolean myInlined;

    public LLFrame(int index, @Nullable String function, @Nullable String file, @Nullable DebuggerSourceFileHash hash, int line, long pc, @Nullable DebuggerDriver.DebuggerLanguage language, boolean optimized, boolean inlined2, @Nullable String module) {
        this(index, function, file, hash, line, Address.fromUnsignedLong(pc), language, optimized, inlined2, module);
    }

    public LLFrame(int index, @Nullable String function, @Nullable String file, @Nullable DebuggerSourceFileHash hash, int line, @NotNull Address pc, @Nullable DebuggerDriver.DebuggerLanguage language, boolean optimized, boolean inlined2, @Nullable String module) {
        if (pc == null) {
            LLFrame.$$$reportNull$$$0(0);
        }
        this.myIndex = index;
        this.myFunction = StringUtil.nullize((String)function, (boolean)true);
        this.myFile = file == null ? null : FileUtil.toSystemIndependentName((String)file);
        this.myHash = hash;
        this.myLine = line;
        this.myProgramCounter = pc;
        this.myLanguage = language;
        this.myOptimized = optimized;
        this.myInlined = inlined2;
        this.myModule = module;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    @NlsSafe
    public String getFunction() {
        String string = StringUtil.notNullize((String)this.myFunction, (String)"<unknown>");
        if (string == null) {
            LLFrame.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getModule() {
        return this.myModule;
    }

    @Nullable
    public String getFile() {
        return this.myFile;
    }

    @Nullable
    public DebuggerSourceFileHash getHash() {
        return this.myHash;
    }

    public int getLine() {
        return this.myLine;
    }

    @NotNull
    public Address getProgramCounter() {
        Address address = this.myProgramCounter;
        if (address == null) {
            LLFrame.$$$reportNull$$$0(2);
        }
        return address;
    }

    @Nullable
    public DebuggerDriver.DebuggerLanguage getLanguage() {
        return this.myLanguage;
    }

    public boolean getOptimized() {
        return this.myOptimized;
    }

    public boolean getInlined() {
        return this.myInlined;
    }

    public boolean hasDebugInfo() {
        return this.myFile != null;
    }

    public boolean hasSymbolInfo() {
        return this.myFunction != null;
    }

    public String toString() {
        return String.format("%d: %s %s@%s(%s):%d (%s)%s", this.myIndex, this.myProgramCounter, this.myFunction, this.myFile, this.myHash, this.myLine, this.myLanguage, this.myOptimized ? " [opt]" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLFrame gdbFrame = (LLFrame)o;
        if (this.myLine != gdbFrame.myLine) {
            return false;
        }
        if (this.myIndex != gdbFrame.myIndex) {
            return false;
        }
        if (this.myFunction != null ? !this.myFunction.equals(gdbFrame.myFunction) : gdbFrame.myFunction != null) {
            return false;
        }
        if (this.myFile != null ? !this.myFile.equals(gdbFrame.myFile) : gdbFrame.myFile != null) {
            return false;
        }
        if (this.myHash != null ? !this.myHash.equals(gdbFrame.myHash) : gdbFrame.myHash != null) {
            return false;
        }
        if (!this.myProgramCounter.equals(gdbFrame.myProgramCounter)) {
            return false;
        }
        if (this.myLanguage != null ? !this.myLanguage.equals(gdbFrame.myLanguage) : gdbFrame.myLanguage != null) {
            return false;
        }
        return this.myOptimized == gdbFrame.myOptimized;
    }

    public int hashCode() {
        int result = this.myIndex;
        result = 31 * result + (this.myFunction != null ? this.myFunction.hashCode() : 0);
        result = 31 * result + (this.myFile != null ? this.myFile.hashCode() : 0);
        result = 31 * result + (this.myHash != null ? this.myHash.hashCode() : 0);
        result = 31 * result + this.myLine;
        result = 31 * result + this.myProgramCounter.hashCode();
        result = 31 * result + (this.myLanguage != null ? this.myLanguage.hashCode() : 0);
        result = 31 * result + (this.myOptimized ? 1 : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pc";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/LLFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/LLFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgramCounter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

