/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface CidrDisasmRegisterProvider {
    public static final ExtensionPointName<CidrDisasmRegisterProvider> EP_NAME = ExtensionPointName.create((String)"cidr.debugger.disasmRegisterProvider");

    public boolean canProvideRegisters(@NotNull PsiFile var1);

    @NotNull
    public List<CidrRegisterInfo> getRegisters(@NotNull PsiFile var1, int var2);

    @NotNull
    public static List<CidrRegisterInfo> getRegistersFromProviders(@NotNull PsiFile file, int line) {
        if (file == null) {
            CidrDisasmRegisterProvider.$$$reportNull$$$0(0);
        }
        ArrayList<CidrRegisterInfo> result = new ArrayList<CidrRegisterInfo>();
        for (CidrDisasmRegisterProvider provider : EP_NAME.getExtensionList()) {
            if (!provider.canProvideRegisters(file)) continue;
            try {
                result.addAll(provider.getRegisters(file, line));
            }
            catch (Exception e) {
                CidrDebuggerLog.LOG.warn("Failed to get registers from provider " + provider.getClass().getName(), (Throwable)e);
            }
        }
        ArrayList<CidrRegisterInfo> arrayList = result;
        if (arrayList == null) {
            CidrDisasmRegisterProvider.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDisasmRegisterProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDisasmRegisterProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistersFromProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRegistersFromProviders";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class CidrRegisterInfo {
        private final String myRegisterName;
        private final int myLine;

        public CidrRegisterInfo(@NotNull String registerName, int line) {
            if (registerName == null) {
                CidrRegisterInfo.$$$reportNull$$$0(0);
            }
            this.myRegisterName = registerName;
            this.myLine = line;
        }

        @NotNull
        public String getRegisterName() {
            String string = this.myRegisterName;
            if (string == null) {
                CidrRegisterInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int getLine() {
            return this.myLine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registerName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDisasmRegisterProvider$CidrRegisterInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDisasmRegisterProvider$CidrRegisterInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRegisterName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

