/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.ide.ui.UISettings;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebugEventsTimelineContent;
import com.jetbrains.cidr.execution.debugger.TimelineElement;
import com.jetbrains.cidr.execution.debugger.TimelineElementDetailsConsole;
import com.jetbrains.cidr.execution.debugger.TimelineModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimelineRowHeader;", "Ljavax/swing/JComponent;", "model", "Lcom/jetbrains/cidr/execution/debugger/TimelineModel;", "content", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimelineContent;", "detailsView", "Lcom/jetbrains/cidr/execution/debugger/TimelineElementDetailsConsole;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/TimelineModel;Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimelineContent;Lcom/jetbrains/cidr/execution/debugger/TimelineElementDetailsConsole;)V", "getModel", "()Lcom/jetbrains/cidr/execution/debugger/TimelineModel;", "getContent", "()Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimelineContent;", "getDetailsView", "()Lcom/jetbrains/cidr/execution/debugger/TimelineElementDetailsConsole;", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "getScrollPane", "()Lcom/intellij/ui/components/JBScrollPane;", "setScrollPane", "(Lcom/intellij/ui/components/JBScrollPane;)V", "paintComponent", "", "graphics", "Ljava/awt/Graphics;", "MyMouseListener", "intellij.cidr.debugger.core"})
public final class CidrDebugEventsTimelineRowHeader
extends JComponent {
    @NotNull
    private final TimelineModel model;
    @NotNull
    private final CidrDebugEventsTimelineContent content;
    @NotNull
    private final TimelineElementDetailsConsole detailsView;
    @Nullable
    private JBScrollPane scrollPane;

    public CidrDebugEventsTimelineRowHeader(@NotNull TimelineModel model, @NotNull CidrDebugEventsTimelineContent content, @NotNull TimelineElementDetailsConsole detailsView) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)detailsView), (String)"detailsView");
        this.model = model;
        this.content = content;
        this.detailsView = detailsView;
        this.addMouseListener(new MyMouseListener());
        this.addMouseMotionListener(new MyMouseListener());
        this.model.addUpdateListener((Function0<Unit>)((Function0)() -> CidrDebugEventsTimelineRowHeader._init_$lambda$0(this)));
    }

    @NotNull
    public final TimelineModel getModel() {
        return this.model;
    }

    @NotNull
    public final CidrDebugEventsTimelineContent getContent() {
        return this.content;
    }

    @NotNull
    public final TimelineElementDetailsConsole getDetailsView() {
        return this.detailsView;
    }

    @Nullable
    public final JBScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public final void setScrollPane(@Nullable JBScrollPane jBScrollPane) {
        this.scrollPane = jBScrollPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@Nullable Graphics graphics) {
        super.paintComponent(graphics);
        Graphics graphics2 = graphics;
        Graphics graphics3 = graphics2 != null ? graphics2.create() : null;
        Graphics2D graphics2D = graphics3 instanceof Graphics2D ? (Graphics2D)graphics3 : null;
        if (graphics2D == null) {
            return;
        }
        Graphics2D g = graphics2D;
        try {
            UISettings.Companion.setupAntialiasing((Graphics)g);
            g.setFont(CidrDebugEventsTimelineContent.Companion.getFONT());
            Color lineColor = CidrDebugEventsTimelineContent.Companion.getLineColor();
            int width = 150;
            int marginTop = 0;
            int rowHeight = CidrDebugEventsTimelineContent.Companion.rowHeight(this);
            int marginLeft = 5;
            int yOffset = rowHeight + marginTop;
            Iterator<TimelineElement> iterator = this.model.getElements().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<TimelineElement> iterator2 = iterator;
            while (iterator2.hasNext()) {
                TimelineElement event;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                Color defaultColor = g.getColor();
                g.setColor(lineColor);
                g.drawLine(0, yOffset, width, yOffset);
                g.setColor(Intrinsics.areEqual((Object)event, (Object)this.model.getSelectedElement()) ? (Color)JBColor.BLUE : defaultColor);
                g.drawString(StringsKt.take((String)event.getTitle(), (int)50), marginLeft, yOffset - 2);
                g.setColor(defaultColor);
                yOffset += rowHeight;
            }
            this.setPreferredSize(new Dimension(width, CidrDebugEventsTimelineContent.Companion.contentHeight(this.model, rowHeight)));
        }
        finally {
            g.dispose();
        }
    }

    private static final Unit _init_$lambda$0(CidrDebugEventsTimelineRowHeader this$0) {
        this$0.revalidate();
        this$0.repaint();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimelineRowHeader$MyMouseListener;", "Ljava/awt/event/MouseAdapter;", "Ljava/awt/event/MouseMotionListener;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimelineRowHeader;)V", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "mouseMoved", "intellij.cidr.debugger.core"})
    public final class MyMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TimelineElement element = CidrDebugEventsTimelineContent.Companion.elementAtY(CidrDebugEventsTimelineRowHeader.this.getModel(), CidrDebugEventsTimelineRowHeader.this, e.getY());
                if (element == null) break block1;
                CidrDebugEventsTimelineRowHeader.this.getModel().setSelectedElement(element);
                IntRange rangeX = CidrDebugEventsTimelineContent.Companion.elementRangeX(CidrDebugEventsTimelineRowHeader.this.getModel(), element);
                Rectangle scrollRect = new Rectangle(Math.max(rangeX.getFirst() - 10, 0), e.getY(), Math.max(rangeX.getLast() - rangeX.getFirst(), 30), 10);
                CidrDebugEventsTimelineRowHeader.this.getContent().scrollRectToVisible(scrollRect);
                CidrDebugEventsTimelineRowHeader.this.getDetailsView().showDetails(element);
                JBScrollPane jBScrollPane = CidrDebugEventsTimelineRowHeader.this.getScrollPane();
                if (jBScrollPane != null) {
                    jBScrollPane.repaint();
                }
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Integer row = CidrDebugEventsTimelineContent.Companion.rowIndex(CidrDebugEventsTimelineRowHeader.this.getModel(), CidrDebugEventsTimelineRowHeader.this, e.getY());
            if (row != null) {
                UIUtil.setCursor((Component)CidrDebugEventsTimelineRowHeader.this, (Cursor)Cursor.getPredefinedCursor(12));
            } else {
                UIUtil.setCursor((Component)CidrDebugEventsTimelineRowHeader.this, (Cursor)Cursor.getPredefinedCursor(0));
            }
        }
    }
}

