/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildConfigurationProblems {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String title = "";
    public final @NotNull List<@NlsContexts.DialogMessage String> problems = new SmartList();
    public final @NotNull List<@NlsContexts.DialogMessage String> warnings = new SmartList();
    @NotNull
    public final List<Fix> fixes = new SmartList();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getTitle() {
        String string = this.title;
        if (string == null) {
            BuildConfigurationProblems.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @Nls
    public List<String> getProblems() {
        List<String> list = this.problems;
        if (list == null) {
            BuildConfigurationProblems.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    @NlsContexts.DialogMessage
    @NotNull
    public String getHtmlProblems() {
        String string = StringUtil.join(this.problems, (String)"<br>");
        if (string == null) {
            BuildConfigurationProblems.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NlsContexts.DialogMessage
    @NotNull
    public String getTextProblems() {
        String string = StringUtil.join(this.problems, (String)"\n");
        if (string == null) {
            BuildConfigurationProblems.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NlsContexts.DialogMessage
    @NotNull
    public String getText() {
        Object result = this.getTitle();
        if (this.hasProblems()) {
            result = (String)result + "\n" + this.getTextProblems();
        }
        String string = result;
        if (string == null) {
            BuildConfigurationProblems.$$$reportNull$$$0(4);
        }
        return string;
    }

    public @NotNull List<@NlsContexts.DialogMessage String> getWarnings() {
        List<String> list = this.warnings;
        if (list == null) {
            BuildConfigurationProblems.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    @NlsContexts.DialogMessage
    @NotNull
    public String getHtmlWarnings() {
        String string = StringUtil.join(this.warnings, (String)"<br>");
        if (string == null) {
            BuildConfigurationProblems.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void throwAsConfigurationExceptions() throws RuntimeConfigurationException {
        if (this.hasProblems()) {
            throw new RuntimeConfigurationError(this.getHtmlProblems());
        }
        if (this.hasWarnings()) {
            throw new RuntimeConfigurationWarning(this.getHtmlWarnings());
        }
    }

    @NotNull
    public List<Fix> getFixes() {
        List<Fix> list = this.fixes;
        if (list == null) {
            BuildConfigurationProblems.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public Fix findFix(@Nullable String name) {
        for (Fix each : this.fixes) {
            if (!each.name.equals(name)) continue;
            return each;
        }
        return null;
    }

    @NotNull
    public BuildConfigurationProblems join(@NotNull BuildConfigurationProblems that) {
        if (that == null) {
            BuildConfigurationProblems.$$$reportNull$$$0(8);
        }
        if (this.title.isEmpty() && !that.title.isEmpty()) {
            this.title = that.title;
        }
        this.warnings.addAll(that.warnings);
        this.problems.addAll(that.problems);
        this.fixes.addAll(that.fixes);
        BuildConfigurationProblems buildConfigurationProblems = this;
        if (buildConfigurationProblems == null) {
            BuildConfigurationProblems.$$$reportNull$$$0(9);
        }
        return buildConfigurationProblems;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/BuildConfigurationProblems";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblems";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlProblems";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextProblems";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarnings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlWarnings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/BuildConfigurationProblems";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 8 -> new IllegalArgumentException(string);
        };
    }

    public static abstract class Fix {
        @NotNull
        private final String name;

        protected Fix(@NotNull String name) {
            if (name == null) {
                Fix.$$$reportNull$$$0(0);
            }
            this.name = name;
        }

        public abstract void apply();

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                Fix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/BuildConfigurationProblems$Fix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/BuildConfigurationProblems$Fix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

