/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.google.common.collect.Maps;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.PathTreeBase;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathTree<Self extends PathTree<Self, T>, T>
extends PathTreeBase<Self>
implements Cloneable {
    @Nullable
    protected Set<T> myItems;

    public PathTree() {
        this(true);
    }

    public PathTree(boolean resolveSymlinksIfNecessary) {
        super(resolveSymlinksIfNecessary);
    }

    @NotNull
    protected Set<T> createItemsSet(@Nullable Set<T> existing) {
        return existing != null ? new HashSet<T>(existing) : new HashSet();
    }

    public void addItem(@NotNull String path, @NotNull T item) {
        if (path == null) {
            PathTree.$$$reportNull$$$0(0);
        }
        if (item == null) {
            PathTree.$$$reportNull$$$0(1);
        }
        PathTree subTree = (PathTree)this.getNotNullSubTree(path);
        subTree.getItemsForWrite().add(item);
    }

    public void addItems(@NotNull String path, T ... items) {
        if (path == null) {
            PathTree.$$$reportNull$$$0(2);
        }
        if (items == null) {
            PathTree.$$$reportNull$$$0(3);
        }
        PathTree subTree = (PathTree)this.getNotNullSubTree(path);
        ContainerUtil.addAll(subTree.getItemsForWrite(), (Object[])items);
    }

    public int removeItem(@NotNull String path, @NotNull T ref) {
        Set<T> references;
        PathTree subTree;
        if (path == null) {
            PathTree.$$$reportNull$$$0(4);
        }
        if (ref == null) {
            PathTree.$$$reportNull$$$0(5);
        }
        if ((subTree = (PathTree)this.getSubTree(path, PathTreeBase.SearchStrategy.NULL_IF_NOT_FOUND)) != null && (references = subTree.myItems) != null) {
            references.remove(ref);
            return references.size();
        }
        return 0;
    }

    @NotNull
    public Set<T> getItems() {
        Set set = this.myItems == null ? Collections.emptySet() : this.myItems;
        if (set == null) {
            PathTree.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    protected Set<T> getItemsForWrite() {
        Set<T> set = this.myItems == null ? (this.myItems = this.createItemsSet(null)) : this.myItems;
        if (set == null) {
            PathTree.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public Self cloneWithoutSubtree(String path) {
        PathTree result = this.clone((Self)((PathTree)this.self()));
        if (this.myChildren == null) {
            PathTree pathTree = result;
            if (pathTree == null) {
                PathTree.$$$reportNull$$$0(8);
            }
            return (Self)pathTree;
        }
        List pathItems = FileUtil.splitPath((String)path);
        if (pathItems.isEmpty()) {
            PathTree pathTree = result;
            if (pathTree == null) {
                PathTree.$$$reportNull$$$0(9);
            }
            return (Self)pathTree;
        }
        String parentPath = StringUtil.join(pathItems.subList(0, pathItems.size() - 1), (String)File.separator);
        String targetDirectory = (String)ContainerUtil.getLastItem((List)pathItems);
        PathTree parentTree = (PathTree)result.getSubTree(parentPath, PathTreeBase.SearchStrategy.NULL_IF_NOT_FOUND);
        if (parentTree == null || parentTree.myChildren == null) {
            PathTree pathTree = result;
            if (pathTree == null) {
                PathTree.$$$reportNull$$$0(10);
            }
            return (Self)pathTree;
        }
        parentTree.myChildren.remove(targetDirectory);
        PathTree pathTree = result;
        if (pathTree == null) {
            PathTree.$$$reportNull$$$0(11);
        }
        return (Self)pathTree;
    }

    @Override
    Self clone(@Nullable Self parent) {
        PathTree clone = (PathTree)super.clone(parent);
        Set<T> items = this.myItems;
        clone.myItems = items == null ? null : this.createItemsSet(items);
        return (Self)clone;
    }

    @Override
    protected void mergeInto(@NotNull Self mergedTree, @NotNull MultiMap<String, Self> childrenPerKey) {
        if (mergedTree == null) {
            PathTree.$$$reportNull$$$0(12);
        }
        if (childrenPerKey == null) {
            PathTree.$$$reportNull$$$0(13);
        }
        super.mergeInto(mergedTree, childrenPerKey);
        Set<T> items = this.myItems;
        if (items != null) {
            ((PathTree)mergedTree).getItemsForWrite().addAll(items);
        }
    }

    @Override
    public String toString() {
        if (this.guaranteedToBeEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder(1024).append('{');
        this.accept(new PathTreeBase.ToStringVisitor(sb));
        return sb.append('}').toString();
    }

    @Override
    protected boolean isLeaf() {
        return !ContainerUtil.isEmpty(this.myItems);
    }

    @Override
    protected void nodeToString(@NotNull StringBuilder sb, @Nullable String path) {
        if (sb == null) {
            PathTree.$$$reportNull$$$0(14);
        }
        super.nodeToString(sb, path);
        sb.append('=').append(this.myItems);
    }

    @Override
    @NotNull
    protected Object nodeDebugRenderer(@Nullable String path) {
        Map.Entry entry = Maps.immutableEntry((Object)super.nodeDebugRenderer(path), this.myItems);
        if (entry == null) {
            PathTree.$$$reportNull$$$0(15);
        }
        return entry;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/PathTree";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedTree";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenPerKey";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/PathTree";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsForWrite";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithoutSubtree";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "nodeDebugRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addItem";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addItems";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeItem";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mergeInto";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "nodeToString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11, 15 -> new IllegalStateException(string);
        };
    }
}

