/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.PeInfo;
import com.jetbrains.cidr.PeSubsystem;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"readPeInfo", "Lcom/jetbrains/cidr/PeInfo;", "file", "Ljava/nio/file/Path;", "path", "", "tryReadPeInfo", "intellij.cidr.debugger.core"})
public final class ExecutablePeFileFormatUtilKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final PeInfo readPeInfo(@NotNull Path file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Files.isRegularFile(file, new LinkOption[0]) || !Files.isReadable(file)) {
            throw new IOException("Not a readable file: " + file);
        }
        long len = Files.size(file);
        if (len < 0L) {
            throw new IOException("File length reported negative: " + file);
        }
        Closeable closeable = Files.newByteChannel(file, new OpenOption[0]);
        Throwable throwable = null;
        try {
            int n;
            short magic;
            SeekableByteChannel channel = (SeekableByteChannel)closeable;
            boolean bl = false;
            ByteBuffer dosHeader = ByteBuffer.allocate(64);
            if (channel.read(dosHeader) < 64) {
                throw new IOException("Not a valid PE executable: DOS header is too short");
            }
            dosHeader.flip();
            if (dosHeader.getShort(0) != 19802) {
                throw new IOException("Not a valid PE executable: missing DOS magic");
            }
            dosHeader.position(60);
            int peOffset = dosHeader.order(ByteOrder.LITTLE_ENDIAN).getInt();
            if (peOffset < 0) {
                throw new IOException("Invalid e_lfanew (negative)");
            }
            channel.position(peOffset);
            ByteBuffer peHeader = ByteBuffer.allocate(24);
            if (channel.read(peHeader) < 24) {
                throw new IOException("Not a valid PE executable: PE header is too short");
            }
            peHeader.flip();
            if (peHeader.getInt() != 0x50450000) {
                throw new IOException("Not a valid PE executable: missing PE magic");
            }
            peHeader.order(ByteOrder.LITTLE_ENDIAN);
            short peMachineType = peHeader.getShort();
            ArchitectureType architectureType = ArchitectureType.forPeMachineType(peMachineType);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)architectureType), (String)"forPeMachineType(...)");
            ArchitectureType arch = architectureType;
            short rawSize = peHeader.getShort(20);
            int optHeaderSizeInt = rawSize & 0xFFFF;
            if (optHeaderSizeInt <= 0) {
                throw new IOException("Invalid Optional Header size: " + optHeaderSizeInt);
            }
            ByteBuffer optionalHeader = ByteBuffer.allocate(optHeaderSizeInt);
            if (channel.read(optionalHeader) < optHeaderSizeInt) {
                throw new IOException("Not a valid PE executable: Optional Header is too short");
            }
            optionalHeader.flip().order(ByteOrder.LITTLE_ENDIAN);
            short s = magic = optionalHeader.getShort(0);
            if (s == 267) {
                n = 68;
            } else if (s == 523) {
                n = 68;
            } else {
                String string = "Unsupported Optional Header magic: 0x%04X";
                Object[] objectArray = new Object[]{magic};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                throw new IOException(string2);
            }
            int subsystemOffset = n;
            if (subsystemOffset + 2 > optionalHeader.limit()) {
                throw new IOException("Subsystem field is out of Optional Header range");
            }
            short subsystemVal = optionalHeader.getShort(subsystemOffset);
            PeSubsystem subsystem = switch (subsystemVal & 0xFFFF) {
                case 2 -> PeSubsystem.GUI;
                case 3 -> PeSubsystem.CONSOLE;
                default -> PeSubsystem.UNKNOWN;
            };
            PeInfo peInfo = new PeInfo(arch, subsystem);
            return peInfo;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final PeInfo readPeInfo(@NotNull String path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = Path.of(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        return ExecutablePeFileFormatUtilKt.readPeInfo(path2);
    }

    @NotNull
    public static final PeInfo tryReadPeInfo(@NotNull String path) {
        PeInfo peInfo;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            peInfo = ExecutablePeFileFormatUtilKt.readPeInfo(path);
        }
        catch (IOException e) {
            CidrDebuggerLog.LOG.warn("Failed to read PE info from " + path, (Throwable)e);
            peInfo = new PeInfo(ArchitectureType.UNKNOWN, PeSubsystem.UNKNOWN);
        }
        return peInfo;
    }
}

