/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.util;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import trebuchet.io.DataSlice;
import trebuchet.io.GenericByteBuffer;
import trebuchet.io.StreamingReader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u000f2\b\b\u0002\u0010\u0016\u001a\u00020\u000fJ\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u000fJ\"\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u0015\u001a\u00020\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u000fJ\"\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010\u0015\u001a\u00020\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u000fJ \u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Ltrebuchet/util/StringSearch;", "", "lookFor", "", "<init>", "(Ljava/lang/String;)V", "getLookFor", "()Ljava/lang/String;", "skipLut", "", "getSkipLut", "()[B", "suffixSkip", "getSuffixSkip", "length", "", "getLength", "()I", "find", "reader", "Ltrebuchet/io/StreamingReader;", "startIndex", "inEndIndex", "findInLoadedRegion", "endIndex", "buffer", "Ltrebuchet/io/GenericByteBuffer;", "findInWindow", "window", "Ltrebuchet/io/StreamingReader$Window;", "globalStartIndex", "globalEndIndex", "Companion", "intellij.android.profilers.atrace"})
@SourceDebugExtension(value={"SMAP\nStringSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringSearch.kt\ntrebuchet/util/StringSearch\n+ 2 DataSlice.kt\ntrebuchet/io/DataSlice\n*L\n1#1,196:1\n31#2:197\n31#2:198\n*S KotlinDebug\n*F\n+ 1 StringSearch.kt\ntrebuchet/util/StringSearch\n*L\n174#1:197\n182#1:198\n*E\n"})
public final class StringSearch {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String lookFor;
    @NotNull
    private final byte[] skipLut;
    @NotNull
    private final byte[] suffixSkip;

    public StringSearch(@NotNull String lookFor) {
        int i;
        int n;
        Intrinsics.checkNotNullParameter((Object)lookFor, (String)"lookFor");
        this.lookFor = lookFor;
        int n2 = 0;
        byte[] byArray = new byte[256];
        StringSearch stringSearch = this;
        while (n2 < 256) {
            n = n2++;
            byArray[n] = (byte)this.lookFor.length();
        }
        stringSearch.skipLut = byArray;
        this.suffixSkip = new byte[this.lookFor.length()];
        int i2 = 0;
        int last = this.lookFor.length() - 1;
        n = last - 1;
        if (i2 <= n) {
            while (true) {
                this.skipLut[this.lookFor.charAt((int)i2) & 0xFF] = (byte)(last - i2);
                if (i2 == n) break;
                ++i2;
            }
        }
        int lastPrefix = last;
        for (i = last; -1 < i; --i) {
            if (Companion.isPrefix(this.lookFor, i + 1)) {
                lastPrefix = i + 1;
            }
            this.suffixSkip[i] = (byte)(lastPrefix + last - i);
        }
        for (i = 0; i < last; ++i) {
            int suffixLength = Companion.longestCommonSuffix(this.lookFor, i);
            if (this.lookFor.charAt(i - suffixLength) == this.lookFor.charAt(last - suffixLength)) continue;
            this.suffixSkip[last - suffixLength] = (byte)(suffixLength + last - i);
        }
    }

    @NotNull
    public final String getLookFor() {
        return this.lookFor;
    }

    @NotNull
    public final byte[] getSkipLut() {
        return this.skipLut;
    }

    @NotNull
    public final byte[] getSuffixSkip() {
        return this.suffixSkip;
    }

    public final int getLength() {
        return this.lookFor.length();
    }

    public final int find(@NotNull StreamingReader reader, int startIndex, int inEndIndex) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        int index = startIndex + this.lookFor.length() - 1;
        int endIndex = inEndIndex;
        while (index <= endIndex) {
            if (index > reader.getEndIndex()) {
                if (!reader.loadIndex(index)) {
                    return -1;
                }
                if (reader.getReachedEof()) {
                    endIndex = reader.getEndIndex();
                }
            }
            while (reader.windowFor(index) != reader.windowFor(index - this.lookFor.length() + 1)) {
                int lookForIndex;
                for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0 && reader.get(index) == (byte)this.lookFor.charAt(lookForIndex); --lookForIndex) {
                    --index;
                }
                if (lookForIndex < 0) {
                    return index + 1;
                }
                if ((index += (byte)Math.max(this.skipLut[reader.get(index) & 0xFF], this.suffixSkip[lookForIndex])) <= reader.getEndIndex()) continue;
                if (!reader.loadIndex(index)) {
                    return -1;
                }
                if (!reader.getReachedEof()) continue;
                endIndex = reader.getEndIndex();
            }
            StreamingReader.Window window = reader.windowFor(index);
            if ((index = this.findInWindow(window, index, endIndex)) > window.getGlobalEndIndex()) continue;
            return index;
        }
        return -1;
    }

    public static /* synthetic */ int find$default(StringSearch stringSearch, StreamingReader streamingReader, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = Integer.MAX_VALUE;
        }
        return stringSearch.find(streamingReader, n, n2);
    }

    public final int findInLoadedRegion(@NotNull StreamingReader reader, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        int index = reader.getStartIndex() + this.lookFor.length() - 1;
        while (index <= endIndex) {
            while (reader.windowFor(index) != reader.windowFor(index - this.lookFor.length() + 1)) {
                int lookForIndex;
                for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0 && reader.get(index) == (byte)this.lookFor.charAt(lookForIndex); --lookForIndex) {
                    --index;
                }
                if (lookForIndex < 0) {
                    return index + 1;
                }
                index += (byte)Math.max(this.skipLut[reader.get(index) & 0xFF], this.suffixSkip[lookForIndex]);
            }
            StreamingReader.Window window = reader.windowFor(index);
            if ((index = this.findInWindow(window, index, endIndex)) >= window.getGlobalEndIndex() || index >= endIndex) continue;
            return index;
        }
        return -1;
    }

    public static /* synthetic */ int findInLoadedRegion$default(StringSearch stringSearch, StreamingReader streamingReader, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = streamingReader.getEndIndex();
        }
        return stringSearch.findInLoadedRegion(streamingReader, n);
    }

    public final int find(@NotNull GenericByteBuffer buffer, int startIndex, int endIndex) {
        int lookForIndex;
        int index;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        for (index = startIndex + this.lookFor.length() - 1; index < endIndex; index += (byte)Math.max(this.skipLut[buffer.get(index) & 0xFF], this.suffixSkip[lookForIndex])) {
            for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0 && buffer.get(index) == (byte)this.lookFor.charAt(lookForIndex); --lookForIndex) {
                --index;
            }
            if (lookForIndex >= 0) continue;
            ++index;
            break;
        }
        return index;
    }

    public static /* synthetic */ int find$default(StringSearch stringSearch, GenericByteBuffer genericByteBuffer, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = genericByteBuffer.getLength();
        }
        return stringSearch.find(genericByteBuffer, n, n2);
    }

    public final int find(@NotNull byte[] buffer, int startIndex, int endIndex) {
        int lookForIndex;
        int index;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        for (index = startIndex + this.lookFor.length() - 1; index < endIndex; index += (byte)Math.max(this.skipLut[buffer[index] & 0xFF], this.suffixSkip[lookForIndex])) {
            for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0 && buffer[index] == (byte)this.lookFor.charAt(lookForIndex); --lookForIndex) {
                --index;
            }
            if (lookForIndex >= 0) continue;
            ++index;
            break;
        }
        return index;
    }

    public static /* synthetic */ int find$default(StringSearch stringSearch, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return stringSearch.find(byArray, n, n2);
    }

    private final int findInWindow(StreamingReader.Window window, int globalStartIndex, int globalEndIndex) {
        int index;
        byte by;
        byte by2;
        DataSlice buffer = window.getSlice();
        int endIndex = Math.min(window.getGlobalEndIndex(), globalEndIndex) - window.getGlobalStartIndex();
        for (index = globalStartIndex - window.getGlobalStartIndex(); index <= endIndex; index += (byte)Math.max(by2, by)) {
            DataSlice this_$iv;
            boolean $i$f$get;
            int i$iv;
            int lookForIndex;
            for (lookForIndex = this.lookFor.length() - 1; lookForIndex >= 0; --lookForIndex) {
                DataSlice dataSlice = buffer;
                i$iv = index--;
                $i$f$get = false;
                if (this_$iv.getBuffer()[this_$iv.getStartIndex() + i$iv] != (byte)this.lookFor.charAt(lookForIndex)) break;
            }
            if (lookForIndex < 0) {
                ++index;
                break;
            }
            this_$iv = buffer;
            i$iv = index;
            $i$f$get = false;
            by2 = this.skipLut[this_$iv.getBuffer()[this_$iv.getStartIndex() + i$iv] & 0xFF];
            by = this.suffixSkip[lookForIndex];
        }
        return index + window.getGlobalStartIndex();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Ltrebuchet/util/StringSearch$Companion;", "", "<init>", "()V", "isPrefix", "", "str", "", "pos", "", "longestCommonSuffix", "word", "intellij.android.profilers.atrace"})
    @SourceDebugExtension(value={"SMAP\nStringSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringSearch.kt\ntrebuchet/util/StringSearch$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n2746#2,3:197\n*S KotlinDebug\n*F\n+ 1 StringSearch.kt\ntrebuchet/util/StringSearch$Companion\n*L\n33#1:197,3\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        public final boolean isPrefix(@NotNull CharSequence str, int pos) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                Iterable $this$none$iv = (Iterable)RangesKt.until((int)0, (int)(str.length() - pos));
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator = $this$none$iv.iterator();
                    while (iterator.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator).nextInt();
                        boolean bl2 = false;
                        if (!(str.charAt(it) != str.charAt(pos + it))) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        public final int longestCommonSuffix(@NotNull CharSequence word, int pos) {
            int i;
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            for (i = 0; word.charAt(pos - i) == word.charAt(word.length() - 1 - i) && i < pos; ++i) {
            }
            return i;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

