/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.tasks.taskhandlers;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.tasks.TaskTypeMappingUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tJ@\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0016\u0010\u0013\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\u00140\t\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/profilers/tasks/taskhandlers/TaskHandlerUtils;", "", "<init>", "()V", "executeTaskAction", "", "action", "Lkotlin/Function0;", "errorHandler", "Lkotlin/Function1;", "", "findTaskArtifact", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "selectedSession", "Lcom/android/tools/profiler/proto/Common$Session;", "sessionIdToSessionItems", "", "", "Lcom/android/tools/profilers/sessions/SessionItem;", "supportsArtifact", "", "intellij.android.profilers"})
public final class TaskHandlerUtils {
    @NotNull
    public static final TaskHandlerUtils INSTANCE = new TaskHandlerUtils();

    private TaskHandlerUtils() {
    }

    public final void executeTaskAction(@NotNull Function0<Unit> action, @NotNull Function1<? super String, Unit> errorHandler) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        try {
            action.invoke();
        }
        catch (Exception e) {
            errorHandler.invoke((Object)e.toString());
        }
    }

    @Nullable
    public final SessionArtifact<?> findTaskArtifact(@NotNull Common.Session selectedSession, @NotNull Map<Long, SessionItem> sessionIdToSessionItems, @NotNull Function1<? super SessionArtifact<?>, Boolean> supportsArtifact) {
        SessionArtifact<?> sessionArtifact;
        SessionItem sessionItem;
        Intrinsics.checkNotNullParameter((Object)selectedSession, (String)"selectedSession");
        Intrinsics.checkNotNullParameter(sessionIdToSessionItems, (String)"sessionIdToSessionItems");
        Intrinsics.checkNotNullParameter(supportsArtifact, (String)"supportsArtifact");
        SessionItem sessionItem2 = sessionItem = sessionIdToSessionItems.get(selectedSession.getSessionId());
        if (sessionItem2 != null) {
            SessionItem it = sessionItem2;
            boolean bl = false;
            List<SessionArtifact<?>> childArtifacts = it.getChildArtifacts();
            sessionArtifact = childArtifacts.isEmpty() && it.getProfilers().getSessionsManager().getCurrentTaskType() == TaskTypeMappingUtils.convertTaskType(Common.ProfilerTaskType.LIVE_VIEW) ? (SessionArtifact<?>)it : (childArtifacts.size() == 1 && ((Boolean)supportsArtifact.invoke(childArtifacts.get(0))).booleanValue() ? childArtifacts.get(0) : null);
        } else {
            sessionArtifact = null;
        }
        return sessionArtifact;
    }
}

