/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.tasks.taskhandlers;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.taskbased.home.StartTaskSelectionError;
import com.android.tools.profilers.tasks.TaskEventTrackerUtils;
import com.android.tools.profilers.tasks.args.TaskArgs;
import com.android.tools.profilers.tasks.taskhandlers.TaskHandlerUtils;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH&J\b\u0010\u000f\u001a\u00020\rH&J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\b\u0010\u0011\u001a\u00020\u0012H&J*\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\t2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001dH&J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\tH$J\u0014\u0010\u001f\u001a\u00020\u000b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH$J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H&J\u000e\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/profilers/tasks/taskhandlers/ProfilerTaskHandler;", "", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "<init>", "(Lcom/android/tools/profilers/sessions/SessionsManager;)V", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "enter", "", "args", "Lcom/android/tools/profilers/tasks/args/TaskArgs;", "exit", "", "startTask", "stopTask", "loadTask", "getTaskName", "", "createArgs", "isStartupTask", "sessionItems", "", "", "Lcom/android/tools/profilers/sessions/SessionItem;", "selectedSession", "Lcom/android/tools/profiler/proto/Common$Session;", "supportsArtifact", "artifact", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "createStartTaskArgs", "createLoadingTaskArgs", "checkSupportForDeviceAndProcess", "Lcom/android/tools/profilers/taskbased/home/StartTaskSelectionError;", "device", "Lcom/android/tools/profiler/proto/Common$Device;", "process", "Lcom/android/tools/profiler/proto/Common$Process;", "handleError", "errorMessage", "intellij.android.profilers"})
public abstract class ProfilerTaskHandler {
    @NotNull
    private final SessionsManager sessionsManager;

    public ProfilerTaskHandler(@NotNull SessionsManager sessionsManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        this.sessionsManager = sessionsManager;
    }

    private final Logger getLogger() {
        Logger logger = Logger.getInstance(ProfilerTaskHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    public boolean enter(@NotNull TaskArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        StudioProfilers studioProfilers = this.sessionsManager.getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
        TaskEventTrackerUtils.trackTaskEntered(studioProfilers);
        if (!this.sessionsManager.isSessionAlive()) {
            return this.loadTask(args);
        }
        this.startTask(args);
        return true;
    }

    public void exit() {
    }

    public abstract void startTask(@NotNull TaskArgs var1);

    public abstract void stopTask();

    public abstract boolean loadTask(@NotNull TaskArgs var1);

    @NotNull
    public abstract String getTaskName();

    @NotNull
    public final TaskArgs createArgs(boolean isStartupTask, @NotNull Map<Long, SessionItem> sessionItems, @NotNull Common.Session selectedSession) {
        TaskArgs taskArgs;
        Intrinsics.checkNotNullParameter(sessionItems, (String)"sessionItems");
        Intrinsics.checkNotNullParameter((Object)selectedSession, (String)"selectedSession");
        boolean isTaskOngoing = SessionsManager.isSessionAlive(selectedSession);
        SessionArtifact<?> artifact2 = TaskHandlerUtils.INSTANCE.findTaskArtifact(selectedSession, sessionItems, (Function1)new Function1<SessionArtifact<?>, Boolean>(this){

            public final Boolean invoke(SessionArtifact<?> p0) {
                return ((ProfilerTaskHandler)this.receiver).supportsArtifact(p0);
            }
        });
        if (isTaskOngoing) {
            taskArgs = this.createStartTaskArgs(isStartupTask);
        } else if (artifact2 != null && this.supportsArtifact(artifact2)) {
            taskArgs = this.createLoadingTaskArgs(artifact2);
        } else {
            throw new IllegalStateException("No supported artifact was found to construct the TaskArgs with");
        }
        return taskArgs;
    }

    public abstract boolean supportsArtifact(@Nullable SessionArtifact<?> var1);

    @NotNull
    protected abstract TaskArgs createStartTaskArgs(boolean var1);

    @NotNull
    protected abstract TaskArgs createLoadingTaskArgs(@NotNull SessionArtifact<?> var1);

    @Nullable
    public abstract StartTaskSelectionError checkSupportForDeviceAndProcess(@NotNull Common.Device var1, @NotNull Common.Process var2);

    public final void handleError(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.getLogger().error("There was an error with the " + this.getTaskName() + " task. Error message: " + errorMessage + ".");
    }
}

