/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.sessions;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.stdui.ContextMenuItem;
import com.android.tools.adtui.stdui.DefaultContextMenuItem;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.profilers.ExportArtifactUtils;
import com.android.tools.profilers.ExportableArtifact;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.SupportLevel;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionArtifactView;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public final class SessionItemView
extends SessionArtifactView<SessionItem> {
    private static final Border DIVIDER_BORDER = JBUI.Borders.customLine((Color)ProfilerColors.SESSION_DIVIDER_COLOR, (int)1, (int)0, (int)0, (int)0);
    private static final Border COMPONENT_PADDING = JBUI.Borders.empty((int)4, (int)2, (int)4, (int)4);
    private static final Font SESSION_TIME_FONT = TITLE_FONT.deriveFont(Collections.singletonMap(TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMIBOLD));

    public SessionItemView(@NotNull SessionArtifactView.ArtifactDrawInfo artifactDrawInfo, @NotNull SessionItem artifact2) {
        super(artifactDrawInfo, artifact2);
    }

    @Override
    @NotNull
    protected JComponent buildComponent() {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("Fit,Fit,*", "Fit,Fit,Fit"));
        boolean isSessionAlive = SessionsManager.isSessionAlive(((SessionItem)this.getArtifact()).getSession());
        JLabel startTime = new JLabel(TimeFormatter.getLocalizedTime((long)((SessionItem)this.getArtifact()).getSessionMetaData().getStartTimestampEpochMs()));
        startTime.setBorder(LABEL_PADDING);
        startTime.setFont(SESSION_TIME_FONT);
        startTime.setForeground(StandardColors.TEXT_COLOR);
        panel.add((Component)startTime, new TabularLayout.Constraint(0, 0));
        JPanel liveDotWrapper = new JPanel(new BorderLayout());
        int titleColumnCount = 1;
        if (isSessionAlive) {
            liveDotWrapper.setBorder(ProfilerLayout.TOOLBAR_ICON_BORDER);
            liveDotWrapper.setOpaque(false);
            LiveSessionDot liveDot = new LiveSessionDot();
            liveDot.setToolTipText("Currently Profiling");
            this.installContextMenus(liveDot);
            this.addMouseListeningComponents(liveDot);
            liveDotWrapper.add((Component)liveDot, "Center");
            panel.add((Component)liveDotWrapper, new TabularLayout.Constraint(0, titleColumnCount++));
        }
        if (((SessionItem)this.getArtifact()).getProfilers().getLiveProcessSupportLevel(((SessionItem)this.getArtifact()).getSession().getPid()) == SupportLevel.PROFILEABLE) {
            JLabel infoLabel = new JLabel("");
            infoLabel.setBorder((Border)new JBEmptyBorder(0, 4, 0, 0));
            infoLabel.setIcon(StudioIcons.Common.INFO);
            HelpTooltip tooltip = new HelpTooltip();
            tooltip.setTitle("Profileable process");
            tooltip.setDescription("Capabilities are limited for profileable processes");
            tooltip.setLink("More info", () -> BrowserUtil.browse((String)"https://d.android.com/r/studio-ui/profiler/profileable"));
            tooltip.installOn((JComponent)infoLabel);
            panel.add((Component)infoLabel, new TabularLayout.Constraint(0, titleColumnCount++));
        }
        JLabel sessionName = new JLabel(((SessionItem)this.getArtifact()).getName());
        sessionName.setBorder(LABEL_PADDING);
        sessionName.setFont(STATUS_FONT);
        sessionName.setForeground(StandardColors.TEXT_COLOR);
        sessionName.setToolTipText(((SessionItem)this.getArtifact()).getName());
        this.installContextMenus(sessionName);
        this.addMouseListeningComponents(sessionName);
        panel.add((Component)sessionName, new TabularLayout.Constraint(1, 0, 1, 3));
        JLabel durationLabel = new JLabel(((SessionItem)this.getArtifact()).getSubtitle());
        durationLabel.setBorder(LABEL_PADDING);
        durationLabel.setFont(STATUS_FONT);
        durationLabel.setForeground(AdtUiUtils.overlayColor((int)durationLabel.getBackground().getRGB(), (int)StandardColors.TEXT_COLOR.getRGB(), (float)0.6f));
        panel.add((Component)durationLabel, new TabularLayout.Constraint(2, 0, 1, 3));
        int fillerWidth = Math.max(sessionName.getMinimumSize().width, durationLabel.getMinimumSize().width) - startTime.getMinimumSize().width - (isSessionAlive ? liveDotWrapper.getMinimumSize().width : 0);
        Dimension fillerDimension = new Dimension(fillerWidth, 1);
        Box.Filler filler = new Box.Filler(fillerDimension, fillerDimension, fillerDimension);
        panel.add((Component)filler, new TabularLayout.Constraint(0, 2));
        ((SessionItem)this.getArtifact()).addDependency(this.myObserver).onChange((Enum)SessionItem.Aspect.MODEL, () -> {
            int updatedFillerWidth;
            Dimension updatedFillerDimension;
            if (!Objects.equals(((SessionItem)this.getArtifact()).getSubtitle(), durationLabel.getText())) {
                durationLabel.setText(((SessionItem)this.getArtifact()).getSubtitle());
            }
            if (!(updatedFillerDimension = new Dimension(updatedFillerWidth = Math.max(sessionName.getMinimumSize().width, durationLabel.getMinimumSize().width) - startTime.getMinimumSize().width - (isSessionAlive ? liveDotWrapper.getMinimumSize().width : 0), 1)).equals(filler.getMinimumSize())) {
                filler.changeShape(updatedFillerDimension, updatedFillerDimension, updatedFillerDimension);
            }
        });
        this.getProfilers().getSessionsManager().addDependency(this.myObserver).onChange((Enum)SessionAspect.SELECTED_SESSION, () -> this.updateBorder(panel));
        this.updateBorder(panel);
        return panel;
    }

    private void updateBorder(@NotNull JPanel panel) {
        Border selectionBorder = this.isSessionSelected() ? JBUI.Borders.merge((Border)SELECTED_BORDER, (Border)COMPONENT_PADDING, (boolean)false) : JBUI.Borders.merge((Border)UNSELECTED_BORDER, (Border)COMPONENT_PADDING, (boolean)false);
        panel.setBorder(this.getIndex() == 0 ? selectionBorder : JBUI.Borders.merge((Border)DIVIDER_BORDER, (Border)selectionBorder, (boolean)false));
    }

    @Override
    @NotNull
    protected List<ContextMenuItem> getContextMenus() {
        boolean canEndSession = SessionsManager.isSessionAlive(((SessionItem)this.getArtifact()).getSession());
        Icon endIcon = canEndSession ? StudioIcons.Profiler.Toolbar.STOP_SESSION : IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.STOP_SESSION);
        DefaultContextMenuItem endAction = new DefaultContextMenuItem.Builder("End session").setEnableBooleanSupplier(() -> canEndSession).setActionRunnable(() -> this.getSessionsView().stopProfilingSession()).setIcon(endIcon).build();
        DefaultContextMenuItem deleteAction = new DefaultContextMenuItem.Builder("Delete").setContainerComponent((JComponent)this).setActionRunnable(() -> ((SessionItem)this.getArtifact()).deleteSession()).setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke(127, 0), KeyStroke.getKeyStroke(8, 0)}).build();
        return ImmutableList.of((Object)endAction, (Object)ContextMenuItem.SEPARATOR, (Object)deleteAction);
    }

    @Override
    protected void exportArtifact() {
        List<SessionArtifact<?>> childArtifacts = ((SessionItem)this.getArtifact()).getChildArtifacts();
        assert (childArtifacts.size() == 1);
        SessionArtifact<?> artifact2 = childArtifacts.get(0);
        assert (!artifact2.isOngoing());
        assert (artifact2 instanceof ExportableArtifact);
        ExportableArtifact exportableArtifact = (ExportableArtifact)((Object)artifact2);
        String exportableName = exportableArtifact.getExportableName();
        String exportExtension = exportableArtifact.getExportExtension();
        String fullCaptureName = artifact2.getSessionMetaData().getSessionName();
        int indexOfDot = fullCaptureName.lastIndexOf(46);
        if (indexOfDot != -1) {
            exportableName = fullCaptureName.substring(0, indexOfDot);
            exportExtension = fullCaptureName.substring(indexOfDot + 1);
        }
        ExportArtifactUtils.exportArtifact(exportableName, exportExtension, artifact2::export, this.getSessionsView().getIdeProfilerComponents(), this.getProfilers().getIdeServices());
    }

    private static class LiveSessionDot
    extends JComponent {
        private static final int SIZE = JBUI.scale((int)10);
        private static final Dimension DIMENSION = new Dimension(SIZE, SIZE);

        private LiveSessionDot() {
        }

        @Override
        public Dimension getMinimumSize() {
            return DIMENSION;
        }

        @Override
        public Dimension getMaximumSize() {
            return DIMENSION;
        }

        @Override
        public Dimension getPreferredSize() {
            return DIMENSION;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(ProfilerColors.ACTIVE_SESSION_COLOR);
            g2d.fillOval(0, 0, SIZE, SIZE);
            g2d.dispose();
        }
    }
}

