/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.sessions;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.android.tools.profilers.tasks.TaskSupportUtils;
import com.android.tools.profilers.tasks.TaskTypeMappingUtils;
import com.android.tools.profilers.tasks.taskhandlers.ProfilerTaskHandler;
import com.google.common.annotations.VisibleForTesting;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003:\u00029:B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u000e\u0010+\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u0004J\b\u0010,\u001a\u00020(H\u0016J\u0010\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\u0012H\u0016J\b\u0010/\u001a\u00020(H\u0002J\u0006\u00100\u001a\u00020(J\u0006\u00101\u001a\u00020\u0018J\u0010\u00102\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000303J\u0018\u00104\u001a\u00020(2\u0010\u00105\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000303J\u0006\u00106\u001a\u00020\u0014J\u0006\u00107\u001a\u000208R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010$\u00a8\u0006;"}, d2={"Lcom/android/tools/profilers/sessions/SessionItem;", "Lcom/android/tools/adtui/model/AspectModel;", "Lcom/android/tools/profilers/sessions/SessionItem$Aspect;", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "Lcom/android/tools/profiler/proto/Common$Session;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "initialSession", "sessionMetaData", "Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/profiler/proto/Common$Session;Lcom/android/tools/profiler/proto/Common$SessionMetaData;)V", "getProfilers", "()Lcom/android/tools/profilers/StudioProfilers;", "getSessionMetaData", "()Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "activeSession", "durationNs", "", "waitingForAgent", "", "childArtifacts", "", "name", "", "getName", "()Ljava/lang/String;", "session", "getSession", "()Lcom/android/tools/profiler/proto/Common$Session;", "artifactProto", "getArtifactProto", "timestampNs", "getTimestampNs", "()J", "isOngoing", "()Z", "canExport", "getCanExport", "export", "", "outputStream", "Ljava/io/OutputStream;", "setSession", "doSelect", "update", "elapsedNs", "agentStatusChanged", "deleteSession", "getSubtitle", "getChildArtifacts", "", "setChildArtifacts", "artifacts", "containsExactlyOneArtifact", "getTaskType", "Lcom/android/tools/profilers/tasks/ProfilerTaskType;", "Aspect", "Companion", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nSessionItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionItem.kt\ncom/android/tools/profilers/sessions/SessionItem\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,215:1\n536#2:216\n521#2,6:217\n*S KotlinDebug\n*F\n+ 1 SessionItem.kt\ncom/android/tools/profilers/sessions/SessionItem\n*L\n171#1:216\n171#1:217,6\n*E\n"})
public final class SessionItem
extends AspectModel<Aspect>
implements SessionArtifact<Common.Session> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StudioProfilers profilers;
    @NotNull
    private final Common.SessionMetaData sessionMetaData;
    @NotNull
    private Common.Session activeSession;
    private long durationNs;
    private boolean waitingForAgent;
    @NotNull
    private final List<SessionArtifact<?>> childArtifacts;
    @NotNull
    private final String name;
    private final long timestampNs;
    @NotNull
    private static final String SESSION_INITIALIZING = "Starting...";
    @NotNull
    public static final String SESSION_LOADING = "Loading...";

    public SessionItem(@NotNull StudioProfilers profilers, @NotNull Common.Session initialSession, @NotNull Common.SessionMetaData sessionMetaData) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)initialSession, (String)"initialSession");
        Intrinsics.checkNotNullParameter((Object)sessionMetaData, (String)"sessionMetaData");
        this.profilers = profilers;
        this.sessionMetaData = sessionMetaData;
        this.activeSession = initialSession;
        this.childArtifacts = new ArrayList();
        this.name = SessionItem.Companion.parseName(this.getSessionMetaData());
        if (!SessionsManager.isSessionAlive(this.activeSession)) {
            this.durationNs = this.activeSession.getEndTimestamp() - this.activeSession.getStartTimestamp();
        }
        this.getProfilers().addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.AGENT, () -> SessionItem._init_$lambda$0(this));
        this.agentStatusChanged();
    }

    @Override
    @NotNull
    public StudioProfilers getProfilers() {
        return this.profilers;
    }

    @Override
    @NotNull
    public Common.SessionMetaData getSessionMetaData() {
        return this.sessionMetaData;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this.activeSession;
    }

    @Override
    @NotNull
    public Common.Session getArtifactProto() {
        return this.activeSession;
    }

    @Override
    public long getTimestampNs() {
        return this.timestampNs;
    }

    @Override
    public boolean isOngoing() {
        return SessionsManager.isSessionAlive(this.activeSession);
    }

    @Override
    public boolean getCanExport() {
        return true;
    }

    @Override
    public void export(@NotNull OutputStream outputStream) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        boolean bl2 = bl = this.childArtifacts.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        SessionArtifact artifact2 = (SessionArtifact)CollectionsKt.first(this.childArtifacts);
        artifact2.export(outputStream);
    }

    public final void setSession(@NotNull Common.Session session) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        boolean bl2 = bl = this.activeSession.getSessionId() == session.getSessionId();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.activeSession = session;
    }

    @Override
    public void doSelect() {
        this.getProfilers().getSessionsManager().setSession(this.activeSession);
        if (this.getSessionMetaData().getType() == Common.SessionMetaData.SessionType.FULL && !this.getProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
            StudioMonitorStage targetStageClass = new StudioMonitorStage(this.getProfilers());
            if (!Intrinsics.areEqual(this.getProfilers().getStageClass(), ((Object)((Object)targetStageClass)).getClass()) || !Intrinsics.areEqual((Object)this.getProfilers().getSessionsManager().getSelectedSession(), (Object)this.getProfilers().getSessionsManager().getProfilingSession())) {
                this.getProfilers().setStage(targetStageClass);
            }
        }
        this.getProfilers().getIdeServices().getFeatureTracker().trackSessionArtifactSelected(this, this.getProfilers().getSessionsManager().isSessionAlive());
    }

    @Override
    public void update(long elapsedNs) {
        if (SessionsManager.isSessionAlive(this.activeSession)) {
            this.durationNs += elapsedNs;
            this.changed(Aspect.MODEL);
        }
    }

    private final void agentStatusChanged() {
        boolean oldValue = this.waitingForAgent;
        if (SessionsManager.isSessionAlive(this.activeSession) && Intrinsics.areEqual((Object)this.activeSession, (Object)this.getProfilers().getSessionsManager().getSelectedSession())) {
            Common.AgentData agentData = this.getProfilers().getAgentData();
            Intrinsics.checkNotNullExpressionValue((Object)agentData, (String)"getAgentData(...)");
            Common.AgentData agentData2 = agentData;
            v1 = agentData2.getStatus() == Common.AgentData.Status.UNSPECIFIED;
        } else {
            v1 = this.waitingForAgent = false;
        }
        if (oldValue != this.waitingForAgent) {
            this.changed(Aspect.MODEL);
        }
    }

    public final void deleteSession() {
        this.getProfilers().getSessionsManager().deleteSession(this.activeSession);
    }

    @NotNull
    public final String getSubtitle() {
        String string;
        if (this.getSessionMetaData().getType() != Common.SessionMetaData.SessionType.FULL) {
            String string2;
            if (!((Collection)this.childArtifacts).isEmpty()) {
                boolean bl;
                boolean bl2 = bl = this.childArtifacts.size() == 1;
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                string2 = this.childArtifacts.get(0).getName();
            } else {
                string2 = SESSION_LOADING;
            }
            return string2;
        }
        if (this.waitingForAgent) {
            string = SESSION_INITIALIZING;
        } else {
            long durationUs = TimeUnit.NANOSECONDS.toMicros(this.durationNs);
            String string4 = TimeFormatter.getMultiUnitDurationString((long)durationUs);
            Intrinsics.checkNotNull((Object)string4);
            string = string4;
        }
        return string;
    }

    @NotNull
    public final List<SessionArtifact<?>> getChildArtifacts() {
        return CollectionsKt.toList((Iterable)this.childArtifacts);
    }

    public final void setChildArtifacts(@NotNull List<? extends SessionArtifact<?>> artifacts) {
        Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
        this.childArtifacts.clear();
        this.childArtifacts.addAll((Collection)artifacts);
        this.changed(Aspect.MODEL);
    }

    public final boolean containsExactlyOneArtifact() {
        return this.childArtifacts.size() == 1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProfilerTaskType getTaskType() {
        void $this$filterTo$iv$iv;
        Map<ProfilerTaskType, ProfilerTaskHandler> map = this.getProfilers().getTaskHandlers();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getTaskHandlers(...)");
        Map<ProfilerTaskType, ProfilerTaskHandler> $this$filter$iv = map;
        boolean $i$f$filter = false;
        Map<ProfilerTaskType, ProfilerTaskHandler> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry2 = element$iv$iv = iterator.next();
            boolean bl = false;
            ProfilerTaskType taskType = (ProfilerTaskType)((Object)entry2.getKey());
            ProfilerTaskHandler taskHandler = (ProfilerTaskHandler)entry2.getValue();
            Intrinsics.checkNotNull((Object)taskHandler);
            if (!TaskSupportUtils.INSTANCE.isTaskSupportedByRecording(taskHandler, this)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Set supportedTaskTypes = destination$iv$iv.keySet();
        if (supportedTaskTypes.size() != 1) {
            return ProfilerTaskType.UNSPECIFIED;
        }
        ProfilerTaskType supportedTaskType = (ProfilerTaskType)((Object)CollectionsKt.single((Iterable)supportedTaskTypes));
        if (!SessionsManager.isSessionImported(this.getSession())) {
            Common.ProfilerTaskType profilerTaskType = this.getSessionMetaData().getTaskType();
            Intrinsics.checkNotNullExpressionValue((Object)profilerTaskType, (String)"getTaskType(...)");
            if (TaskTypeMappingUtils.convertTaskType(profilerTaskType) != supportedTaskType) {
                return ProfilerTaskType.UNSPECIFIED;
            }
        }
        Intrinsics.checkNotNull((Object)((Object)supportedTaskType));
        return supportedTaskType;
    }

    private static final void _init_$lambda$0(SessionItem this$0) {
        this$0.agentStatusChanged();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/profilers/sessions/SessionItem$Aspect;", "", "<init>", "(Ljava/lang/String;I)V", "MODEL", "intellij.android.profilers"})
    public static final class Aspect
    extends Enum<Aspect> {
        public static final /* enum */ Aspect MODEL = new Aspect();
        private static final /* synthetic */ Aspect[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Aspect[] values() {
            return (Aspect[])$VALUES.clone();
        }

        public static Aspect valueOf(String value) {
            return Enum.valueOf(Aspect.class, value);
        }

        @NotNull
        public static EnumEntries<Aspect> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = aspectArray = new Aspect[]{Aspect.MODEL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/profilers/sessions/SessionItem$Companion;", "", "<init>", "()V", "SESSION_INITIALIZING", "", "SESSION_LOADING", "getSESSION_LOADING$annotations", "parseName", "metaData", "Lcom/android/tools/profiler/proto/Common$SessionMetaData;", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getSESSION_LOADING$annotations() {
        }

        private final String parseName(Common.SessionMetaData metaData) {
            Regex nameRegex = new Regex("(?<package>.+) \\((?<device>.+)\\)");
            if (metaData.getType() != Common.SessionMetaData.SessionType.FULL) {
                String string = metaData.getSessionName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSessionName(...)");
                return string;
            }
            String string = metaData.getSessionName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSessionName(...)");
            MatchResult match = nameRegex.matchEntire((CharSequence)string);
            if (match != null) {
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"package");
                Intrinsics.checkNotNull((Object)matchGroup);
                char[] cArray = new char[]{'.'};
                String appName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)matchGroup.getValue(), (char[])cArray, (boolean)false, (int)0, (int)6, null));
                MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"device");
                Intrinsics.checkNotNull((Object)matchGroup2);
                String deviceName = matchGroup2.getValue();
                return appName + " (" + deviceName + ")";
            }
            String string2 = metaData.getSessionName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSessionName(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

