/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.instanceviewers;

import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.memory.adapters.AndroidBitmapDataProvider;
import com.android.tools.profilers.memory.adapters.BitmapDecoder;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.instanceviewers.InstanceViewer;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitmapViewer
implements InstanceViewer {
    @Override
    @NotNull
    public String getTitle() {
        return "Bitmap Preview";
    }

    @Override
    @Nullable
    public JComponent createComponent(@NotNull IdeProfilerComponents ideProfilerComponents, @NotNull CaptureObject captureObject, @NotNull InstanceObject instanceObject) {
        InstanceObject bitmapInstance = AndroidBitmapDataProvider.getBitmapClassInstance(instanceObject);
        if (bitmapInstance == null) {
            return null;
        }
        AndroidBitmapDataProvider bitmapDataProvider = AndroidBitmapDataProvider.createDecoder(bitmapInstance);
        if (bitmapDataProvider == null) {
            if (bitmapInstance.getDepth() != Integer.MAX_VALUE) {
                return null;
            }
            JLabel viewer = new JLabel("This bitmap can't be previewed because its data isn't currently connected to any active part of the program. It will be automatically cleaned up by the garbage collector.");
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(JBUI.Borders.empty((int)8));
            panel.setName("Bitmap Preview");
            panel.add(viewer);
            return new JBScrollPane((Component)panel);
        }
        BufferedImage image = BitmapDecoder.getBitmap(bitmapDataProvider);
        if (image == null) {
            return null;
        }
        JComponent viewer = ideProfilerComponents.createResizableImageComponent(image);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setName("Bitmap Preview");
        panel.add((Component)viewer, "Center");
        return new JBScrollPane((Component)panel, 20, 30);
    }
}

