/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.chart;

import com.android.tools.adtui.model.HNode;
import com.android.tools.profilers.memory.adapters.classifiers.ClassifierSet;
import com.android.tools.profilers.memory.chart.MemoryVisualizationModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0000H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u0000H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\u0000H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00000\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/android/tools/profilers/memory/chart/ClassifierSetHNode;", "Lcom/android/tools/adtui/model/HNode;", "callChartModel", "Lcom/android/tools/profilers/memory/chart/MemoryVisualizationModel;", "data", "Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet;", "depth", "", "<init>", "(Lcom/android/tools/profilers/memory/chart/MemoryVisualizationModel;Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet;I)V", "getData", "()Lcom/android/tools/profilers/memory/adapters/classifiers/ClassifierSet;", "children", "", "kotlin.jvm.PlatformType", "startOffset", "", "updateChildrenOffsets", "", "computeDuration", "getChildCount", "getChildAt", "index", "getParent", "getStart", "getEnd", "getDepth", "getDuration", "isMatched", "", "()Z", "isFiltered", "getFirstChild", "getLastChild", "name", "", "getName", "()Ljava/lang/String;", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nClassifierSetHNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassifierSetHNode.kt\ncom/android/tools/profilers/memory/chart/ClassifierSetHNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1563#2:111\n1634#2,3:112\n*S KotlinDebug\n*F\n+ 1 ClassifierSetHNode.kt\ncom/android/tools/profilers/memory/chart/ClassifierSetHNode\n*L\n34#1:111\n34#1:112,3\n*E\n"})
public final class ClassifierSetHNode
implements HNode<ClassifierSetHNode> {
    @NotNull
    private final MemoryVisualizationModel callChartModel;
    @NotNull
    private final ClassifierSet data;
    private final int depth;
    @NotNull
    private final List<ClassifierSetHNode> children;
    private long startOffset;

    /*
     * WARNING - void declaration
     */
    public ClassifierSetHNode(@NotNull MemoryVisualizationModel callChartModel, @NotNull ClassifierSet data, int depth) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)callChartModel, (String)"callChartModel");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.callChartModel = callChartModel;
        this.data = data;
        this.depth = depth;
        Iterable iterable = this.data.getChildrenClassifierSets();
        ClassifierSetHNode classifierSetHNode = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassifierSet classifierSet = (ClassifierSet)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ClassifierSetHNode(this.callChartModel, (ClassifierSet)it, this.depth + 1));
        }
        Iterable iterable2 = (List)destination$iv$iv;
        Comparator<Object> comparator = Comparator.comparingLong(arg_0 -> ClassifierSetHNode.children$lambda$2(ClassifierSetHNode::children$lambda$1, arg_0)).reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reversed(...)");
        classifierSetHNode.children = CollectionsKt.toList((Iterable)CollectionsKt.toSortedSet((Iterable)iterable2, comparator));
    }

    @NotNull
    public final ClassifierSet getData() {
        return this.data;
    }

    public final void updateChildrenOffsets() {
        long childOffset = this.startOffset;
        for (ClassifierSetHNode child : this.children) {
            child.startOffset = childOffset;
            childOffset += child.getDuration();
            child.updateChildrenOffsets();
        }
    }

    private final long computeDuration(ClassifierSet data) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.callChartModel.getAxisFilter().ordinal()]) {
            case 1 -> data.getTotalObjectCount();
            case 2 -> data.getTotalShallowSize();
            case 3 -> data.getAllocationSize();
            case 4 -> data.getDeltaAllocationCount();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public int getChildCount() {
        return this.children.size();
    }

    @NotNull
    public ClassifierSetHNode getChildAt(int index) {
        ClassifierSetHNode classifierSetHNode = this.children.get(index);
        Intrinsics.checkNotNullExpressionValue((Object)classifierSetHNode, (String)"get(...)");
        return classifierSetHNode;
    }

    @Nullable
    public ClassifierSetHNode getParent() {
        return null;
    }

    public long getStart() {
        return this.startOffset;
    }

    public long getEnd() {
        return this.getStart() + this.computeDuration(this.data);
    }

    public int getDepth() {
        return this.depth;
    }

    public long getDuration() {
        return this.computeDuration(this.data);
    }

    public final boolean isMatched() {
        return this.data.isMatched();
    }

    public final boolean isFiltered() {
        return this.data.isFiltered();
    }

    @Nullable
    public ClassifierSetHNode getFirstChild() {
        return (ClassifierSetHNode)CollectionsKt.first(this.children);
    }

    @Nullable
    public ClassifierSetHNode getLastChild() {
        return (ClassifierSetHNode)CollectionsKt.last(this.children);
    }

    @NotNull
    public final String getName() {
        return this.data.getName();
    }

    private static final long children$lambda$1(ClassifierSetHNode obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getDuration();
    }

    private static final long children$lambda$2(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MemoryVisualizationModel.XAxisFilter.values().length];
            try {
                nArray[MemoryVisualizationModel.XAxisFilter.TOTAL_COUNT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MemoryVisualizationModel.XAxisFilter.TOTAL_SIZE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MemoryVisualizationModel.XAxisFilter.ALLOC_SIZE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MemoryVisualizationModel.XAxisFilter.ALLOC_COUNT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

