/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Type;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.HeapDumpCaptureObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HeapDumpFieldObject
implements FieldObject {
    private static final Map<Type, ValueObject.ValueType> ourPrimitiveValueTypeMap = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)ValueObject.ValueType.BOOLEAN).put((Object)Type.BYTE, (Object)ValueObject.ValueType.BYTE).put((Object)Type.CHAR, (Object)ValueObject.ValueType.CHAR).put((Object)Type.SHORT, (Object)ValueObject.ValueType.SHORT).put((Object)Type.INT, (Object)ValueObject.ValueType.INT).put((Object)Type.LONG, (Object)ValueObject.ValueType.LONG).put((Object)Type.FLOAT, (Object)ValueObject.ValueType.FLOAT).put((Object)Type.DOUBLE, (Object)ValueObject.ValueType.DOUBLE).build();
    @NotNull
    private final ClassInstance.FieldValue myField;
    @NotNull
    private final ValueObject.ValueType myValueType;
    @Nullable
    private final InstanceObject myInstanceObject;
    private final int myDepth;
    private final long myNativeSize;
    private final int myShallowSize;
    private final long myRetainedSize;
    private final int myHashCode;

    public HeapDumpFieldObject(@NotNull HeapDumpCaptureObject captureObject, @NotNull Instance parentInstance, @NotNull ClassInstance.FieldValue field) {
        this.myField = field;
        Type type = this.myField.getField().getType();
        if (type == Type.OBJECT) {
            Instance instance = (Instance)this.myField.getValue();
            if (instance == null || this.myField.getValue() == null) {
                this.myValueType = ValueObject.ValueType.NULL;
                this.myInstanceObject = null;
                this.myNativeSize = 0L;
                this.myShallowSize = 0;
                this.myRetainedSize = 0L;
                this.myDepth = Integer.MAX_VALUE;
            } else {
                this.myInstanceObject = captureObject.getOrCreateInstanceObject(instance);
                this.myValueType = instance instanceof ClassObj ? ValueObject.ValueType.CLASS : (instance instanceof ArrayInstance ? ValueObject.ValueType.ARRAY : (instance instanceof ClassInstance && instance.getClassObj().getClassName().equals("java.lang.String") ? ValueObject.ValueType.STRING : ValueObject.ValueType.OBJECT));
                this.myNativeSize = instance.getNativeSize();
                this.myShallowSize = instance.getSize();
                this.myRetainedSize = instance.getTotalRetainedSize();
                this.myDepth = instance.getDistanceToGcRoot();
            }
        } else {
            this.myValueType = ourPrimitiveValueTypeMap.getOrDefault(type, ValueObject.ValueType.NULL);
            this.myInstanceObject = null;
            this.myNativeSize = 0L;
            this.myShallowSize = type.getSize();
            this.myRetainedSize = type.getSize();
            this.myDepth = parentInstance.getDistanceToGcRoot();
        }
        this.myHashCode = Arrays.hashCode(new Object[]{this.myInstanceObject, this.getFieldName(), this.getValueType(), this.myField.getValue()});
    }

    public int hashCode() {
        return this.myHashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HeapDumpFieldObject)) {
            return false;
        }
        HeapDumpFieldObject other = (HeapDumpFieldObject)obj;
        return other.myInstanceObject == this.myInstanceObject && this.getFieldName().equals(other.getFieldName()) && this.getValueType() == other.getValueType() && (this.getAsInstance() == other.getAsInstance() || Objects.equals(this.myField.getValue(), other.myField.getValue()));
    }

    @Override
    @NotNull
    public String getName() {
        return this.getFieldName();
    }

    @Override
    public long getNativeSize() {
        return this.myNativeSize;
    }

    @Override
    public int getShallowSize() {
        return this.myShallowSize;
    }

    @Override
    public long getRetainedSize() {
        return this.myRetainedSize;
    }

    @Override
    public int getDepth() {
        return this.myDepth;
    }

    @Override
    @NotNull
    public String getFieldName() {
        return this.myField.getField().getName();
    }

    @Override
    @Nullable
    public InstanceObject getAsInstance() {
        return this.myInstanceObject;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.myInstanceObject != null ? this.myInstanceObject : this.myField.getValue();
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        return this.myValueType;
    }

    @Override
    @NotNull
    public String getValueText() {
        if (this.getValueType().getIsPrimitive()) {
            return "";
        }
        if (this.getValueType() == ValueObject.ValueType.NULL || this.myField.getValue() == null || this.myInstanceObject == null) {
            return "null";
        }
        return String.format("{%s}", this.myInstanceObject.getClassEntry().getSimpleClassName());
    }

    @Override
    @NotNull
    public String getToStringText() {
        if (this.getValueType() == ValueObject.ValueType.NULL || this.myField.getValue() == null) {
            return "";
        }
        if (this.getValueType().getIsPrimitive()) {
            return this.myField.getValue().toString();
        }
        return this.myInstanceObject == null ? "" : this.myInstanceObject.getToStringText();
    }
}

