/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.RangeSelectionComponent;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.adtui.stdui.ContextMenuItem;
import com.android.tools.adtui.stdui.DefaultContextMenuItem;
import com.android.tools.inspectors.common.ui.ContextMenuInstaller;
import com.android.tools.profilers.DismissibleMessage;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.RecordingOptionsView;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.SupportLevel;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStageView;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CapturePanel;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.GarbageCollectionComponent;
import com.android.tools.profilers.memory.MainMemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryCaptureView;
import com.android.tools.profilers.memory.MemoryClassGrouping;
import com.android.tools.profilers.memory.MemoryClassSetView;
import com.android.tools.profilers.memory.MemoryClassifierView;
import com.android.tools.profilers.memory.MemoryHeapView;
import com.android.tools.profilers.memory.MemoryInstanceDetailsView;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStageLayout;
import com.android.tools.profilers.memory.MemoryTimelineComponent;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Splitter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainMemoryProfilerStageView
extends BaseStreamingMemoryProfilerStageView<MainMemoryProfilerStage> {
    private static final String SHOW_PROFILEABLE_MESSAGE = "profileable.memory.message";
    private final MemoryProfilerStageLayout myLayout;
    @Nullable
    private final MemoryTimelineComponent myTimelineComponent;
    @Nullable
    private CaptureObject myCaptureObject = null;
    @NotNull
    private final JButton myForceGarbageCollectionButton;
    @NotNull
    private final DefaultContextMenuItem myForceGarbageCollectionAction;
    @NotNull
    private final RecordingOptionsView myRecordingOptionsView;
    @NotNull
    private final LoadingPanel myHeapDumpLoadingPanel;
    @NotNull
    private final GarbageCollectionComponent myGarbageCollectionComponent;

    private static Logger getLogger() {
        return Logger.getInstance(MainMemoryProfilerStageView.class);
    }

    public MainMemoryProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull MainMemoryProfilerStage stage) {
        super(profilersView, stage);
        this.myTimelineComponent = ((MainMemoryProfilerStage)this.getStage()).isMemoryCaptureOnly() ? null : new MemoryTimelineComponent(this, this.buildTimeAxis(profilersView.getStudioProfilers()));
        this.myGarbageCollectionComponent = new GarbageCollectionComponent();
        CapturePanel capturePanel = new CapturePanel(this.getProfilersView(), ((MainMemoryProfilerStage)this.getStage()).getCaptureSelection(), ((MainMemoryProfilerStage)this.getStage()).isMemoryCaptureOnly() ? null : this.getSelectionTimeLabel(), ((MainMemoryProfilerStage)this.getStage()).getRangeSelectionModel().getSelectionRange(), this.getIdeComponents(), ((MainMemoryProfilerStage)this.getStage()).getTimeline(), false);
        this.myRecordingOptionsView = new RecordingOptionsView(stage.getRecordingOptionsModel());
        this.myLayout = new MemoryProfilerStageLayout((JComponent)((Object)this.myTimelineComponent), capturePanel, this.myRecordingOptionsView, (Function0<? extends LoadingPanel>)((Function0)this::makeLoadingPanel));
        this.getComponent().add((Component)this.myLayout.getComponent(), "Center");
        this.myHeapDumpLoadingPanel = this.getIdeComponents().createLoadingPanel(-1);
        this.myHeapDumpLoadingPanel.setLoadingText("Capturing heap dump");
        this.myForceGarbageCollectionButton = this.myGarbageCollectionComponent.makeGarbageCollectionButton(stage.getMemoryDataProvider(), profilersView.getStudioProfilers());
        this.myForceGarbageCollectionAction = this.myGarbageCollectionComponent.makeGarbageCollectionAction(stage.getStudioProfilers(), this.myForceGarbageCollectionButton, this.getComponent());
        this.myForceGarbageCollectionButton.setToolTipText(this.myForceGarbageCollectionAction.getDefaultToolTipText());
        ((MainMemoryProfilerStage)this.getStage()).getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.TRACKING_ENABLED, this::allocationTrackingChanged).onChange((Enum)MemoryProfilerAspect.HEAP_DUMP_STARTED, this::showHeapDumpInProgress).onChange((Enum)MemoryProfilerAspect.HEAP_DUMP_FINISHED, this::hideHeapDumpInProgress);
        ((MainMemoryProfilerStage)this.getStage()).getCaptureSelection().getAspect().addDependency((AspectObserver)this).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADING_CAPTURE, this::captureObjectChanged).onChange((Enum)CaptureSelectionAspect.CURRENT_LOADED_CAPTURE, this::captureObjectFinishedLoading).onChange((Enum)CaptureSelectionAspect.CURRENT_CAPTURE_ELAPSED_TIME, this::updateCaptureElapsedTime);
        Runnable onSessionChanged = () -> {
            this.myRecordingOptionsView.setEnabled(((MainMemoryProfilerStage)this.getStage()).getStudioProfilers().getSessionsManager().isSessionAlive());
            this.updateGcButton();
        };
        ((MainMemoryProfilerStage)this.getStage()).getStudioProfilers().getSessionsManager().addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, onSessionChanged);
        this.captureObjectChanged();
        this.allocationTrackingChanged();
        this.buildContextMenu();
        onSessionChanged.run();
    }

    @Override
    public boolean isToolbarVisible() {
        return !((MainMemoryProfilerStage)this.getStage()).isMemoryCaptureOnly();
    }

    @VisibleForTesting
    MemoryProfilerStageLayout getLayout() {
        return this.myLayout;
    }

    @VisibleForTesting
    JButton getGarbageCollectionButtion() {
        return this.myForceGarbageCollectionButton;
    }

    @VisibleForTesting
    @NotNull
    RecordingOptionsView getRecordingOptionsView() {
        return this.myRecordingOptionsView;
    }

    @VisibleForTesting
    @Nullable
    MemoryTimelineComponent getTimelineComponent() {
        return this.myTimelineComponent;
    }

    @Override
    public JComponent getToolbar() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel toolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        panel.add((Component)toolbar, "West");
        toolbar.removeAll();
        toolbar.add(this.myForceGarbageCollectionButton);
        this.updateGcButton();
        if (((MainMemoryProfilerStage)this.getStage()).isLiveAllocationTrackingSupported()) {
            if (((MainMemoryProfilerStage)this.getStage()).isNativeAllocationSamplingEnabled()) {
                toolbar.add((Component)this.getCaptureElapsedTimeLabel());
            }
        } else {
            toolbar.add((Component)this.getCaptureElapsedTimeLabel());
        }
        if (((MainMemoryProfilerStage)this.getStage()).getStudioProfilers().getSelectedSessionSupportLevel() == SupportLevel.PROFILEABLE) {
            panel.add(DismissibleMessage.of(((MainMemoryProfilerStage)this.getStage()).getStudioProfilers(), SHOW_PROFILEABLE_MESSAGE, "Some features are disabled for profileable processes.", "https://d.android.com/r/studio-ui/profiler/profileable"));
        }
        return panel;
    }

    @VisibleForTesting
    @NotNull
    public Splitter getMainSplitter() {
        return this.myLayout.getMainSplitter();
    }

    @VisibleForTesting
    @NotNull
    public Splitter getChartCaptureSplitter() {
        return this.myLayout.getChartCaptureSplitter();
    }

    @VisibleForTesting
    @NotNull
    public JPanel getCapturePanel() {
        return this.myLayout.getCapturePanel().getComponent();
    }

    @VisibleForTesting
    @NotNull
    MemoryCaptureView getCaptureView() {
        return this.myLayout.getCapturePanel().getCaptureView();
    }

    @VisibleForTesting
    @NotNull
    MemoryHeapView getHeapView() {
        return this.myLayout.getCapturePanel().getHeapView();
    }

    @VisibleForTesting
    @NotNull
    MemoryClassGrouping getClassGrouping() {
        return this.myLayout.getCapturePanel().getClassGrouping();
    }

    @VisibleForTesting
    @NotNull
    MemoryClassifierView getClassifierView() {
        return this.myLayout.getCapturePanel().getClassifierView();
    }

    @VisibleForTesting
    @NotNull
    MemoryClassSetView getClassSetView() {
        return this.myLayout.getCapturePanel().getClassSetView();
    }

    @VisibleForTesting
    @NotNull
    MemoryInstanceDetailsView getInstanceDetailsView() {
        return this.myLayout.getCapturePanel().getInstanceDetailsView();
    }

    @VisibleForTesting
    @NotNull
    JLabel getCaptureInfoMessage() {
        return this.myLayout.getCapturePanel().getCaptureInfoMessage();
    }

    private boolean isSelectedSessionDeviceX86OrX64() {
        String abi = ((MainMemoryProfilerStage)this.getStage()).getStudioProfilers().getSessionsManager().getSelectedSessionMetaData().getProcessAbi();
        return abi.equalsIgnoreCase("x86") || abi.equalsIgnoreCase("x86_64");
    }

    private void allocationTrackingChanged() {
        this.getCaptureElapsedTimeLabel().setText(((MainMemoryProfilerStage)this.getStage()).isTrackingAllocations() ? TimeFormatter.getSemiSimplifiedClockString((long)0L) : "");
    }

    private void updateCaptureElapsedTime() {
        if (((MainMemoryProfilerStage)this.getStage()).isTrackingAllocations() && (!((MainMemoryProfilerStage)this.getStage()).isLiveAllocationTrackingReady() || ((MainMemoryProfilerStage)this.getStage()).isNativeAllocationSamplingEnabled())) {
            long elapsedTimeUs = TimeUnit.NANOSECONDS.toMicros(((MainMemoryProfilerStage)this.getStage()).getAllocationTrackingElapsedTimeNs());
            this.getCaptureElapsedTimeLabel().setText(TimeFormatter.getSemiSimplifiedClockString((long)elapsedTimeUs));
        }
    }

    private void buildContextMenu() {
        if (this.myTimelineComponent == null) {
            return;
        }
        RangeSelectionComponent rangeSelectionComponent = this.myTimelineComponent.getRangeSelectionComponent();
        IdeProfilerComponents ideProfilerComponents = this.getIdeComponents();
        ContextMenuInstaller contextMenuInstaller = ideProfilerComponents.createContextMenuInstaller();
        DefaultContextMenuItem exportHeapDumpAction = new DefaultContextMenuItem.Builder("Export...").setIcon(AllIcons.ToolbarDecorator.Export).build();
        contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, (ContextMenuItem)exportHeapDumpAction, x -> this.getCaptureIntersectingWithMouseX(x) != null && this.getCaptureIntersectingWithMouseX(x).isExportable(), x -> this.getIdeComponents().createExportDialog().open(() -> "Export capture to file", () -> MemoryProfiler.generateCaptureFileName(), () -> this.getCaptureIntersectingWithMouseX(x).getExportableExtension(), file -> ((MainMemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().saveFile((File)file, output -> {
            try {
                this.getCaptureIntersectingWithMouseX(x).saveToFile((OutputStream)output);
            }
            catch (IOException e) {
                MainMemoryProfilerStageView.getLogger().warn((Throwable)e);
            }
        }, null)));
        contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, ContextMenuItem.SEPARATOR);
        contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, (ContextMenuItem)this.myForceGarbageCollectionAction);
        contextMenuInstaller.installGenericContextMenu((JComponent)rangeSelectionComponent, ContextMenuItem.SEPARATOR);
        this.getProfilersView().installCommonMenuItems((JComponent)rangeSelectionComponent);
    }

    @Nullable
    private CaptureObject getCaptureIntersectingWithMouseX(int mouseXLocation) {
        assert (this.myTimelineComponent != null);
        Range range = ((MainMemoryProfilerStage)this.getStage()).getTimeline().getViewRange();
        double pos = (double)mouseXLocation / this.myTimelineComponent.getRangeSelectionComponent().getSize().getWidth() * range.getLength() + range.getMin();
        CaptureDurationData<? extends CaptureObject> durationData = ((MainMemoryProfilerStage)this.getStage()).getIntersectingCaptureDuration(new Range(pos, pos));
        return durationData == null ? null : durationData.getCaptureEntry().getCaptureObject();
    }

    private void captureObjectChanged() {
        this.stopLoadingUi();
        this.myCaptureObject = ((MainMemoryProfilerStage)this.getStage()).getCaptureSelection().getSelectedCapture();
        if (this.myCaptureObject == null) {
            this.myLayout.setShowingCaptureUi(false);
            return;
        }
        if (this.myCaptureObject.isDoneLoading()) {
            this.captureObjectFinishedLoading();
        } else {
            this.myLayout.setLoadingUiVisible(true);
        }
    }

    private void captureObjectFinishedLoading() {
        if (this.myTimelineComponent != null) {
            this.myTimelineComponent.getRangeSelectionComponent().requestFocus();
        }
        if (this.myCaptureObject != ((MainMemoryProfilerStage)this.getStage()).getCaptureSelection().getSelectedCapture() || this.myCaptureObject == null) {
            return;
        }
        this.myLayout.setShowingCaptureUi(true);
    }

    private void stopLoadingUi() {
        if (this.myCaptureObject != null && this.myLayout.isLoadingUiVisible()) {
            this.myLayout.setLoadingUiVisible(false);
        }
    }

    private void showHeapDumpInProgress() {
        this.getComponent().removeAll();
        this.myHeapDumpLoadingPanel.setChildComponent((Component)this.myLayout.getComponent());
        this.getComponent().add((Component)this.myHeapDumpLoadingPanel.getComponent(), "Center");
        this.myHeapDumpLoadingPanel.startLoading();
    }

    private void hideHeapDumpInProgress() {
        this.myHeapDumpLoadingPanel.stopLoading();
        this.getComponent().removeAll();
        this.myHeapDumpLoadingPanel.setChildComponent(null);
        this.getComponent().add((Component)this.myLayout.getComponent());
    }

    private void updateGcButton() {
        this.myGarbageCollectionComponent.updateGcButton(((MainMemoryProfilerStage)this.getStage()).getStudioProfilers(), this.myForceGarbageCollectionButton);
    }
}

