/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.idea.io.grpc.StatusRuntimeException;
import com.android.tools.idea.transport.TransportFileManager;
import com.android.tools.idea.transport.poller.TransportEventListener;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.InterimStage;
import com.android.tools.profilers.LogUtils;
import com.android.tools.profilers.RecordingOption;
import com.android.tools.profilers.RecordingOptionsModel;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.SupportLevel;
import com.android.tools.profilers.memory.AllocationDurationData;
import com.android.tools.profilers.memory.AllocationStage;
import com.android.tools.profilers.memory.BaseStreamingMemoryProfilerStage;
import com.android.tools.profilers.memory.CaptureDataSeries;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureObjectLoader;
import com.android.tools.profilers.memory.MemoryCaptureStage;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.HeapDumpCaptureObject;
import com.android.tools.profilers.memory.adapters.LegacyAllocationCaptureObject;
import com.android.tools.profilers.memory.adapters.NativeAllocationSampleCaptureObject;
import com.android.tools.profilers.perfetto.config.PerfettoTraceConfigBuilders;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.taskbased.task.interim.RecordingScreenModel;
import com.android.tools.profilers.tasks.TaskEventTrackerUtils;
import com.android.tools.profilers.tasks.TaskStartFailedMetadata;
import com.android.tools.profilers.tasks.TaskStopFailedMetadata;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import perfetto.protos.PerfettoConfig;

public class MainMemoryProfilerStage
extends BaseStreamingMemoryProfilerStage
implements InterimStage {
    private static final String HEAP_DUMP_TOOLTIP = "View objects in your app that are using memory at a specific point in time";
    private static final String CAPTURE_HEAP_DUMP_TEXT = "Capture heap dump";
    private static final String RECORD_JAVA_TEXT = "Record Java / Kotlin allocations";
    private static final String RECORD_JAVA_TOOLTIP = "View how each Java / Kotlin object was allocated over a period of time";
    @VisibleForTesting
    static final String RECORD_NATIVE_TEXT = "Record native allocations";
    private static final String RECORD_NATIVE_DESC = "View how each C / C++ object was allocated over a period of time";
    public static final int MEMORY_HPROF_SAFE_FACTOR = Math.max(1, Math.min(Integer.getInteger("profiler.memory.hprof.safeFactor", 10), 1000));
    private final boolean myIsMemoryCaptureOnly;
    private final DurationDataModel<CaptureDurationData<? extends CaptureObject>> myHeapDumpDurations;
    private final DurationDataModel<CaptureDurationData<? extends CaptureObject>> myAllocationDurations;
    private final DurationDataModel<CaptureDurationData<? extends CaptureObject>> myNativeAllocationDurations;
    private long myPendingLegacyAllocationStartTimeNs = -1L;
    @VisibleForTesting
    boolean myNativeAllocationTracking = false;
    private final RecordingOptionsModel myRecordingOptionsModel;
    @NotNull
    private final Runnable myStopAction;
    @Nullable
    private final RecordingScreenModel<MainMemoryProfilerStage> myRecordingScreenModel;
    @VisibleForTesting
    public Lazy<RecordingOption> lazyHeapDumpRecordingOption = LazyKt.lazyOf((Object)new RecordingOption("Capture heap dump", "View objects in your app that are using memory at a specific point in time", () -> {
        this.requestHeapDump();
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackDumpHeap();
    }));
    @VisibleForTesting
    public Lazy<RecordingOption> lazyNativeRecordingOption = LazyKt.lazyOf((Object)MainMemoryProfilerStage.makeToggleOption("Record native allocations", "View how each C / C++ object was allocated over a period of time", this::toggleNativeAllocationTracking));
    @VisibleForTesting
    public Lazy<RecordingOption> lazyJavaKotlinAllocationsRecordingOption = LazyKt.lazyOf((Object)MainMemoryProfilerStage.makeToggleOption("Record Java / Kotlin allocations", "View how each Java / Kotlin object was allocated over a period of time", this.isLiveAllocationTrackingSupported() ? () -> this.getStudioProfilers().setStage(AllocationStage.makeLiveStage(this.getStudioProfilers(), this.getStopAction())) : () -> {
        if (this.isTrackingAllocations()) {
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackRecordAllocations();
        }
        this.trackAllocations(!this.isTrackingAllocations());
    }));

    public MainMemoryProfilerStage(@NotNull StudioProfilers profilers) {
        this(profilers, new CaptureObjectLoader(), () -> {});
    }

    public MainMemoryProfilerStage(@NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader) {
        this(profilers, loader, () -> {});
    }

    public MainMemoryProfilerStage(@NotNull StudioProfilers profilers, @NotNull Runnable stopAction) {
        this(profilers, new CaptureObjectLoader(), stopAction);
    }

    public MainMemoryProfilerStage(@NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader, @NotNull Runnable stopAction) {
        super(profilers, loader);
        this.myIsMemoryCaptureOnly = profilers.getSessionsManager().getSelectedSessionMetaData().getType() == Common.SessionMetaData.SessionType.MEMORY_CAPTURE;
        this.myHeapDumpDurations = this.makeModel(CaptureDataSeries::ofHeapDumpSamples);
        this.myAllocationDurations = this.isLiveAllocationTrackingSupported() ? this.makeModel(CaptureDataSeries::ofAllocationInfos) : this.makeModel(CaptureDataSeries::ofLegacyAllocationInfos);
        this.myNativeAllocationDurations = this.makeModel(CaptureDataSeries::ofNativeAllocationSamples);
        this.myHeapDumpDurations.setRenderSeriesPredicate((data, series) -> !series.getName().equals(this.getDetailedMemoryUsage().getObjectsSeries().getName()));
        this.getRangeSelectionModel().addConstraint(this.myAllocationDurations);
        this.getRangeSelectionModel().addConstraint(this.myNativeAllocationDurations);
        this.getRangeSelectionModel().addConstraint(this.myHeapDumpDurations);
        this.getStudioProfilers().getSessionsManager().addDependency(this).onChange((Enum)SessionAspect.SELECTED_SESSION, this::stopRecordingOnSessionStop);
        this.myRecordingOptionsModel = new RecordingOptionsModel();
        this.myStopAction = stopAction;
        this.myRecordingScreenModel = this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled() ? new RecordingScreenModel<MainMemoryProfilerStage>(this) : null;
    }

    public RecordingOptionsModel getRecordingOptionsModel() {
        return this.myRecordingOptionsModel;
    }

    void stopRecordingOnSessionStop() {
        boolean isAlive = this.getStudioProfilers().getSessionsManager().isSessionAlive();
        if (!isAlive && this.myNativeAllocationTracking) {
            this.toggleNativeAllocationTracking();
        }
    }

    public boolean hasUserUsedMemoryCapture() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean("memory.used.capture", false);
    }

    @Override
    public void enter() {
        this.logEnterStage();
        super.enter();
        BiConsumer<SupportLevel.Feature, RecordingOption> adder = (feature, option) -> {
            this.myRecordingOptionsModel.addBuiltInOptions((RecordingOption)option);
            if (!this.getStudioProfilers().getSelectedSessionSupportLevel().isFeatureSupported((SupportLevel.Feature)((Object)feature))) {
                this.myRecordingOptionsModel.setOptionNotReady((RecordingOption)option, feature.getTitle() + " is not supported for profileable processes");
            }
        };
        adder.accept(SupportLevel.Feature.MEMORY_HEAP_DUMP, (RecordingOption)this.lazyHeapDumpRecordingOption.getValue());
        if (this.isNativeAllocationSamplingEnabled()) {
            adder.accept(SupportLevel.Feature.MEMORY_NATIVE_RECORDING, (RecordingOption)this.lazyNativeRecordingOption.getValue());
        }
        adder.accept(SupportLevel.Feature.MEMORY_JVM_RECORDING, (RecordingOption)this.lazyJavaKotlinAllocationsRecordingOption.getValue());
        this.updateAllocationTrackingStatus();
        this.updateNativeAllocationTrackingStatus();
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled() && this.myRecordingScreenModel != null) {
            this.getStudioProfilers().getUpdater().register(this.myRecordingScreenModel);
        }
    }

    @Override
    public void exit() {
        super.exit();
        this.enableSelectLatestCapture(false, null);
        this.selectCaptureDuration(null, null);
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled() && this.myRecordingScreenModel != null) {
            this.getStudioProfilers().getUpdater().unregister(this.myRecordingScreenModel);
        }
    }

    @Override
    @NotNull
    public List<DurationDataModel<CaptureDurationData<? extends CaptureObject>>> getCaptureSeries() {
        return Arrays.asList(this.myAllocationDurations, this.myHeapDumpDurations, this.myNativeAllocationDurations);
    }

    @Override
    protected void selectCaptureFromSelectionRange() {
        if (!this.getUpdateCaptureOnSelection()) {
            return;
        }
        this.setUpdateCaptureOnSelection(false);
        Range selectionRange = this.getTimeline().getSelectionRange();
        this.selectCaptureDuration(this.getIntersectingCaptureDuration(selectionRange), SwingUtilities::invokeLater);
        this.setUpdateCaptureOnSelection(true);
    }

    public boolean isMemoryCaptureOnly() {
        return this.myIsMemoryCaptureOnly;
    }

    @Override
    protected void onCaptureToSelect(SeriesData<CaptureDurationData<? extends CaptureObject>> captureToSelect, @NotNull Executor loadJoiner) {
        long x = captureToSelect.x;
        if (this.getHeapDumpSampleDurations().getSeries().getSeriesForRange(this.getTimeline().getDataRange()).stream().anyMatch(s -> s.x == x)) {
            this.getAspect().changed((Enum)MemoryProfilerAspect.HEAP_DUMP_FINISHED);
            LogUtils.log(this.getClass(), "Heap dump capture has finished");
        }
        this.selectCaptureDuration((CaptureDurationData)((Object)captureToSelect.value), loadJoiner);
    }

    public void setPendingCaptureStartTimeGuarded(long pendingCaptureStartTime) {
        assert (this.myIsMemoryCaptureOnly);
        super.setPendingCaptureStartTime(pendingCaptureStartTime);
    }

    public void startHeapDumpCapture() {
        this.startMemoryRecording((RecordingOption)this.lazyHeapDumpRecordingOption.getValue());
    }

    public void startNativeAllocationCapture() {
        this.startMemoryRecording((RecordingOption)this.lazyNativeRecordingOption.getValue());
    }

    public void startJavaKotlinAllocationCapture() {
        this.startMemoryRecording((RecordingOption)this.lazyJavaKotlinAllocationsRecordingOption.getValue());
    }

    private void startMemoryRecording(RecordingOption recordingOption) {
        this.getRecordingOptionsModel().selectBuiltInOption(recordingOption);
        this.getRecordingOptionsModel().start();
    }

    public void stopMemoryRecording() {
        this.getRecordingOptionsModel().stop();
    }

    private void startNativeAllocationTracking() {
        IdeProfilerServices ide = this.getStudioProfilers().getIdeServices();
        ide.getFeatureTracker().trackRecordAllocations();
        Common.Process process = this.getStudioProfilers().getProcess();
        String traceFilePath = String.format(Locale.getDefault(), "%s/%s.trace", "/data/local/tmp/perfd", process.getName());
        Trace.TraceConfiguration configuration = Trace.TraceConfiguration.newBuilder().setAbiCpuArch(TransportFileManager.getShortAbiName((String)this.getStudioProfilers().getDevice().getCpuAbi())).setTempPath(traceFilePath).setAppName(process.getName()).setPerfettoOptions(PerfettoTraceConfigBuilders.INSTANCE.getMemoryTraceConfig(process.getName(), ide.getNativeAllocationsMemorySamplingRate())).build();
        Commands.Command dumpCommand = Commands.Command.newBuilder().setStreamId(this.getSessionData().getStreamId()).setPid(this.getSessionData().getPid()).setType(Commands.Command.CommandType.START_TRACE).setStartTrace(Trace.StartTrace.newBuilder().setProfilerType(Trace.ProfilerType.MEMORY).setConfiguration(configuration)).build();
        this.getStudioProfilers().getClient().executeAsync(dumpCommand, ide.getPoolExecutor()).thenAcceptAsync(response -> {
            TransportEventListener statusListener = new TransportEventListener(Common.Event.Kind.TRACE_STATUS, this.getStudioProfilers().getIdeServices().getMainExecutor(), event -> event.getCommandId() == response.getCommandId(), () -> this.getSessionData().getStreamId(), () -> this.getSessionData().getPid(), event -> {
                if (event.getTraceStatus().hasTraceStartStatus()) {
                    this.nativeAllocationTrackingStart(event.getTraceStatus().getTraceStartStatus());
                } else {
                    this.getLogger().error("Invalid trace status event received.");
                }
                return true;
            });
            this.getStudioProfilers().getTransportPoller().registerListener(statusListener);
        }, ide.getPoolExecutor());
    }

    private void stopNativeAllocationTracking() {
        Trace.TraceConfiguration configuration = Trace.TraceConfiguration.newBuilder().setAppName(this.getStudioProfilers().getProcess().getName()).setAbiCpuArch(TransportFileManager.getShortAbiName((String)this.getStudioProfilers().getDevice().getCpuAbi())).setInitiationType(Trace.TraceInitiationType.INITIATED_BY_UI).setPerfettoOptions(PerfettoConfig.TraceConfig.getDefaultInstance()).build();
        Commands.Command dumpCommand = Commands.Command.newBuilder().setStreamId(this.getSessionData().getStreamId()).setPid(this.getSessionData().getPid()).setSessionId(this.getSessionData().getSessionId()).setType(Commands.Command.CommandType.STOP_TRACE).setStopTrace(Trace.StopTrace.newBuilder().setProfilerType(Trace.ProfilerType.MEMORY).setConfiguration(configuration)).build();
        this.getStudioProfilers().getClient().executeAsync(dumpCommand, this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(response -> {
            TransportEventListener statusListener = new TransportEventListener(Common.Event.Kind.TRACE_STATUS, this.getStudioProfilers().getIdeServices().getMainExecutor(), event -> event.getCommandId() == response.getCommandId(), () -> this.getSessionData().getStreamId(), () -> this.getSessionData().getPid(), event -> {
                if (event.getTraceStatus().hasTraceStopStatus()) {
                    this.nativeAllocationTrackingStop(event.getTraceStatus().getTraceStopStatus());
                } else {
                    this.getLogger().error("Invalid trace status event received.");
                }
                return true;
            });
            this.getStudioProfilers().getTransportPoller().registerListener(statusListener);
        }, this.getStudioProfilers().getIdeServices().getPoolExecutor());
    }

    @VisibleForTesting
    public void toggleNativeAllocationTracking() {
        if (!this.myNativeAllocationTracking) {
            assert (this.getStudioProfilers().getProcess() != null);
            this.startNativeAllocationTracking();
        } else {
            this.stopNativeAllocationTracking();
        }
    }

    @VisibleForTesting
    void nativeAllocationTrackingStart(@NotNull Trace.TraceStartStatus status) {
        switch (status.getStatus()) {
            case SUCCESS: {
                LogUtils.log(this.getClass(), "Native allocations capture start succeeded");
                this.myNativeAllocationTracking = true;
                this.setModelToRecordingNative();
                this.setPendingCaptureStartTime(status.getStartTimeNs());
                this.setTrackingAllocations(true);
                this.myPendingLegacyAllocationStartTimeNs = status.getStartTimeNs();
                this.getTimeline().setStreaming(true);
                break;
            }
            case FAILURE: {
                if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
                    TaskEventTrackerUtils.trackStartTaskFailed(this.getStudioProfilers(), this.getStudioProfilers().getSessionsManager().isSessionAlive(), new TaskStartFailedMetadata(status, null, null));
                    this.cleanupFailedCapture();
                }
                this.getLogger().error("Failure with error code " + status.getErrorCode());
                break;
            }
        }
    }

    @VisibleForTesting
    void nativeAllocationTrackingStop(@NotNull Trace.TraceStopStatus status) {
        this.myRecordingOptionsModel.setFinished();
        switch (status.getStatus()) {
            case SUCCESS: {
                LogUtils.log(this.getClass(), "Native allocations capture stop succeeded");
                this.myNativeAllocationTracking = false;
                this.setTrackingAllocations(false);
                break;
            }
            case NO_ONGOING_PROFILING: {
                break;
            }
            default: {
                this.getLogger().error(status.getErrorMessage());
                if (!this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) break;
                TaskEventTrackerUtils.trackStopTaskFailed(this.getStudioProfilers(), this.getStudioProfilers().getSessionsManager().isSessionAlive(), new TaskStopFailedMetadata(status, null, null));
            }
        }
    }

    private void setModelToRecordingNative() {
        RecordingOption option = this.getRecordingOptionsModel().getBuiltInOptions().stream().filter(opt -> opt.getTitle().equals(RECORD_NATIVE_TEXT)).findFirst().orElse(null);
        if (option != null) {
            this.getRecordingOptionsModel().selectBuiltInOption(option);
            this.getRecordingOptionsModel().setRecording();
        }
    }

    public void requestHeapDump() {
        assert (this.getStudioProfilers().getProcess() != null);
        Commands.Command dumpCommand = Commands.Command.newBuilder().setStreamId(this.getSessionData().getStreamId()).setPid(this.getSessionData().getPid()).setSessionId(this.getSessionData().getSessionId()).setType(Commands.Command.CommandType.HEAP_DUMP).build();
        CompletableFuture.runAsync(() -> {
            Transport.ExecuteResponse response = this.getStudioProfilers().getClient().getTransportClient().execute(Transport.ExecuteRequest.newBuilder().setCommand(dumpCommand).build());
            TransportEventListener statusListener = new TransportEventListener(Common.Event.Kind.MEMORY_HEAP_DUMP_STATUS, this.getStudioProfilers().getIdeServices().getMainExecutor(), event -> event.getCommandId() == response.getCommandId(), () -> this.getSessionData().getStreamId(), () -> this.getSessionData().getPid(), event -> {
                this.handleHeapDumpStart(event.getMemoryHeapdumpStatus().getStatus());
                return true;
            });
            this.getStudioProfilers().getTransportPoller().registerListener(statusListener);
        }, this.getStudioProfilers().getIdeServices().getPoolExecutor());
        this.getTimeline().setStreaming(true);
        this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean("memory.used.capture", true);
    }

    private void handleHeapDumpStart(@NotNull Memory.HeapDumpStatus status) {
        switch (status.getStatus()) {
            case SUCCESS: {
                this.setPendingCaptureStartTime(status.getStartTime());
                this.getAspect().changed((Enum)MemoryProfilerAspect.HEAP_DUMP_STARTED);
                LogUtils.log(this.getClass(), "Heap dump capture start succeeded");
                break;
            }
            case IN_PROGRESS: {
                this.getLogger().debug(String.format(Locale.getDefault(), "A heap dump for %d is already in progress.", this.getSessionData().getPid()));
                break;
            }
            case UNSPECIFIED: 
            case NOT_PROFILING: 
            case FAILURE_UNKNOWN: 
            case UNRECOGNIZED: {
                if (!this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) break;
                TaskEventTrackerUtils.trackStartTaskFailed(this.getStudioProfilers(), this.getStudioProfilers().getSessionsManager().isSessionAlive(), new TaskStartFailedMetadata(null, null, status));
            }
        }
    }

    public DurationDataModel<CaptureDurationData<? extends CaptureObject>> getHeapDumpSampleDurations() {
        return this.myHeapDumpDurations;
    }

    public void trackAllocations(boolean enable) {
        MemoryProfiler.trackAllocations(this.getStudioProfilers(), this.getSessionData(), enable, true, status -> {
            switch (status.getStatus()) {
                case SUCCESS: {
                    this.setTrackingAllocations(enable);
                    this.setPendingCaptureStartTime(status.getStartTime());
                    this.myPendingLegacyAllocationStartTimeNs = enable ? status.getStartTime() : -1L;
                    break;
                }
                case IN_PROGRESS: {
                    this.setTrackingAllocations(true);
                    break;
                }
                case NOT_ENABLED: {
                    this.setTrackingAllocations(false);
                    break;
                }
                default: {
                    if (!this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) break;
                    if (enable) {
                        TaskEventTrackerUtils.trackStartTaskFailed(this.getStudioProfilers(), this.getStudioProfilers().getSessionsManager().isSessionAlive(), new TaskStartFailedMetadata(null, (Memory.TrackStatus)status, null));
                        break;
                    }
                    TaskEventTrackerUtils.trackStopTaskFailed(this.getStudioProfilers(), this.getStudioProfilers().getSessionsManager().isSessionAlive(), new TaskStopFailedMetadata(null, (Memory.TrackStatus)status, null));
                }
            }
            this.getAspect().changed((Enum)MemoryProfilerAspect.TRACKING_ENABLED);
            if (this.isTrackingAllocations()) {
                this.getTimeline().setStreaming(true);
                this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean("memory.used.capture", true);
            }
        });
    }

    public long getAllocationTrackingElapsedTimeNs() {
        if (this.isTrackingAllocations()) {
            try {
                Transport.TimeResponse timeResponse = this.getStudioProfilers().getClient().getTransportClient().getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(this.getSessionData().getStreamId()).build());
                return timeResponse.getTimestampNs() - this.myPendingLegacyAllocationStartTimeNs;
            }
            catch (StatusRuntimeException exception) {
                this.getLogger().warn((Throwable)exception);
            }
        }
        return -1L;
    }

    public boolean isNativeAllocationSamplingEnabled() {
        Common.Device device = this.getDeviceForSelectedSession();
        return device != null && device.getFeatureLevel() >= 29;
    }

    @NotNull
    public DurationDataModel<CaptureDurationData<? extends CaptureObject>> getAllocationInfosDurations() {
        return this.myAllocationDurations;
    }

    @NotNull
    public DurationDataModel<CaptureDurationData<? extends CaptureObject>> getNativeAllocationInfosDurations() {
        return this.myNativeAllocationDurations;
    }

    @Override
    @NotNull
    public Runnable getStopAction() {
        return this.myStopAction;
    }

    @Nullable
    public RecordingScreenModel<MainMemoryProfilerStage> getRecordingScreenModel() {
        return this.myRecordingScreenModel;
    }

    @VisibleForTesting
    public void selectCaptureDuration(@Nullable CaptureDurationData<? extends CaptureObject> durationData, @Nullable Executor joiner) {
        StudioProfilers profilers = this.getStudioProfilers();
        if (durationData instanceof AllocationDurationData) {
            profilers.setStage(AllocationStage.makeStaticStage(profilers, ((AllocationDurationData)durationData).getStart(), ((AllocationDurationData)durationData).getEnd()));
        } else if (durationData != null && (HeapDumpCaptureObject.class.isAssignableFrom(durationData.getCaptureObjectType()) || NativeAllocationSampleCaptureObject.class.isAssignableFrom(durationData.getCaptureObjectType()) || LegacyAllocationCaptureObject.class.isAssignableFrom(durationData.getCaptureObjectType()))) {
            profilers.setStage(new MemoryCaptureStage(profilers, this.getLoader(), durationData, joiner));
        } else {
            this.doSelectCaptureDuration(durationData, joiner);
        }
    }

    private void updateAllocationTrackingStatus() {
        List<Memory.AllocationsInfo> allocationsInfos = MemoryProfiler.getAllocationInfosForSession(this.getStudioProfilers().getClient(), this.getSessionData(), new Range(-9.223372036854776E18, 9.223372036854776E18));
        Memory.AllocationsInfo lastInfo = allocationsInfos.isEmpty() ? null : allocationsInfos.get(allocationsInfos.size() - 1);
        this.setTrackingAllocations(lastInfo != null && lastInfo.getLegacy() && lastInfo.getEndTime() == Long.MAX_VALUE);
        if (this.isTrackingAllocations()) {
            this.setPendingCaptureStartTime(lastInfo.getStartTime());
            this.myPendingLegacyAllocationStartTimeNs = lastInfo.getStartTime();
        } else {
            this.setPendingCaptureStartTime(-1L);
            this.myPendingLegacyAllocationStartTimeNs = -1L;
        }
    }

    private void updateNativeAllocationTrackingStatus() {
        List<Common.Event> events = MemoryProfiler.getNativeHeapEventsForSessionSortedByTimestamp(this.getStudioProfilers().getClient(), this.getSessionData(), new Range(-9.223372036854776E18, 9.223372036854776E18));
        if (events.isEmpty()) {
            return;
        }
        Trace.TraceStartStatus lastStartStatus = events.get(events.size() - 1).getTraceStatus().getTraceStartStatus();
        if (lastStartStatus.getStatus() == Trace.TraceStartStatus.Status.SUCCESS) {
            this.nativeAllocationTrackingStart(lastStartStatus);
        }
    }

    private static RecordingOption makeToggleOption(String title, String desc, Runnable toggle) {
        return new RecordingOption(title, desc, toggle, toggle);
    }

    private void cleanupFailedCapture() {
        if (this.getStudioProfilers().getSessionsManager().isSessionAlive()) {
            this.getStudioProfilers().getSessionsManager().endCurrentSession();
        }
        if (this.myRecordingScreenModel != null) {
            this.myRecordingScreenModel.setRecordingFailed();
        }
        this.myRecordingOptionsModel.setFinished();
        this.myNativeAllocationTracking = false;
    }

    public static boolean canSafelyLoadHprof(long fileSize) {
        System.gc();
        long leeway = 314572800L;
        long requestableMemory = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
        return requestableMemory >= (long)MEMORY_HPROF_SAFE_FACTOR * fileSize + leeway;
    }
}

