/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureObjectLoader {
    @Nullable
    private ExecutorService myExecutorService = null;
    @Nullable
    private ListenableFutureTask<CaptureObject> myOutstandingLoadingTask = null;

    @NotNull
    public ListenableFuture<CaptureObject> loadCapture(@NotNull CaptureObject captureObject, @Nullable Range queryRange, @Nullable Executor queryJoiner) {
        ListenableFutureTask task;
        assert (this.myExecutorService != null);
        this.cancelTask();
        this.myOutstandingLoadingTask = task = ListenableFutureTask.create(() -> captureObject.load(queryRange, queryJoiner) ? captureObject : null);
        Futures.addCallback((ListenableFuture)task, (FutureCallback)new FutureCallback<CaptureObject>(){

            public void onSuccess(@Nullable CaptureObject result) {
                this.removeTask();
            }

            public void onFailure(@NotNull Throwable ignored) {
                this.removeTask();
            }

            private void removeTask() {
                CaptureObjectLoader.this.myOutstandingLoadingTask = null;
            }
        }, (Executor)MoreExecutors.directExecutor());
        this.myExecutorService.submit((Runnable)task);
        return task;
    }

    public void start() {
        if (this.myExecutorService == null) {
            this.myExecutorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("profiler-capture-object-loader").build());
        }
    }

    public void stop() {
        this.cancelTask();
        if (this.myExecutorService != null) {
            this.myExecutorService.shutdownNow();
            this.myExecutorService = null;
        }
    }

    private void cancelTask() {
        if (this.myOutstandingLoadingTask != null) {
            this.myOutstandingLoadingTask.cancel(true);
            this.myOutstandingLoadingTask = null;
        }
    }
}

