/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.BaseMemoryProfilerStageKt;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureObjectLoader;
import com.android.tools.profilers.memory.CaptureSelectionAspect;
import com.android.tools.profilers.memory.MemoryCaptureSelection;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.MemoryDataProvider;
import com.android.tools.profilers.memory.adapters.classifiers.HeapSet;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.android.tools.profilers.tasks.TaskEventTrackerUtils;
import com.android.tools.profilers.tasks.TaskFinishedState;
import com.android.tools.profilers.tasks.TaskProcessingFailedMetadata;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 &2\u00020\u0001:\u0001&B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J&\u0010 \u001a\u00020\u001d2\u0012\u0010!\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010#\u0018\u00010\"2\b\u0010$\u001a\u0004\u0018\u00010%H\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0017R\u000e\u0010\u001b\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/profilers/memory/BaseMemoryProfilerStage;", "Lcom/android/tools/profilers/StreamingStage;", "profilers", "Lcom/android/tools/profilers/StudioProfilers;", "loader", "Lcom/android/tools/profilers/memory/CaptureObjectLoader;", "<init>", "(Lcom/android/tools/profilers/StudioProfilers;Lcom/android/tools/profilers/memory/CaptureObjectLoader;)V", "getLoader", "()Lcom/android/tools/profilers/memory/CaptureObjectLoader;", "captureSelection", "Lcom/android/tools/profilers/memory/MemoryCaptureSelection;", "getCaptureSelection", "()Lcom/android/tools/profilers/memory/MemoryCaptureSelection;", "pendingCaptureStartTime", "", "getPendingCaptureStartTime", "()J", "setPendingCaptureStartTime", "(J)V", "updateCaptureOnSelection", "", "getUpdateCaptureOnSelection", "()Z", "setUpdateCaptureOnSelection", "(Z)V", "isPendingCapture", "hasExited", "exit", "", "getStageType", "Lcom/google/wireless/android/sdk/stats/AndroidProfilerEvent$Stage;", "doSelectCaptureDuration", "durationData", "Lcom/android/tools/profilers/memory/CaptureDurationData;", "Lcom/android/tools/profilers/memory/adapters/CaptureObject;", "joiner", "Ljava/util/concurrent/Executor;", "Companion", "intellij.android.profilers"})
public abstract class BaseMemoryProfilerStage
extends StreamingStage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CaptureObjectLoader loader;
    @NotNull
    private final MemoryCaptureSelection captureSelection;
    private long pendingCaptureStartTime;
    private boolean updateCaptureOnSelection;
    private boolean hasExited;
    public static final long INVALID_START_TIME = -1L;

    public BaseMemoryProfilerStage(@NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        super(profilers);
        this.loader = loader;
        IdeProfilerServices ideProfilerServices = profilers.getIdeServices();
        Intrinsics.checkNotNullExpressionValue((Object)ideProfilerServices, (String)"getIdeServices(...)");
        this.captureSelection = new MemoryCaptureSelection(ideProfilerServices);
        this.pendingCaptureStartTime = -1L;
        this.updateCaptureOnSelection = true;
    }

    @NotNull
    protected final CaptureObjectLoader getLoader() {
        return this.loader;
    }

    @NotNull
    public final MemoryCaptureSelection getCaptureSelection() {
        return this.captureSelection;
    }

    protected final long getPendingCaptureStartTime() {
        return this.pendingCaptureStartTime;
    }

    protected final void setPendingCaptureStartTime(long l) {
        this.pendingCaptureStartTime = l;
    }

    protected final boolean getUpdateCaptureOnSelection() {
        return this.updateCaptureOnSelection;
    }

    protected final void setUpdateCaptureOnSelection(boolean bl) {
        this.updateCaptureOnSelection = bl;
    }

    public final boolean isPendingCapture() {
        return this.pendingCaptureStartTime != -1L;
    }

    @Override
    public void exit() {
        this.hasExited = true;
    }

    @Override
    @NotNull
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.MEMORY_STAGE;
    }

    protected final void doSelectCaptureDuration(@Nullable CaptureDurationData<? extends CaptureObject> durationData, @Nullable Executor joiner) {
        this.pendingCaptureStartTime = -1L;
        CaptureDurationData<? extends CaptureObject> captureDurationData = durationData;
        if (!this.captureSelection.selectCaptureEntry(captureDurationData != null ? captureDurationData.getCaptureEntry() : null)) {
            return;
        }
        this.updateCaptureOnSelection = false;
        CaptureObject captureObject = this.captureSelection.getSelectedCapture();
        Runnable clear = () -> BaseMemoryProfilerStage.doSelectCaptureDuration$lambda$0(this);
        if (captureObject == null) {
            clear.run();
            return;
        }
        this.captureSelection.getClassGroupingModel().update();
        if (durationData != null && durationData.getDurationUs() != Long.MAX_VALUE) {
            this.getTimeline().getSelectionRange().clear();
            double startTimeUs = TimeUnit.NANOSECONDS.toMicros(captureObject.getStartTimeNs());
            double endTimeUs = TimeUnit.NANOSECONDS.toMicros(captureObject.getEndTimeNs());
            this.getTimeline().getSelectionRange().set(startTimeUs, endTimeUs);
        }
        this.updateCaptureOnSelection = true;
        boolean isSessionAlive = this.getStudioProfilers().getSessionsManager().isSessionAlive();
        boolean isTaskBasedUxEnabled = this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled();
        Range range = this.getTimeline().getSelectionRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getSelectionRange(...)");
        Range queryRange = range;
        Runnable load = () -> BaseMemoryProfilerStage.doSelectCaptureDuration$lambda$1(this, captureObject, queryRange, joiner, isTaskBasedUxEnabled, isSessionAlive);
        this.getStudioProfilers().getIdeServices().runAsync(captureObject::canSafelyLoad, arg_0 -> BaseMemoryProfilerStage.doSelectCaptureDuration$lambda$2(load, this, clear, arg_0));
    }

    private static final void doSelectCaptureDuration$lambda$0(BaseMemoryProfilerStage this$0) {
        this$0.captureSelection.selectCaptureEntry(null);
        this$0.getTimeline().getSelectionRange().clear();
        this$0.captureSelection.getAspect().changed((Enum)CaptureSelectionAspect.CURRENT_LOADED_CAPTURE);
    }

    private static final void doSelectCaptureDuration$lambda$1(BaseMemoryProfilerStage this$0, CaptureObject $captureObject, Range $queryRange, Executor $joiner, boolean $isTaskBasedUxEnabled, boolean $isSessionAlive) {
        if (this$0.hasExited) {
            return;
        }
        ListenableFuture<CaptureObject> listenableFuture = this$0.loader.loadCapture($captureObject, $queryRange, $joiner);
        Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"loadCapture(...)");
        ListenableFuture<CaptureObject> future = listenableFuture;
        Runnable runnable = () -> BaseMemoryProfilerStage.doSelectCaptureDuration$lambda$1$0(future, this$0, $isTaskBasedUxEnabled, $isSessionAlive);
        Executor executor = $joiner;
        if (executor == null) {
            executor = MoreExecutors.directExecutor();
        }
        future.addListener(runnable, executor);
    }

    private static final void doSelectCaptureDuration$lambda$1$0(ListenableFuture $future, BaseMemoryProfilerStage this$0, boolean $isTaskBasedUxEnabled, boolean $isSessionAlive) {
        try {
            CaptureObject loadedCaptureObject = (CaptureObject)$future.get();
            if (this$0.captureSelection.finishSelectingCaptureObject(loadedCaptureObject)) {
                boolean isLegacy;
                MemoryCaptureSelection memoryCaptureSelection = this$0.captureSelection;
                Collection<HeapSet> collection = loadedCaptureObject.getHeapSets();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getHeapSets(...)");
                memoryCaptureSelection.selectHeapSet(BaseMemoryProfilerStageKt.access$getDefault(collection));
                boolean isJavaKotlinAllocationsTask = this$0.getStudioProfilers().getSessionsManager().getCurrentTaskType() == ProfilerTaskType.JAVA_KOTLIN_ALLOCATIONS;
                StudioProfilers studioProfilers = this$0.getStudioProfilers();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
                boolean bl = isLegacy = !MemoryDataProvider.Companion.getIsLiveAllocationTrackingSupported(studioProfilers);
                if ((!isJavaKotlinAllocationsTask || isLegacy) && $isTaskBasedUxEnabled) {
                    StudioProfilers studioProfilers2 = this$0.getStudioProfilers();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers2), (String)"getStudioProfilers(...)");
                    TaskEventTrackerUtils.trackTaskFinished(studioProfilers2, $isSessionAlive, TaskFinishedState.COMPLETED);
                }
            } else {
                this$0.doSelectCaptureDuration(null, null);
                if ($isTaskBasedUxEnabled) {
                    StudioProfilers studioProfilers = this$0.getStudioProfilers();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
                    TaskEventTrackerUtils.trackProcessingTaskFailed(studioProfilers, this$0.getStudioProfilers().getSessionsManager().isSessionAlive(), new TaskProcessingFailedMetadata(null));
                }
            }
            this$0.captureSelection.refreshSelectedHeap();
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            this$0.doSelectCaptureDuration(null, null);
            if ($isTaskBasedUxEnabled) {
                StudioProfilers studioProfilers = this$0.getStudioProfilers();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
                TaskEventTrackerUtils.trackProcessingTaskFailed(studioProfilers, this$0.getStudioProfilers().getSessionsManager().isSessionAlive(), new TaskProcessingFailedMetadata(null));
            }
        }
        catch (ExecutionException exception) {
            this$0.doSelectCaptureDuration(null, null);
            BaseMemoryProfilerStage.Companion.getLogger().error((Throwable)exception);
            if ($isTaskBasedUxEnabled) {
                StudioProfilers studioProfilers = this$0.getStudioProfilers();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
                TaskEventTrackerUtils.trackProcessingTaskFailed(studioProfilers, this$0.getStudioProfilers().getSessionsManager().isSessionAlive(), new TaskProcessingFailedMetadata(null));
            }
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    private static final void doSelectCaptureDuration$lambda$2(Runnable $load, BaseMemoryProfilerStage this$0, Runnable $clear, Boolean canLoad) {
        Intrinsics.checkNotNullParameter((Object)canLoad, (String)"canLoad");
        if (canLoad.booleanValue()) {
            $load.run();
        } else {
            this$0.getStudioProfilers().getIdeServices().openYesNoDialog("The hprof file is large, and Android Studio may become unresponsive while it parses the data and afterwards. Do you want to continue?", "Heap Dump File Too Large", $load, $clear);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/profilers/memory/BaseMemoryProfilerStage$Companion;", "", "<init>", "()V", "INVALID_START_TIME", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLogger() {
            Logger logger = Logger.getInstance(BaseMemoryProfilerStage.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

