/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.leakcanary;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.SupportLevel;
import com.android.tools.profilers.TaskStage;
import com.android.tools.profilers.leakcanary.LeakCanaryModel;
import com.android.tools.profilers.leakcanary.LeakCanarySessionArtifact;
import com.android.tools.profilers.leakcanary.LeakCanaryTaskHandlerKt;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.taskbased.home.StartTaskSelectionError;
import com.android.tools.profilers.tasks.args.TaskArgs;
import com.android.tools.profilers.tasks.args.singleartifact.leakcanary.LeakCanaryTaskArgs;
import com.android.tools.profilers.tasks.taskhandlers.singleartifact.SingleArtifactTaskHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0014J\u0014\u0010\u0019\u001a\u00020\u00172\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0014J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/profilers/leakcanary/LeakCanaryTaskHandler;", "Lcom/android/tools/profilers/tasks/taskhandlers/singleartifact/SingleArtifactTaskHandler;", "Lcom/android/tools/profilers/leakcanary/LeakCanaryModel;", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "<init>", "(Lcom/android/tools/profilers/sessions/SessionsManager;)V", "setupStage", "", "enter", "", "args", "Lcom/android/tools/profilers/tasks/args/TaskArgs;", "startCapture", "stage", "stopCapture", "loadTask", "getTaskName", "", "supportsArtifact", "artifact", "Lcom/android/tools/profilers/sessions/SessionArtifact;", "createStartTaskArgs", "Lcom/android/tools/profilers/tasks/args/singleartifact/leakcanary/LeakCanaryTaskArgs;", "isStartupTask", "createLoadingTaskArgs", "checkSupportForDeviceAndProcess", "Lcom/android/tools/profilers/taskbased/home/StartTaskSelectionError;", "device", "Lcom/android/tools/profiler/proto/Common$Device;", "process", "Lcom/android/tools/profiler/proto/Common$Process;", "logEnterStage", "intellij.android.profilers"})
public final class LeakCanaryTaskHandler
extends SingleArtifactTaskHandler<LeakCanaryModel> {
    @NotNull
    private final SessionsManager sessionsManager;

    public LeakCanaryTaskHandler(@NotNull SessionsManager sessionsManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        super(sessionsManager);
        this.sessionsManager = sessionsManager;
    }

    @Override
    public void setupStage() {
        StudioProfilers studioProfilers = this.sessionsManager.getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
        StudioProfilers studioProfilers2 = studioProfilers;
        LeakCanaryModel stage = new LeakCanaryModel(studioProfilers2);
        studioProfilers2.setStage(stage);
        super.setStage((TaskStage)stage);
    }

    @Override
    public boolean enter(@NotNull TaskArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.logEnterStage();
        return super.enter(args);
    }

    @Override
    protected void startCapture(@NotNull LeakCanaryModel stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        stage.startListening();
    }

    @Override
    protected void stopCapture(@NotNull LeakCanaryModel stage) {
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        stage.stopListening();
    }

    @Override
    public boolean loadTask(@NotNull TaskArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!(args instanceof LeakCanaryTaskArgs)) {
            this.handleError("The task arguments (TaskArgs) supplier are not of the expected type (LeakCanaryTaskArgs)");
            return false;
        }
        LeakCanarySessionArtifact leakCanaryArtifact = ((LeakCanaryTaskArgs)args).getLeakCanaryArtifact();
        if (leakCanaryArtifact == null) {
            this.handleError("The task arguments (LeakCanaryTaskArgs) supplied do not contains a valid artifact to load");
            return false;
        }
        this.loadCapture(leakCanaryArtifact);
        return true;
    }

    @Override
    @NotNull
    public String getTaskName() {
        return "LeakCanary";
    }

    @Override
    public boolean supportsArtifact(@Nullable SessionArtifact<?> artifact2) {
        return artifact2 instanceof LeakCanarySessionArtifact;
    }

    @Override
    @NotNull
    protected LeakCanaryTaskArgs createStartTaskArgs(boolean isStartupTask) {
        return new LeakCanaryTaskArgs(false, null);
    }

    @Override
    @NotNull
    protected LeakCanaryTaskArgs createLoadingTaskArgs(@NotNull SessionArtifact<?> artifact2) {
        Intrinsics.checkNotNullParameter(artifact2, (String)"artifact");
        return new LeakCanaryTaskArgs(false, (LeakCanarySessionArtifact)artifact2);
    }

    @Override
    @Nullable
    public StartTaskSelectionError checkSupportForDeviceAndProcess(@NotNull Common.Device device, @NotNull Common.Process process) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Common.Process.ExposureLevel exposureLevel = process.getExposureLevel();
        Intrinsics.checkNotNullExpressionValue((Object)exposureLevel, (String)"getExposureLevel(...)");
        boolean isFeatureSupported = SupportLevel.Companion.of(exposureLevel).isFeatureSupported(SupportLevel.Feature.MEMORY_LEAK_WITH_LEAKCANARY);
        if (isFeatureSupported) {
            return null;
        }
        return new StartTaskSelectionError(StartTaskSelectionError.StartTaskSelectionErrorCode.TASK_REQUIRES_DEBUGGABLE_PROCESS, null, 2, null);
    }

    private final void logEnterStage() {
        LeakCanaryTaskHandlerKt.access$getLogger$p().info((Object)"Entering LeakCanary stage");
    }
}

