/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.customevent;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.StudioProfilers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class UserCounterDataSeries
implements DataSeries<Long> {
    private static final long COUNTER_BUCKET = TimeUnit.MILLISECONDS.toNanos(500L);
    @NotNull
    private final TransportServiceGrpc.TransportServiceBlockingStub myClient;
    @NotNull
    private final StreamingTimeline myTimeline;
    private final long myStreamId;
    private final int myPid;
    private final long mySessionStartTimestamp;

    public UserCounterDataSeries(@NotNull TransportServiceGrpc.TransportServiceBlockingStub client, @NotNull StudioProfilers profilers) {
        this.myClient = client;
        this.myTimeline = profilers.getTimeline();
        this.myStreamId = profilers.getSession().getStreamId();
        this.myPid = profilers.getSession().getPid();
        this.mySessionStartTimestamp = profilers.getSession().getStartTimestamp();
    }

    public List<SeriesData<Long>> getDataForRange(Range range) {
        if (range.isEmpty()) {
            return new ArrayList<SeriesData<Long>>();
        }
        long minNs = TimeUnit.MICROSECONDS.toNanos((long)range.getMin());
        long maxNs = TimeUnit.MICROSECONDS.toNanos((long)range.getMax());
        long minRangeBucketStart = minNs - (minNs - this.mySessionStartTimestamp) % COUNTER_BUCKET;
        long maxRangeBucketEnd = maxNs + (COUNTER_BUCKET - (maxNs - minRangeBucketStart) % COUNTER_BUCKET);
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setStreamId(this.myStreamId).setPid(this.myPid).setKind(Common.Event.Kind.USER_COUNTERS).setFromTimestamp(minRangeBucketStart).setToTimestamp(maxRangeBucketEnd).build();
        Transport.GetEventGroupsResponse response = this.myClient.getEventGroups(request);
        TreeMap<Long, Long> bucketStartToCount = new TreeMap<Long, Long>();
        long minDataNs = this.myTimeline.getDataStartTimeNs();
        long intersectMin = minNs < minDataNs ? minDataNs : minNs;
        bucketStartToCount.put(intersectMin, 0L);
        long startTimestamp = minRangeBucketStart > minDataNs ? minRangeBucketStart : minDataNs;
        for (Transport.EventGroup group : response.getGroupsList()) {
            if (group.getEventsCount() <= 0) continue;
            for (Common.Event event : group.getEventsList()) {
                long timestamp = event.getTimestamp();
                if (timestamp < startTimestamp || timestamp > maxRangeBucketEnd) continue;
                long eventBucketStart = timestamp - (timestamp - minRangeBucketStart) % COUNTER_BUCKET;
                long initial = eventBucketStart < minNs ? minNs : eventBucketStart;
                Long countStart = (Long)bucketStartToCount.get(initial);
                bucketStartToCount.put(initial, countStart == null ? 1L : countStart + 1L);
                if (eventBucketStart + COUNTER_BUCKET > maxNs) continue;
                Long countEnd = (Long)bucketStartToCount.get(eventBucketStart + COUNTER_BUCKET);
                bucketStartToCount.put(eventBucketStart + COUNTER_BUCKET, countEnd == null ? 0L : countEnd);
            }
        }
        ArrayList<SeriesData<Long>> userCounterData = new ArrayList<SeriesData<Long>>();
        for (Map.Entry entry2 : bucketStartToCount.entrySet()) {
            userCounterData.add((SeriesData<Long>)new SeriesData(TimeUnit.NANOSECONDS.toMicros((Long)entry2.getKey()), (Object)((Long)entry2.getValue())));
        }
        return userCounterData;
    }
}

