/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.intellij.ui.components.JBLabel;
import java.awt.Color;
import java.awt.Graphics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/profilers/cpu/analysis/FilledLabel;", "Lcom/intellij/ui/components/JBLabel;", "text", "", "barColor", "Ljava/awt/Color;", "percent", "", "maxBarWidth", "<init>", "(Ljava/lang/String;Ljava/awt/Color;II)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.android.profilers.ui"})
final class FilledLabel
extends JBLabel {
    @NotNull
    private final Color barColor;
    private final int percent;
    private final int maxBarWidth;

    public FilledLabel(@NotNull String text, @NotNull Color barColor, int percent, int maxBarWidth) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)barColor, (String)"barColor");
        super(text);
        this.barColor = barColor;
        this.percent = percent;
        this.maxBarWidth = maxBarWidth;
        int n = this.percent;
        if (!(0 <= n ? n < 101 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.setColor(this.barColor);
        g.fillRect(0, 0, Math.min(this.getWidth(), this.maxBarWidth) * this.percent / 100, this.getHeight());
        super.paintComponent(g);
    }
}

