/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.analysis;

import com.android.tools.adtui.TabbedToolbar;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.ViewBinder;
import com.android.tools.profilers.SoftHashMap;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.analysis.AndroidFrameTimelineAnalysisModel;
import com.android.tools.profilers.cpu.analysis.AndroidFrameTimelineTab;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisEventsTabModel;
import com.android.tools.profilers.cpu.analysis.CaptureNodeAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChart;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisChartModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisEventsTab;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisFramesTab;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisFramesTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisSummaryTab;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTab;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisTabModel;
import com.android.tools.profilers.cpu.analysis.CpuAnalyzable;
import com.android.tools.profilers.cpu.analysis.CpuThreadAnalysisEventsTabModel;
import com.android.tools.profilers.cpu.analysis.CpuThreadAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.FullTraceAnalysisSummaryTabModel;
import com.android.tools.profilers.cpu.analysis.JankAnalysisModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

public class CpuAnalysisPanel
extends AspectObserver {
    private final TabbedToolbar myTabs;
    private final JBTabbedPane myTabView = new JBTabbedPane();
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final CpuCaptureStage myStage;
    private final StudioProfilersView myProfilersView;
    private CpuAnalysisModel mySelectedModel;
    private ViewBinder<StudioProfilersView, CpuAnalysisTabModel, CpuAnalysisTab> myTabViewsBinder;

    public CpuAnalysisPanel(@NotNull StudioProfilersView view, @NotNull CpuCaptureStage stage) {
        this.myStage = stage;
        this.myProfilersView = view;
        JLabel tabsTitle = new JLabel("Analysis");
        tabsTitle.setBorder(JBUI.Borders.empty((int)5));
        this.myTabs = new TabbedToolbar((JComponent)tabsTitle);
        this.setupBindings();
        stage.getAspect().addDependency((AspectObserver)this).onChange((Enum)CpuCaptureStage.Aspect.ANALYSIS_MODEL_UPDATED, this::updateComponents);
        stage.getMultiSelectionModel().addDependency((AspectObserver)this).onChange((Enum)MultiSelectionModel.Aspect.SELECTIONS_CHANGED, this::updateComponents);
        stage.getMultiSelectionModel().addDependency((AspectObserver)this).onChange((Enum)MultiSelectionModel.Aspect.ACTIVE_SELECTION_CHANGED, this::onSelectedTabChanged);
        this.myTabs.setBorder(JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)0, (int)0, (int)1, (int)0));
        this.myPanel.add((Component)this.myTabs, "North");
        this.myPanel.add((Component)this.myTabView, "Center");
        this.myTabView.setTabComponentInsets((Insets)JBUI.insets((int)0));
        this.myTabView.addChangeListener((ChangeListener)new TabChangeListener());
    }

    private void setupBindings() {
        this.myTabViewsBinder = new ViewBinder();
        this.myTabViewsBinder.bind(CpuAnalysisChartModel.class, CpuAnalysisChart::new);
        this.myTabViewsBinder.bind(FullTraceAnalysisSummaryTabModel.class, CpuAnalysisSummaryTab::new);
        this.myTabViewsBinder.bind(CpuThreadAnalysisSummaryTabModel.class, CpuAnalysisSummaryTab::new);
        this.myTabViewsBinder.bind(CaptureNodeAnalysisSummaryTabModel.class, CpuAnalysisSummaryTab::new);
        this.myTabViewsBinder.bind(CpuThreadAnalysisEventsTabModel.class, CpuAnalysisEventsTab::new);
        this.myTabViewsBinder.bind(CaptureNodeAnalysisEventsTabModel.class, CpuAnalysisEventsTab::new);
        this.myTabViewsBinder.bind(CpuAnalysisFramesTabModel.class, CpuAnalysisFramesTab::new);
        this.myTabViewsBinder.bind(AndroidFrameTimelineAnalysisModel.Tab.class, AndroidFrameTimelineTab::new);
        this.myTabViewsBinder.bind(JankAnalysisModel.Summary.class, CpuAnalysisSummaryTab::new);
    }

    @NotNull
    @VisibleForTesting
    public JBTabbedPane getTabView() {
        return this.myTabView;
    }

    @NotNull
    @VisibleForTesting
    TabbedToolbar getTabs() {
        return this.myTabs;
    }

    @NotNull
    @VisibleForTesting
    public ViewBinder<StudioProfilersView, CpuAnalysisTabModel, CpuAnalysisTab> getTabViewsBinder() {
        return this.myTabViewsBinder;
    }

    private void updateComponents() {
        this.myTabs.clearTabs();
        List<CpuAnalysisModel<?>> pinnedModels = this.myStage.getPinnedAnalysisModels();
        List selections = this.myStage.getMultiSelectionModel().getSelections();
        for (CpuAnalysisModel<?> model : pinnedModels) {
            this.myTabs.addTab(model.getName(), () -> {
                this.onSelectAnalysis(model);
                this.myStage.getMultiSelectionModel().setActiveSelection(null);
            });
        }
        for (MultiSelectionModel.Entry selection : selections) {
            CpuAnalysisModel model = CpuAnalysisPanel.merge(selection.getValue().stream().map(CpuAnalyzable::getAnalysisModel));
            Object selectionKey = selection.getKey();
            this.myTabs.addTab(model.getName(), () -> {
                this.onSelectAnalysis(model);
                this.myStage.getMultiSelectionModel().setActiveSelection(selectionKey);
            }, () -> this.myStage.getMultiSelectionModel().removeSelection(selectionKey));
        }
        Object activeSelectionKey = this.myStage.getMultiSelectionModel().getActiveSelectionKey();
        if (activeSelectionKey != null) {
            int selectedIndex = CollectionsKt.indexOfFirst((List)selections, entry2 -> entry2.getKey().equals(activeSelectionKey));
            this.myTabs.selectTab(pinnedModels.size() + selectedIndex);
        } else if (this.myTabs.countTabs() > 0) {
            this.myTabs.selectTab(0);
        }
    }

    private static <T> CpuAnalysisModel<T> merge(Stream<CpuAnalysisModel<T>> models) {
        return models.reduce(CpuAnalysisModel::mergeWith).get();
    }

    private void onSelectedTabChanged() {
        int selectedIndex = this.myStage.getMultiSelectionModel().getActiveSelectionIndex();
        List<CpuAnalysisModel<?>> pinnedModels = this.myStage.getPinnedAnalysisModels();
        if (selectedIndex >= 0) {
            this.myTabs.selectTab(pinnedModels.size() + selectedIndex);
        } else if (this.myTabs.countTabs() > 0) {
            this.myTabs.selectTab(pinnedModels.indexOf(this.mySelectedModel));
        }
    }

    private void onSelectAnalysis(@NotNull CpuAnalysisModel<?> model) {
        this.mySelectedModel = model;
        this.myTabView.removeAll();
        model.getTabModels().forEach(tabModel -> {
            String typeName = tabModel.getTabType().getName();
            this.myTabView.insertTab(typeName, null, (Component)new JPanel(), typeName, this.myTabView.getTabCount());
        });
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    private class TabChangeListener
    implements ChangeListener {
        private int myLastSelectedIndex = -1;
        private Map<CpuAnalysisTabModel<?>, CpuAnalysisTab<?>> myCachedTabs = new SoftHashMap();

        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int newIndex = CpuAnalysisPanel.this.myTabView.getSelectedIndex();
            if (newIndex == this.myLastSelectedIndex || CpuAnalysisPanel.this.mySelectedModel == null) {
                return;
            }
            if (this.myLastSelectedIndex >= 0 && this.myLastSelectedIndex < CpuAnalysisPanel.this.myTabView.getTabCount()) {
                CpuAnalysisTab tab = (CpuAnalysisTab)CpuAnalysisPanel.this.myTabView.getComponentAt(this.myLastSelectedIndex);
                if (tab != null) {
                    this.myCachedTabs.put((CpuAnalysisTabModel<?>)tab.getModel(), tab);
                    tab.onRemoved();
                }
                CpuAnalysisPanel.this.myTabView.setComponentAt(this.myLastSelectedIndex, (Component)new JPanel());
            }
            if (newIndex >= 0 && newIndex < CpuAnalysisPanel.this.myTabView.getTabCount()) {
                CpuAnalysisTab<?> cachedTab = this.myCachedTabs.get(CpuAnalysisPanel.this.mySelectedModel.getTabModelAt(newIndex));
                if (cachedTab != null) {
                    cachedTab.onReattached();
                    CpuAnalysisPanel.this.myTabView.setComponentAt(newIndex, cachedTab);
                } else {
                    CpuAnalysisPanel.this.myTabView.setComponentAt(newIndex, (Component)CpuAnalysisPanel.this.myTabViewsBinder.build((Object)CpuAnalysisPanel.this.myProfilersView, CpuAnalysisPanel.this.mySelectedModel.getTabModelAt(newIndex)));
                }
            }
            this.myLastSelectedIndex = newIndex;
        }
    }
}

