/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.adapters;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.event.EventMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CpuDataProvider {
    private static final SingleUnitAxisFormatter CPU_USAGE_FORMATTER = new SingleUnitAxisFormatter(1, 5, 10, "%");
    private static final SingleUnitAxisFormatter NUM_THREADS_AXIS = new SingleUnitAxisFormatter(1, 5, 1, "");
    protected static final long PROFILING_INSTRUCTIONS_EASE_OUT_NS = TimeUnit.SECONDS.toNanos(3L);
    private final StudioProfilers myProfilers;
    private final CpuThreadsModel myThreadsStates;
    private final ClampedAxisComponentModel myCpuUsageAxis;
    private final ClampedAxisComponentModel myThreadCountAxis;
    private final ResizingAxisComponentModel myTimeAxisGuide;
    private final DetailedCpuUsage myCpuUsage;
    private final CpuProfilerStage.CpuStageLegends myLegends;
    private final DurationDataModel<CpuTraceInfo> myTraceDurations;
    private final EventMonitor myEventMonitor;
    private final RangeSelectionModel myRangeSelectionModel;
    private final EaseOutModel myInstructionsEaseOutModel;
    private final CpuTraceDataSeries myCpuTraceDataSeries;
    @NotNull
    private final UpdatableManager myUpdatableManager;
    private final StreamingTimeline myTimeline;
    private final AspectModel<CpuProfilerAspect> myAspect = new AspectModel();

    public CpuDataProvider(@NotNull StudioProfilers profilers, @NotNull StreamingTimeline timeline) {
        this.myProfilers = profilers;
        this.myTimeline = timeline;
        Range viewRange = timeline.getViewRange();
        Range dataRange = timeline.getDataRange();
        Range selectionRange = timeline.getSelectionRange();
        this.myCpuUsage = new DetailedCpuUsage(profilers);
        this.myCpuUsageAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getCpuRange(), (BaseAxisFormatter)CPU_USAGE_FORMATTER).build();
        this.myThreadCountAxis = new ClampedAxisComponentModel.Builder(this.myCpuUsage.getThreadRange(), (BaseAxisFormatter)NUM_THREADS_AXIS).build();
        this.myTimeAxisGuide = new ResizingAxisComponentModel.Builder(viewRange, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT_WITHOUT_MINOR_TICKS).setGlobalRange(dataRange).build();
        this.myLegends = new CpuProfilerStage.CpuStageLegends(this.myCpuUsage, dataRange);
        this.myCpuTraceDataSeries = new CpuTraceDataSeries();
        this.myTraceDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)this.myCpuTraceDataSeries));
        this.myThreadsStates = new CpuThreadsModel(viewRange, profilers, this.myProfilers.getSession());
        this.myEventMonitor = new EventMonitor(profilers);
        this.myRangeSelectionModel = this.buildRangeSelectionModel(selectionRange, viewRange);
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
        this.myUpdatableManager = new UpdatableManager(this.myProfilers.getUpdater());
    }

    public int getSelectedThread() {
        return this.getThreadStates().getThread();
    }

    public void setSelectedThread(int id) {
        this.getThreadStates().setThread(id);
        Range range = this.myTimeline.getSelectionRange();
        if (range.isEmpty()) {
            this.myAspect.changed((Enum)CpuProfilerAspect.SELECTED_THREADS);
        }
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    @NotNull
    public UpdatableManager getUpdatableManager() {
        return this.myUpdatableManager;
    }

    @NotNull
    public RangeSelectionModel getRangeSelectionModel() {
        return this.myRangeSelectionModel;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        return this.myInstructionsEaseOutModel;
    }

    public AxisComponentModel getCpuUsageAxis() {
        return this.myCpuUsageAxis;
    }

    public AxisComponentModel getThreadCountAxis() {
        return this.myThreadCountAxis;
    }

    public AxisComponentModel getTimeAxisGuide() {
        return this.myTimeAxisGuide;
    }

    public DetailedCpuUsage getCpuUsage() {
        return this.myCpuUsage;
    }

    public CpuProfilerStage.CpuStageLegends getLegends() {
        return this.myLegends;
    }

    public DurationDataModel<CpuTraceInfo> getTraceDurations() {
        return this.myTraceDurations;
    }

    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    @NotNull
    public CpuTraceDataSeries getCpuTraceDataSeries() {
        return this.myCpuTraceDataSeries;
    }

    @NotNull
    public CpuThreadsModel getThreadStates() {
        return this.myThreadsStates;
    }

    private RangeSelectionModel buildRangeSelectionModel(@NotNull Range selectionRange, @NotNull Range viewRange) {
        RangeSelectionModel rangeSelectionModel2 = new RangeSelectionModel(selectionRange, viewRange);
        rangeSelectionModel2.addConstraint(this.myTraceDurations);
        return rangeSelectionModel2;
    }

    public class CpuTraceDataSeries
    implements DataSeries<CpuTraceInfo> {
        public List<SeriesData<CpuTraceInfo>> getDataForRange(Range range) {
            List<Trace.TraceInfo> traceInfos = CpuProfiler.getTraceInfoFromRange(CpuDataProvider.this.myProfilers.getClient(), CpuDataProvider.this.myProfilers.getSession(), range);
            ArrayList<SeriesData<CpuTraceInfo>> seriesData = new ArrayList<SeriesData<CpuTraceInfo>>();
            for (Trace.TraceInfo protoTraceInfo : traceInfos) {
                CpuTraceInfo info = new CpuTraceInfo(protoTraceInfo);
                seriesData.add((SeriesData<CpuTraceInfo>)new SeriesData((long)info.getRange().getMin(), (Object)info));
            }
            return seriesData;
        }
    }
}

