/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerEvent;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerTooltip;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0003H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0013\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0010\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/profilers/cpu/SurfaceflingerTooltipView;", "Lcom/android/tools/adtui/TooltipView;", "parent", "Ljavax/swing/JComponent;", "tooltip", "Lcom/android/tools/profilers/cpu/systemtrace/SurfaceflingerTooltip;", "<init>", "(Ljavax/swing/JComponent;Lcom/android/tools/profilers/cpu/systemtrace/SurfaceflingerTooltip;)V", "getTooltip", "()Lcom/android/tools/profilers/cpu/systemtrace/SurfaceflingerTooltip;", "content", "Ljavax/swing/JPanel;", "eventNameLabel", "Ljavax/swing/JLabel;", "Lorg/jetbrains/annotations/NotNull;", "getEventNameLabel$annotations", "()V", "getEventNameLabel", "()Ljavax/swing/JLabel;", "durationLabel", "getDurationLabel$annotations", "getDurationLabel", "createTooltip", "timeChanged", "", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
public final class SurfaceflingerTooltipView
extends TooltipView {
    @NotNull
    private final SurfaceflingerTooltip tooltip;
    @NotNull
    private final JPanel content;
    @NotNull
    private final JLabel eventNameLabel;
    @NotNull
    private final JLabel durationLabel;
    public static final int $stable = 8;

    public SurfaceflingerTooltipView(@NotNull JComponent parent, @NotNull SurfaceflingerTooltip tooltip) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)((Object)tooltip), (String)"tooltip");
        super(tooltip.getTimeline());
        this.tooltip = tooltip;
        this.content = new JPanel((LayoutManager)new TabularLayout("*").setVGap(12));
        JLabel jLabel = TooltipView.createTooltipLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"createTooltipLabel(...)");
        this.eventNameLabel = jLabel;
        JLabel jLabel2 = TooltipView.createTooltipLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel2, (String)"createTooltipLabel(...)");
        this.durationLabel = jLabel2;
        JPanel $this$_init__u24lambda_u240 = jPanel = this.content;
        boolean bl = false;
        $this$_init__u24lambda_u240.add((Component)this.eventNameLabel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        $this$_init__u24lambda_u240.add((Component)this.durationLabel, new TabularLayout.Constraint(1, 0, 0, 4, null));
        this.tooltip.addDependency((AspectObserver)this).onChange((Enum)SurfaceflingerTooltip.Aspect.EVENT_CHANGED, this::timeChanged);
        this.timeChanged();
    }

    @NotNull
    public final SurfaceflingerTooltip getTooltip() {
        return this.tooltip;
    }

    @NotNull
    public final JLabel getEventNameLabel() {
        return this.eventNameLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getEventNameLabel$annotations() {
    }

    @NotNull
    public final JLabel getDurationLabel() {
        return this.durationLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDurationLabel$annotations() {
    }

    @NotNull
    protected JComponent createTooltip() {
        return this.content;
    }

    private final void timeChanged() {
        SurfaceflingerEvent activeEvent = this.tooltip.getActiveSurfaceflingerEvent();
        if (activeEvent == null) {
            this.content.setVisible(false);
            return;
        }
        this.content.setVisible(true);
        this.eventNameLabel.setText(activeEvent.getName());
        this.durationLabel.setText(TimeFormatter.getSingleUnitDurationString((long)(activeEvent.getEnd() - activeEvent.getStart())));
        boolean isProcessing = activeEvent.getType() == SurfaceflingerEvent.Type.PROCESSING;
        this.eventNameLabel.setVisible(isProcessing);
        this.durationLabel.setVisible(isProcessing);
    }
}

