/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.UnifiedEventDataSeries;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.MergeCaptureDataSeries;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class CpuUsage
extends LineChartModel {
    @NotNull
    private final Range myCpuRange = new Range(0.0, 100.0);
    @NotNull
    private final RangedContinuousSeries myCpuSeries;

    public CpuUsage(@NotNull StudioProfilers profilers) {
        this(profilers, profilers.getTimeline().getViewRange(), profilers.getTimeline().getDataRange(), null);
    }

    public CpuUsage(@NotNull StudioProfilers profilers, @NotNull Range viewRange, @NotNull Range dataRange, @Nullable CpuCapture cpuCapture) {
        DataSeries<Long> series = CpuUsage.buildDataSeries(profilers.getClient().getTransportClient(), profilers.getSession(), cpuCapture);
        this.myCpuSeries = new RangedContinuousSeries(this.getCpuSeriesLabel(), viewRange, this.myCpuRange, series, dataRange);
        this.add(this.myCpuSeries);
    }

    @NotNull
    public Range getCpuRange() {
        return this.myCpuRange;
    }

    @NotNull
    public RangedContinuousSeries getCpuSeries() {
        return this.myCpuSeries;
    }

    protected String getCpuSeriesLabel() {
        return "";
    }

    protected static List<SeriesData<Long>> extractData(List<Common.Event> dataList, boolean isOtherProcess) {
        return IntStream.range(0, dataList.size() - 1).mapToObj(index -> CpuUsage.getCpuUsageData(((Common.Event)dataList.get(index)).getCpuUsage(), ((Common.Event)dataList.get(index + 1)).getCpuUsage(), isOtherProcess)).collect(Collectors.toList());
    }

    protected static SeriesData<Long> getCpuUsageData(Cpu.CpuUsageData prevData, Cpu.CpuUsageData data, boolean isOtherProcess) {
        long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(data.getEndTimestamp());
        long elapsed = data.getElapsedTimeInMillisec() - prevData.getElapsedTimeInMillisec();
        double app = 100.0 * (double)(data.getAppCpuTimeInMillisec() - prevData.getAppCpuTimeInMillisec()) / (double)elapsed;
        double system = 100.0 * (double)(data.getSystemCpuTimeInMillisec() - prevData.getSystemCpuTimeInMillisec()) / (double)elapsed;
        system = Math.max(0.0, Math.min(system, 100.0));
        app = Math.max(0.0, Math.min(app, system));
        return new SeriesData(dataTimestamp, (Object)((long)(isOtherProcess ? system - app : app)));
    }

    @VisibleForTesting
    public static DataSeries<Long> buildDataSeries(@NotNull TransportServiceGrpc.TransportServiceBlockingStub client, @NotNull Common.Session session, @Nullable CpuCapture cpuCapture) {
        Object series = new UnifiedEventDataSeries<Long>(client, session.getStreamId(), session.getPid(), Common.Event.Kind.CPU_USAGE, session.getPid(), events -> CpuUsage.extractData(events, false));
        if (cpuCapture != null && cpuCapture.getSystemTraceData() != null) {
            series = new MergeCaptureDataSeries<Long>(cpuCapture, (DataSeries<Long>)series, new LazyDataSeries(() -> cpuCapture.getSystemTraceData().getCpuUtilizationSeries()));
        }
        return series;
    }
}

