/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001d\u001e\u001fB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/android/tools/profilers/Notification;", "", "severity", "Lcom/android/tools/profilers/Notification$Severity;", "title", "", "text", "urlData", "Lcom/android/tools/profilers/Notification$UrlData;", "<init>", "(Lcom/android/tools/profilers/Notification$Severity;Ljava/lang/String;Ljava/lang/String;Lcom/android/tools/profilers/Notification$UrlData;)V", "getSeverity", "()Lcom/android/tools/profilers/Notification$Severity;", "getTitle", "()Ljava/lang/String;", "getText", "getUrlData", "()Lcom/android/tools/profilers/Notification$UrlData;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Severity", "UrlData", "Companion", "intellij.android.profilers"})
public final class Notification {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Severity severity;
    @NotNull
    private final String title;
    @NotNull
    private final String text;
    @Nullable
    private final UrlData urlData;

    public Notification(@NotNull Severity severity, @NotNull String title, @NotNull String text, @Nullable UrlData urlData) {
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.severity = severity;
        this.title = title;
        this.text = text;
        this.urlData = urlData;
    }

    @NotNull
    public final Severity getSeverity() {
        return this.severity;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @Nullable
    public final UrlData getUrlData() {
        return this.urlData;
    }

    @NotNull
    public final Severity component1() {
        return this.severity;
    }

    @NotNull
    public final String component2() {
        return this.title;
    }

    @NotNull
    public final String component3() {
        return this.text;
    }

    @Nullable
    public final UrlData component4() {
        return this.urlData;
    }

    @NotNull
    public final Notification copy(@NotNull Severity severity, @NotNull String title, @NotNull String text, @Nullable UrlData urlData) {
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new Notification(severity, title, text, urlData);
    }

    public static /* synthetic */ Notification copy$default(Notification notification, Severity severity, String string, String string2, UrlData urlData, int n, Object object) {
        if ((n & 1) != 0) {
            severity = notification.severity;
        }
        if ((n & 2) != 0) {
            string = notification.title;
        }
        if ((n & 4) != 0) {
            string2 = notification.text;
        }
        if ((n & 8) != 0) {
            urlData = notification.urlData;
        }
        return notification.copy(severity, string, string2, urlData);
    }

    @NotNull
    public String toString() {
        return "Notification(severity=" + this.severity + ", title=" + this.title + ", text=" + this.text + ", urlData=" + this.urlData + ")";
    }

    public int hashCode() {
        int result = this.severity.hashCode();
        result = result * 31 + this.title.hashCode();
        result = result * 31 + this.text.hashCode();
        result = result * 31 + (this.urlData == null ? 0 : this.urlData.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Notification)) {
            return false;
        }
        Notification notification = (Notification)other;
        if (this.severity != notification.severity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.title, (Object)notification.title)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)notification.text)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.urlData, (Object)notification.urlData);
    }

    @JvmStatic
    @NotNull
    public static final Notification createNotification(@NotNull Severity severity, @NotNull String title, @NotNull String text, boolean reportBug) {
        return Companion.createNotification(severity, title, text, reportBug);
    }

    @JvmStatic
    @NotNull
    public static final Notification createWarning(@NotNull String title, @NotNull String text) {
        return Companion.createWarning(title, text);
    }

    @JvmStatic
    @NotNull
    public static final Notification createError(@NotNull String title, @NotNull String text) {
        return Companion.createError(title, text);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/profilers/Notification$Companion;", "", "<init>", "()V", "createNotification", "Lcom/android/tools/profilers/Notification;", "severity", "Lcom/android/tools/profilers/Notification$Severity;", "title", "", "text", "reportBug", "", "createWarning", "createError", "intellij.android.profilers"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Notification createNotification(@NotNull Severity severity, @NotNull String title, @NotNull String text, boolean reportBug) {
            Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (reportBug) {
                UrlData url = new UrlData("https://issuetracker.google.com/issues/new?component=192708", "report a bug");
                return new Notification(severity, title, text, url);
            }
            return new Notification(severity, title, text, null);
        }

        @JvmStatic
        @NotNull
        public final Notification createWarning(@NotNull String title, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.createNotification(Severity.WARNING, title, text, false);
        }

        @JvmStatic
        @NotNull
        public final Notification createError(@NotNull String title, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.createNotification(Severity.ERROR, title, text, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/profilers/Notification$Severity;", "", "<init>", "(Ljava/lang/String;I)V", "INFO", "WARNING", "ERROR", "intellij.android.profilers"})
    public static final class Severity
    extends Enum<Severity> {
        public static final /* enum */ Severity INFO = new Severity();
        public static final /* enum */ Severity WARNING = new Severity();
        public static final /* enum */ Severity ERROR = new Severity();
        private static final /* synthetic */ Severity[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Severity[] values() {
            return (Severity[])$VALUES.clone();
        }

        public static Severity valueOf(String value) {
            return Enum.valueOf(Severity.class, value);
        }

        @NotNull
        public static EnumEntries<Severity> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = severityArray = new Severity[]{Severity.INFO, Severity.WARNING, Severity.ERROR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/profilers/Notification$UrlData;", "", "url", "", "text", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "getText", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.profilers"})
    public static final class UrlData {
        @NotNull
        private final String url;
        @NotNull
        private final String text;

        public UrlData(@NotNull String url, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.url = url;
            this.text = text;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final String component2() {
            return this.text;
        }

        @NotNull
        public final UrlData copy(@NotNull String url, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new UrlData(url, text);
        }

        public static /* synthetic */ UrlData copy$default(UrlData urlData, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = urlData.url;
            }
            if ((n & 2) != 0) {
                string2 = urlData.text;
            }
            return urlData.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "UrlData(url=" + this.url + ", text=" + this.text + ")";
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + this.text.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UrlData)) {
                return false;
            }
            UrlData urlData = (UrlData)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)urlData.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.text, (Object)urlData.text);
        }
    }
}

