/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.MemoryLiveAllocationTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import org.jetbrains.annotations.NotNull;

public class MemoryJvmtiDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs = Long.MIN_VALUE;
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myPollingService;
    private final MemoryLiveAllocationTable myLiveAllocationTable;
    private final Common.Session mySession;

    public MemoryJvmtiDataPoller(@NotNull Common.Session session, @NotNull MemoryLiveAllocationTable liveAllocationTable, @NotNull MemoryServiceGrpc.MemoryServiceBlockingStub pollingService) {
        super(POLLING_DELAY_NS);
        this.mySession = session;
        this.myLiveAllocationTable = liveAllocationTable;
        this.myPollingService = pollingService;
    }

    @Override
    public void poll() {
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setSession(this.mySession).setStartTime(this.myDataRequestStartTimestampNs).setEndTime(Long.MAX_VALUE);
        MemoryProfiler.MemoryData response = this.myPollingService.getJvmtiData(dataRequestBuilder.build());
        for (Memory.BatchAllocationContexts sample : response.getBatchAllocationContextsList()) {
            this.myLiveAllocationTable.insertAllocationContexts(this.mySession, sample);
        }
        for (Memory.BatchAllocationContexts sample : response.getBatchAllocationEventsList()) {
            this.myLiveAllocationTable.insertAllocationEvents(this.mySession, (Memory.BatchAllocationEvents)sample);
        }
        for (Memory.BatchJNIGlobalRefEvent batchJniEvent : response.getJniReferenceEventBatchesList()) {
            this.myLiveAllocationTable.insertJniReferenceData(this.mySession, batchJniEvent);
        }
        for (MemoryProfiler.AllocationSamplingRateEvent event : response.getAllocSamplingRateEventsList()) {
            this.myLiveAllocationTable.insertOrReplaceAllocationSamplingRateEvent(this.mySession, event);
        }
        if (response.getEndTimestamp() > this.myDataRequestStartTimestampNs) {
            this.myDataRequestStartTimestampNs = response.getEndTimestamp();
        }
    }
}

