/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore;

import com.android.tools.datastore.DataStoreDatabase;
import com.android.tools.datastore.LogService;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.datastore.database.UnifiedEventsTable;
import com.android.tools.profiler.proto.Common;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskDatabaseManager {
    public static final String METADATA_KEY_ORIGINAL_STREAM_ID = "original_stream_id";
    public static final String METADATA_KEY_ORIGINAL_PID = "original_pid";
    public static final String METADATA_KEY_TASK_TYPE = "task_type";
    public static final String METADATA_KEY_STUDIO_VERSION = "studio_version";
    public static final String METADATA_KEY_CREATED_AT = "created_at";
    @NotNull
    private final LogService myLogService;
    @NotNull
    private final Consumer<Throwable> myNoPiiExceptionHandler;
    @NotNull
    private final DataStoreTable.DataStoreTableErrorCallback myErrorCallback;
    @Nullable
    private DataStoreDatabase myTaskDatabase;
    @Nullable
    private UnifiedEventsTable myTaskEventTable;
    @Nullable
    private ImportedSessionMapping myImportedSessionMapping;
    private long myTaskSessionId = -1L;
    @Nullable
    private String myTaskDbPath;

    public TaskDatabaseManager(@NotNull LogService logService, @NotNull Consumer<Throwable> noPiiExceptionHandler, @NotNull DataStoreTable.DataStoreTableErrorCallback errorCallback) {
        this.myLogService = logService;
        this.myNoPiiExceptionHandler = noPiiExceptionHandler;
        this.myErrorCallback = errorCallback;
    }

    @Nullable
    public synchronized UnifiedEventsTable getTaskEventsTable() {
        return this.myTaskEventTable;
    }

    @Nullable
    public synchronized ImportedSessionMapping getImportedSessionMapping() {
        return this.myImportedSessionMapping;
    }

    public synchronized void setTaskDb(long sessionId, @Nullable String dbPath, @Nullable Common.ProfilerTaskType taskType, long streamId, int pid) {
        if (this.myTaskSessionId == sessionId && dbPath != null && dbPath.equals(this.myTaskDbPath)) {
            return;
        }
        this.shutdown();
        if (dbPath == null || dbPath.isEmpty()) {
            return;
        }
        DataStoreDatabase db = new DataStoreDatabase(dbPath, DataStoreDatabase.Characteristic.DURABLE, this.myLogService, this.myNoPiiExceptionHandler, false, true);
        if (taskType != null && pid != 0) {
            this.writeTaskDbMetadata(db.getConnection(), taskType, streamId, pid);
        } else {
            this.myImportedSessionMapping = this.createImportedSessionMappingFromMetadata(db.getConnection());
        }
        UnifiedEventsTable table = new UnifiedEventsTable();
        table.initialize(db.getConnection());
        DataStoreTable.addDataStoreErrorCallback(this.myErrorCallback);
        this.myTaskDatabase = db;
        this.myTaskEventTable = table;
        this.myTaskSessionId = sessionId;
        this.myTaskDbPath = dbPath;
    }

    public synchronized void unsetTaskDb(long sessionId) {
        if (this.myTaskSessionId == sessionId) {
            this.shutdown();
        }
    }

    public void shutdown() {
        if (this.myTaskDatabase != null) {
            this.myTaskDatabase.disconnect();
            this.myTaskDatabase = null;
            this.myImportedSessionMapping = null;
            this.myTaskEventTable = null;
            this.myTaskDbPath = null;
            this.myTaskSessionId = -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private ImportedSessionMapping createImportedSessionMappingFromMetadata(@NotNull Connection connection) {
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT key, value FROM _metadata WHERE key = 'original_stream_id' OR key = 'original_pid'");){
            long streamId = -1L;
            int pid = -1;
            while (rs.next()) {
                String key = rs.getString("key");
                if (METADATA_KEY_ORIGINAL_STREAM_ID.equals(key)) {
                    streamId = Long.parseLong(rs.getString("value"));
                    continue;
                }
                if (!METADATA_KEY_ORIGINAL_PID.equals(key)) continue;
                pid = Integer.parseInt(rs.getString("value"));
            }
            if (streamId == -1L) return null;
            if (pid == -1) return null;
            ImportedSessionMapping importedSessionMapping = new ImportedSessionMapping(streamId, pid);
            return importedSessionMapping;
        }
        catch (NumberFormatException | SQLException e) {
            this.myLogService.getLogger(TaskDatabaseManager.class).warn(e);
        }
        return null;
    }

    private void writeTaskDbMetadata(@NotNull Connection connection, @NotNull Common.ProfilerTaskType taskType, long streamId, int pid) {
        Statement stmt;
        try {
            stmt = connection.createStatement();
            try {
                stmt.execute("CREATE TABLE IF NOT EXISTS _metadata (key TEXT PRIMARY KEY,value TEXT);");
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.myLogService.getLogger(TaskDatabaseManager.class).error(e);
            return;
        }
        try {
            stmt = connection.prepareStatement("INSERT OR IGNORE INTO _metadata (key, value) VALUES (?, ?)");
            try {
                stmt.setString(1, METADATA_KEY_TASK_TYPE);
                stmt.setString(2, taskType.toString());
                stmt.addBatch();
                stmt.setString(1, METADATA_KEY_ORIGINAL_STREAM_ID);
                stmt.setString(2, String.valueOf(streamId));
                stmt.addBatch();
                stmt.setString(1, METADATA_KEY_ORIGINAL_PID);
                stmt.setString(2, String.valueOf(pid));
                stmt.addBatch();
                if (ApplicationManager.getApplication() != null) {
                    ApplicationInfo appInfo = ApplicationInfo.getInstance();
                    stmt.setString(1, METADATA_KEY_STUDIO_VERSION);
                    stmt.setString(2, appInfo.getMajorVersion() + "." + appInfo.getMinorVersion());
                    stmt.addBatch();
                }
                stmt.setString(1, METADATA_KEY_CREATED_AT);
                stmt.setString(2, String.valueOf(System.currentTimeMillis()));
                stmt.addBatch();
                stmt.executeBatch();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException e) {
            this.myLogService.getLogger(TaskDatabaseManager.class).error(e);
        }
    }

    public record ImportedSessionMapping(long realStreamId, int realPid) {
    }
}

