/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore;

import com.android.tools.datastore.LogService;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class DataStoreDatabase {
    @NotNull
    private final LogService myLogService;
    private final Connection myConnection;

    @NotNull
    private LogService.Logger getLogger() {
        return this.myLogService.getLogger(DataStoreDatabase.class);
    }

    public DataStoreDatabase(@NotNull String dbPath, @NotNull Characteristic characteristic, @NotNull LogService logService) {
        this(dbPath, characteristic, logService, t -> {}, true, false);
    }

    public DataStoreDatabase(@NotNull String dbPath, @NotNull Characteristic characteristic, @NotNull LogService logService, @NotNull Consumer<Throwable> noPiiExceptionHandler) {
        this(dbPath, characteristic, logService, noPiiExceptionHandler, true, false);
    }

    public DataStoreDatabase(@NotNull String dbPath, @NotNull Characteristic characteristic, @NotNull LogService logService, @NotNull Consumer<Throwable> noPiiExceptionHandler, boolean deleteFileOnOpen, boolean useAutoCommit) {
        this.myLogService = logService;
        Connection connection = null;
        try {
            Class.forName("org.sqlite.JDBC");
            switch (characteristic.ordinal()) {
                case 1: {
                    connection = DriverManager.getConnection("jdbc:sqlite::memory:");
                    break;
                }
                case 0: {
                    File parent;
                    File dbFile = new File(dbPath);
                    if (deleteFileOnOpen && dbFile.exists()) {
                        dbFile.delete();
                    }
                    if ((parent = dbFile.getParentFile()) != null && !parent.mkdirs() && !parent.exists()) {
                        this.getLogger().error("Unable to create parent directory");
                    }
                    connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", dbFile.getPath()));
                    break;
                }
                default: {
                    throw new RuntimeException("Characteristic not handled!");
                }
            }
            connection.setAutoCommit(useAutoCommit);
        }
        catch (ClassNotFoundException e) {
            this.getLogger().error(e);
        }
        catch (SQLException e) {
            noPiiExceptionHandler.accept(e);
        }
        this.myConnection = connection;
    }

    public void disconnect() {
        try {
            if (!this.myConnection.getAutoCommit()) {
                this.myConnection.commit();
            }
        }
        catch (SQLException e) {
            this.getLogger().error(e);
        }
        finally {
            try {
                if (!this.myConnection.isClosed()) {
                    this.myConnection.close();
                }
            }
            catch (SQLException e) {
                this.getLogger().error(e);
            }
        }
    }

    public Connection getConnection() {
        return this.myConnection;
    }

    public static enum Characteristic {
        DURABLE,
        PERFORMANT;

    }
}

