/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.repository.api.ProgressIndicatorAdapter;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B'\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\"\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u001a\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001a\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0012\u0010\u001c\u001a\u00020\u00112\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u001d\u001a\u00020\u00112\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/repository/api/ConsoleProgressIndicator;", "Lcom/android/repository/api/ProgressIndicatorAdapter;", "out", "Ljava/io/PrintStream;", "err", "canPrintProgress", "", "<init>", "(Ljava/io/PrintStream;Ljava/io/PrintStream;Z)V", "text", "", "secondaryText", "progress", "", "last", "getFraction", "setFraction", "", "printProgress", "forceShowProgress", "logMessage", "s", "e", "", "stream", "logWarning", "logError", "logInfo", "setText", "setSecondaryText", "android.sdktools.repository"})
public class ConsoleProgressIndicator
extends ProgressIndicatorAdapter {
    @NotNull
    private final PrintStream out;
    @NotNull
    private final PrintStream err;
    private final boolean canPrintProgress;
    @Nullable
    private String text;
    @Nullable
    private String secondaryText;
    private double progress;
    @Nullable
    private String last;

    @JvmOverloads
    public ConsoleProgressIndicator(@NotNull PrintStream out, @NotNull PrintStream err, boolean canPrintProgress) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        this.out = out;
        this.err = err;
        this.canPrintProgress = canPrintProgress;
        this.text = "";
        this.secondaryText = "";
    }

    public /* synthetic */ ConsoleProgressIndicator(PrintStream printStream, PrintStream printStream2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            PrintStream printStream3 = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream3, (String)"out");
            printStream = printStream3;
        }
        if ((n & 2) != 0) {
            PrintStream printStream4 = System.err;
            Intrinsics.checkNotNullExpressionValue((Object)printStream4, (String)"err");
            printStream2 = printStream4;
        }
        if ((n & 4) != 0) {
            bl = !Intrinsics.areEqual((Object)System.getenv("TERM"), (Object)"dumb");
        }
        this(printStream, printStream2, bl);
    }

    @Override
    public double getFraction() {
        return this.progress;
    }

    @Override
    public void setFraction(double progress) {
        this.progress = progress;
        this.printProgress(true);
    }

    private final void printProgress(boolean forceShowProgress) {
        if (!this.canPrintProgress) {
            return;
        }
        StringBuilder line = new StringBuilder();
        if (forceShowProgress || this.getFraction() > 0.0) {
            line.append("[");
            int i = 1;
            while ((double)i < (double)40 * this.progress) {
                line.append("=");
                ++i;
            }
            while (i < 40) {
                line.append(" ");
                ++i;
            }
            line.append("] ");
            Locale locale = Locale.US;
            String string = "%.0f%%";
            Object[] objectArray = new Object[]{(double)100 * this.progress};
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            line.append(string2);
            line.append(" ");
        }
        line.append(this.text);
        line.append(" ");
        line.append(this.secondaryText);
        StringBuilder stringBuilder = line.length() > 80 ? line.delete(80, line.length()) : line.append("                                                                                ", 0, 80 - line.length());
        line.append("\r");
        if (this.getFraction() >= 1.0) {
            line.append(System.lineSeparator());
        }
        String string = line.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String result = string;
        if (!Intrinsics.areEqual((Object)result, (Object)this.last)) {
            this.out.print(result);
            this.out.flush();
            this.last = result;
        }
    }

    private final void logMessage(String s, Throwable e, PrintStream stream) {
        if (this.progress > 0.0 && this.progress < 1.0) {
            this.out.print("                                                                                ");
            this.out.print("\r");
            this.last = null;
        }
        stream.println(s);
        Throwable throwable = e;
        if (throwable != null) {
            throwable.printStackTrace();
        }
        if (this.progress > 0.0 && this.progress < 1.0) {
            this.printProgress(false);
        }
    }

    @Override
    public void logWarning(@NotNull String s, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.logMessage("Warning: " + s, e, this.err);
    }

    @Override
    public void logError(@NotNull String s, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.logMessage("Error: " + s, e, this.err);
    }

    @Override
    public void logInfo(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.logMessage("Info: " + s, null, this.out);
    }

    @Override
    public void setText(@Nullable String text) {
        this.text = text;
        this.printProgress(false);
    }

    @Override
    public void setSecondaryText(@Nullable String text) {
        this.secondaryText = text;
        this.printProgress(false);
    }

    @JvmOverloads
    public ConsoleProgressIndicator(@NotNull PrintStream out, @NotNull PrintStream err) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        this(out, err, false, 4, null);
    }

    @JvmOverloads
    public ConsoleProgressIndicator(@NotNull PrintStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this(out, null, false, 6, null);
    }

    @JvmOverloads
    public ConsoleProgressIndicator() {
        this(null, null, false, 7, null);
    }
}

