/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.client.grpc;

import com.android.tools.idea.insights.IssueStats;
import com.android.tools.idea.insights.IssueStatsKt;
import com.android.tools.idea.insights.OperatingSystemInfo;
import com.android.tools.idea.insights.WithCount;
import com.google.firebase.crashlytics.v1main.Device;
import com.google.firebase.crashlytics.v1main.IntervalMetrics;
import com.google.firebase.crashlytics.v1main.OperatingSystem;
import com.google.firebase.crashlytics.v1main.ReportGroup;
import com.google.services.firebase.insights.datamodel.EventsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002\u001a&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002\u00a8\u0006\t"}, d2={"summarizeDevices", "Lcom/android/tools/idea/insights/IssueStats;", "", "", "Lcom/google/firebase/crashlytics/v1main/ReportGroup;", "minGroupSize", "", "minPercentage", "summarizeOses", "firebase"})
@SourceDebugExtension(value={"SMAP\nSummaryStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SummaryStats.kt\ncom/google/services/firebase/insights/client/grpc/SummaryStatsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1563#2:60\n1634#2,3:61\n1563#2:64\n1634#2,3:65\n*S KotlinDebug\n*F\n+ 1 SummaryStats.kt\ncom/google/services/firebase/insights/client/grpc/SummaryStatsKt\n*L\n35#1:60\n35#1:61,3\n50#1:64\n50#1:65,3\n*E\n"})
public final class SummaryStatsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IssueStats<Double> summarizeDevices(@NotNull List<ReportGroup> $this$summarizeDevices, int minGroupSize, double minPercentage) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$summarizeDevices, (String)"<this>");
        Iterable $this$map$iv = $this$summarizeDevices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReportGroup reportGroup = (ReportGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Device device = it.getDevice();
            Intrinsics.checkNotNullExpressionValue((Object)device, (String)"getDevice(...)");
            com.android.tools.idea.insights.Device device2 = EventsKt.fromProto(com.android.tools.idea.insights.Device.Companion, device);
            List list = it.getMetricsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMetricsList(...)");
            long l = ((IntervalMetrics)CollectionsKt.single((List)list)).getEventsCount().getValue();
            collection.add(new WithCount(l, (Object)device2));
        }
        List rawData = (List)destination$iv$iv;
        return IssueStatsKt.summarizeDevicesFromRawDataPoints((List)rawData, (int)minGroupSize, (double)minPercentage);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IssueStats<Double> summarizeOses(@NotNull List<ReportGroup> $this$summarizeOses, int minGroupSize, double minPercentage) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$summarizeOses, (String)"<this>");
        Iterable $this$map$iv = $this$summarizeOses;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReportGroup reportGroup = (ReportGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            OperatingSystem operatingSystem = it.getOperatingSystem();
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"getOperatingSystem(...)");
            OperatingSystemInfo operatingSystemInfo = EventsKt.fromProto(OperatingSystemInfo.Companion, operatingSystem);
            List list = it.getMetricsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMetricsList(...)");
            long l = ((IntervalMetrics)CollectionsKt.single((List)list)).getEventsCount().getValue();
            collection.add(new WithCount(l, (Object)operatingSystemInfo));
        }
        List rawData = (List)destination$iv$iv;
        return IssueStatsKt.summarizeOsesFromRawDataPoints((List)rawData, (int)minGroupSize, (double)minPercentage);
    }
}

