/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.action.connect;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.gradle.project.Info;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.model.AndroidModel;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.ModuleStateService;
import com.google.services.firebase.action.connect.ConnectProjectCallbackHandler;
import com.google.services.firebase.action.connect.FirebaseConnectSupportKt;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.config.FirebaseConfig;
import com.google.services.firebase.config.FirebaseLocalConfig;
import com.google.services.firebase.consolereceiver.CancellableReceiver;
import com.google.services.firebase.consolereceiver.ReceiverResult;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.google.services.firebase.view.SelectModuleDialog;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/google/services/firebase/action/connect/FirebaseConnectSupport;", "", "<init>", "()V", "connectToFirebase", "", "project", "Lcom/intellij/openapi/project/Project;", "androidModule", "Lcom/intellij/openapi/module/Module;", "getAndroidModuleToConnect", "filterEligibleModules", "", "modules", "", "PrepareConnectDialogTask", "ConnectDialogTask", "firebase"})
@SourceDebugExtension(value={"SMAP\nFirebaseConnectSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirebaseConnectSupport.kt\ncom/google/services/firebase/action/connect/FirebaseConnectSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,281:1\n774#2:282\n865#2,2:283\n*S KotlinDebug\n*F\n+ 1 FirebaseConnectSupport.kt\ncom/google/services/firebase/action/connect/FirebaseConnectSupport\n*L\n125#1:282\n125#1:283,2\n*E\n"})
public final class FirebaseConnectSupport {
    @NotNull
    public static final FirebaseConnectSupport INSTANCE = new FirebaseConnectSupport();

    private FirebaseConnectSupport() {
    }

    @JvmStatic
    @UiThread
    public static final void connectToFirebase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ApplicationManager.getApplication().assertIsDispatchThread();
        Module module = INSTANCE.getAndroidModuleToConnect(project);
        if (module == null) {
            return;
        }
        Module androidModule = module;
        FirebaseConnectSupport.connectToFirebase(androidModule);
    }

    @JvmStatic
    @UiThread
    public static final void connectToFirebase(@NotNull Module androidModule) {
        String applicationId;
        Intrinsics.checkNotNullParameter((Object)androidModule, (String)"androidModule");
        try {
            FirebaseUiUtils.checkGradleState(androidModule);
        }
        catch (FirebaseUiUtils.GradleStateException exception) {
            Messages.showWarningDialog((Project)androidModule.getProject(), (String)FirebaseBundle.message("firebaseService.userError.gradleSyncNeeded", new Object[0]), (String)FirebaseBundle.message("firebase.service.dialog.title", new Object[0]));
            return;
        }
        AndroidModel androidModel = AndroidModel.Companion.get(androidModule);
        String string = applicationId = androidModel != null ? androidModel.getApplicationId() : null;
        if (Intrinsics.areEqual((Object)applicationId, (Object)"uninitialized.application.id")) {
            Messages.showWarningDialog((Project)androidModule.getProject(), (String)FirebaseBundle.message("firebaseService.userError.noApplicationId", new Object[0]), (String)FirebaseBundle.message("firebase.service.dialog.title", new Object[0]));
            return;
        }
        new PrepareConnectDialogTask(androidModule).queue();
    }

    private final Module getAndroidModuleToConnect(Project project) {
        List list = Info.getInstance((Project)project).getAndroidModules();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAndroidModules(...)");
        List<Module> eligibleModules = this.filterEligibleModules(list);
        if (eligibleModules.isEmpty()) {
            FirebaseUiUtils.showTrackedErrorBalloon(project, null, "firebaseConnectAction.userError.couldNotFindAndroidModule", new Object[0]);
            return null;
        }
        Object object = (Module)CollectionsKt.singleOrNull(eligibleModules);
        if (object == null) {
            FirebaseConnectSupport $this$getAndroidModuleToConnect_u24lambda_u240 = this;
            boolean bl = false;
            SelectModuleDialog moduleDialog = new SelectModuleDialog(project, (Collection<? extends Module>)eligibleModules);
            object = moduleDialog.showAndGet() ? moduleDialog.getSelectedModule() : null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Module> filterEligibleModules(Collection<? extends Module> modules) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = modules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Module input = (Module)element$iv$iv;
            boolean bl = false;
            AndroidFacet androidFacet = AndroidFacet.getInstance((Module)input);
            boolean bl2 = androidFacet != null && (androidFacet = (AndroidFacetConfiguration)androidFacet.getConfiguration()) != null ? androidFacet.isAppProject() : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001c\u0010\u000f\u001a\u00020\u00052\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/google/services/firebase/action/connect/FirebaseConnectSupport$ConnectDialogTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "androidModule", "Lcom/intellij/openapi/module/Module;", "packageName", "", "<init>", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "run", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "generateConsoleConnectUrl", "localPort", "", "mapAsUrlParameters", "params", "", "firebase"})
    @SourceDebugExtension(value={"SMAP\nFirebaseConnectSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirebaseConnectSupport.kt\ncom/google/services/firebase/action/connect/FirebaseConnectSupport$ConnectDialogTask\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,281:1\n126#2:282\n153#2,3:283\n*S KotlinDebug\n*F\n+ 1 FirebaseConnectSupport.kt\ncom/google/services/firebase/action/connect/FirebaseConnectSupport$ConnectDialogTask\n*L\n277#1:282\n277#1:283,3\n*E\n"})
    private static final class ConnectDialogTask
    extends Task.Modal {
        @NotNull
        private final Module androidModule;
        @NotNull
        private final String packageName;

        public ConnectDialogTask(@NotNull Module androidModule, @NotNull String packageName) {
            Intrinsics.checkNotNullParameter((Object)androidModule, (String)"androidModule");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            super(androidModule.getProject(), FirebaseBundle.message("ui.connect.dialog.action.connect.start", new Object[0]), true);
            this.androidModule = androidModule;
            this.packageName = packageName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator progressIndicator) {
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            try {
                AutoCloseable autoCloseable = new CancellableReceiver(ConnectProjectCallbackHandler.getFactory(this.androidModule));
                Throwable throwable = null;
                try {
                    CancellableReceiver server = (CancellableReceiver)autoCloseable;
                    boolean bl = false;
                    server.start();
                    BrowserUtil.browse((String)this.generateConsoleConnectUrl(server.getPort(), this.packageName));
                    ReceiverResult result = server.waitForRequest(() -> ConnectDialogTask.run$lambda$1$lambda$0(progressIndicator));
                    if (result.status == ReceiverResult.Status.SUCCESS) {
                        FirebaseUiUtils.showInfoBalloonWithLink(this.androidModule.getProject(), result.resultMessage, new OpenUrlHyperlink("https://firebase.google.com/docs/android/setup", FirebaseBundle.message("firebase.service.notification.connect.process.complete.learnMore", new Object[0])));
                        ModuleStateService.Companion.getInstance().updateModuleState(this.androidModule, false);
                    } else {
                        FirebaseUiUtils.showErrorBalloon(this.androidModule.getProject(), result.resultMessage, result.exception);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                FirebaseConnectSupportKt.access$getLOGGER$p().warn("Exception while running FirebaseConnect local server.", (Throwable)e);
            }
        }

        private final String generateConsoleConnectUrl(int localPort, String packageName) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"forceCheckTos", (Object)"true"), TuplesKt.to((Object)"localPort", (Object)String.valueOf(localPort)), TuplesKt.to((Object)"packageName", (Object)packageName), TuplesKt.to((Object)"projectDisplayName", (Object)this.androidModule.getProject().getName()), TuplesKt.to((Object)"appConfigVersion", (Object)"2")};
            String params = this.mapAsUrlParameters(MapsKt.mapOf((Pair[])pairArray));
            return "https://console.firebase.google.com/u/0/androidstudio/connectapp?" + params;
        }

        /*
         * WARNING - void declaration
         */
        private final String mapAsUrlParameters(Map<String, String> params) {
            void $this$mapTo$iv$iv;
            Map<String, String> $this$map$iv = params;
            boolean $i$f$map = false;
            Map<String, String> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                collection.add(key + "=" + value);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        }

        private static final boolean run$lambda$1$lambda$0(ProgressIndicator $progressIndicator) {
            return $progressIndicator.isCanceled();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/google/services/firebase/action/connect/FirebaseConnectSupport$PrepareConnectDialogTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "androidModule", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "showAlreadyConnectedDialog", "packageName", "", "projectDisplayName", "androidApplicationModule", "firebase"})
    private static final class PrepareConnectDialogTask
    extends Task.Backgroundable {
        @NotNull
        private final Module androidModule;

        public PrepareConnectDialogTask(@NotNull Module androidModule) {
            Intrinsics.checkNotNullParameter((Object)androidModule, (String)"androidModule");
            super(androidModule.getProject(), FirebaseBundle.message("ui.connect.dialog.action.preconnect.start", new Object[0]));
            this.androidModule = androidModule;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            Object packageName;
            FirebaseConfig firebaseConfig;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            indicator.setIndeterminate(true);
            try {
                firebaseConfig = new FirebaseConfig(this.androidModule);
            }
            catch (FirebaseLocalConfig.InvalidLocalConfigException configException) {
                Project project = this.androidModule.getProject();
                String string = configException.getMessage();
                if (string == null) {
                    string = "";
                }
                FirebaseUiUtils.showErrorBalloon(project, string, configException);
                return;
            }
            FirebaseConfig firebaseConfig2 = firebaseConfig;
            if (indicator.isCanceled()) {
                return;
            }
            if (firebaseConfig2.getRegisterableAndroidClients().isEmpty()) {
                FirebaseUiUtils.showErrorBalloon(this.androidModule.getProject(), FirebaseBundle.message("ui.connect.dialog.error.no.clients", new Object[0]), null);
                return;
            }
            Set<AndroidClient> set = firebaseConfig2.getRegisterableAndroidClients();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getRegisterableAndroidClients(...)");
            Object object = (AndroidClient)CollectionsKt.firstOrNull((Iterable)set);
            if (object == null || (object = ((AndroidClient)object).getPackageName()) == null) {
                object = "";
            }
            if (((CharSequence)(packageName = object)).length() == 0) {
                FirebaseUiUtils.showErrorBalloon(this.androidModule.getProject(), "AndroidClientFound does not contain a package name", null);
                return;
            }
            String string = firebaseConfig2.getLocalFirebaseConfigProjectId();
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.showAlreadyConnectedDialog((String)packageName, it, this.androidModule);
                return;
            }
            new ConnectDialogTask(this.androidModule, (String)packageName).queue();
        }

        private final void showAlreadyConnectedDialog(String packageName, String projectDisplayName, Module androidApplicationModule) {
            String EXTRA_CSS = "body { padding-bottom: 10px; background-color: " + UIUtils.getCssColor((Color)UIUtils.getAsStandardBackgroundColor()) + "; width: 500px; }";
            ApplicationManager.getApplication().invokeLater(() -> PrepareConnectDialogTask.showAlreadyConnectedDialog$lambda$1(projectDisplayName, EXTRA_CSS, androidApplicationModule, packageName));
        }

        private static final void showAlreadyConnectedDialog$lambda$1(String $projectDisplayName, String $EXTRA_CSS, Module $androidApplicationModule, String $packageName) {
            JTextPane dialogBody = new JTextPane();
            Object[] objectArray = new Object[]{$projectDisplayName};
            UIUtils.setHtml((JEditorPane)dialogBody, (String)FirebaseBundle.message("connect.reconnect.dialog.matchFoundWithName", objectArray), (String)$EXTRA_CSS);
            DialogBuilder dialogBuilder = new DialogBuilder($androidApplicationModule.getProject());
            dialogBuilder.setTitle(FirebaseBundle.message("connect.reconnect.dialog.title", new Object[0]));
            dialogBuilder.setCenterPanel((JComponent)dialogBody);
            dialogBuilder.removeAllActions();
            dialogBuilder.addOkAction();
            dialogBuilder.addCancelAction();
            if (dialogBuilder.show() == 0) {
                new ConnectDialogTask($androidApplicationModule, $packageName).queue();
            }
        }
    }
}

